import javax.media.jai.*;

import com.sun.media.jai.codec.ByteArraySeekableStream;
import com.sun.media.jai.codec.SeekableStream;
import ca.forklabs.media.jai.codec.RadianceDecodeParam;
import ca.forklabs.media.jai.codecimpl.radiance.RadianceImageDecoder;
import ca.forklabs.media.jai.codecimpl.radiance.*; 


class HDRCubeMapLoader
{
  final static int CUBE_FACE_NEGATIVE_X = 1;
  final static int CUBE_FACE_POSITIVE_X = 0;
  final static int CUBE_FACE_NEGATIVE_Y = 3;
  final static int CUBE_FACE_POSITIVE_Y = 2;
  final static int CUBE_FACE_NEGATIVE_Z = 5;
  final static int CUBE_FACE_POSITIVE_Z = 4; 
  
  int[] pixels;
  float[] pixelsFloat;

  float[][] _hdrCubemapHDRFloat;
  XTexture[] _hdrCubemapHDRTexture;
  XTexture _CubemapHDR;
  int _cubemapHDRFaceSize;   
  
  
  RenderedImage _image;
  int _imageWidth;
  int _imageHeight;
  int _stop;
  
  float _exposure;
  float _brightThreshold;
  
  Color3 _etaRatioRGB; 
  
  
  HDRCubeMapLoader( String filename, float exposure, float brightThres )
  {
    _exposure = exposure; //0.86f; //1.0;
    _brightThreshold = brightThres; //1.2; //0.05;     


    _etaRatioRGB = new Color3( 1.14, 1.12, 1.10 );
//    _etaRatioRGB = new Color3( 0.8, 0.8, 0.8 ); 

    try
    {
      RadianceCodec.register();

      testDecode( filename ); //dataPath("spheron_02_cubemap.hdr") );
//        testDecode( dataPath("rnl_probe.hdr") );
    } catch( IOException e )
    {
      println( e );
    }     
  }
  
  
   /**
    * Tests the decoding of the three line format.
    * @throws   IOException   if anything goes wrong with I/O.
    */
   public void testDecode( String filename ) throws IOException 
   {
      int[] idata = new int[] 
      {
         2, 2, 0, 5, 133, 153, 133, 10, 133, 51, 133, 127,
         153, 10, 51, 127, 1, 1, 1, 4,
         153, 10, 51, 127, 153, 10, 51, 127, 153, 10, 51, 127, 153, 10, 51, 127, 153, 10, 51, 127,
      };

      int len = idata.length;
      byte[] data = new byte[len];
      for (int i = 0; i < len; i++) 
      {
         data[i] = (byte) idata[i];
      }

      String header =
      "#?RADIANCE\n" +
      "pvalue -s 15 -h -df -r -y 480 +x 720\n" +
      "FORMAT=32-bit_rle_rgbe\n" +
      "\n" +
      "-Y 3 +X 5\n" + new String(data);


/*    try {
       FileInputStream is = new FileInputStream( new File(filename) );
       RenderedImage image = JAI.create("HDR", SeekableStream.wrapInputStream(is, false), new FPXDecodeParam());
       }
    catch (Exception e) {
       e.printStackTrace();
       }*/


      _image = JAI.create( "fileload", filename );

/*      SeekableStream ss = new ByteArraySeekableStream( header.getBytes() );
      RadianceDecodeParam param = new RadianceDecodeParam( true );
//      OpenRadianceImageDecoder decoder = new OpenRadianceImageDecoder( ss );
      OpenRadianceImageDecoder decoder = new OpenRadianceImageDecoder( ss, param );
      
      RenderedImage ri = decoder.decodeAsRenderedImage();*/
      _imageWidth = _image.getWidth();
      _imageHeight = _image.getHeight();
      println( "loaded image dim: " + _imageWidth + ", " + _imageHeight );

      readHDRImage( 3 );    // read as RGB image
      
/*      float[][] pixels = decoder.decode();

      println( decoder.getWidth() );
      println( decoder.getHeight() );
      for (int i = 0; i < 3 * 5; i++) 
      {
         println( pixels[0][i] );
         println( pixels[1][i] );
         println( pixels[2][i] );
      }*/
/*      assertEquals(3, decoder.getHeight());
      assertEquals(5, decoder.getWidth());
      assertEquals(3 * 5, pixels[0].length);
      for (int i = 0; i < 3 * 5; i++) 
      {
         assertEquals(0.3f,  pixels[0][i], 10e-4f);
         assertEquals(0.02f, pixels[1][i], 10e-4f);
         assertEquals(0.1f,  pixels[2][i], 10e-4f);
      }*/
  }



  void readHDRImage( int pixelSize )
  {
    BufferedImage cooked_image = new BufferedImage( _imageWidth, _imageHeight, BufferedImage.TYPE_INT_RGB );
    
    Raster raw_raster = _image.getData();
    WritableRaster cooked_raster = cooked_image.getRaster();
    float gamma = 2.2f;

    _stop = 0;
    
    // this is what HDRShop does, based on personnal communications
    double exposure = Math.pow( 2.0, _stop );
    double inverse_gamma = 1.0 / gamma;

    int minx = raw_raster.getMinX();
    int miny = raw_raster.getMinY();
    int maxx = minx + _imageWidth;
    int maxy = miny + _imageHeight;

    int bands = raw_raster.getNumBands();
    float[] raw = new float[bands];
    int[] cooked = new int[bands];
    
    pixels = new int[maxx*maxy];    
    pixelsFloat = new float[maxx*maxy*pixelSize];

    int index = 0;
    for (int y = miny; y < maxy; y++) 
    {
      for (int x = minx; x < maxx; x++) 
      {
         raw = raw_raster.getPixel( x, y, raw );
    
         int red   = (int) (Math.pow(raw[0] * exposure, inverse_gamma) * 256.0);
         int green = (int) (Math.pow(raw[1] * exposure, inverse_gamma) * 256.0);
         int blue  = (int) (Math.pow(raw[2] * exposure, inverse_gamma) * 256.0);

         red = Math.min(red, 255);   
         red = Math.max(red, 0);

         green = Math.min(green, 255);
         green = Math.max(green, 0);

         blue = Math.min(blue, 255);
         blue = Math.max(blue, 0);

         cooked[0] = red;
         cooked[1] = green;
         cooked[2] = blue;

         cooked_raster.setPixel( x, y, cooked );

         pixels[x+y*maxx] = color( cooked[0], cooked[1], cooked[2] );

         //
         // Create float buffer
         //
         float redf   = (float)Math.pow(raw[0] * exposure, inverse_gamma);
         float greenf = (float)Math.pow(raw[1] * exposure, inverse_gamma);
         float bluef  = (float)Math.pow(raw[2] * exposure, inverse_gamma);

         pixelsFloat[index+0] = redf;
         pixelsFloat[index+1] = greenf;
         pixelsFloat[index+2] = bluef;
         index += pixelSize;
      }
    }
    cooked_image.flush();


/*    VImage img = new VImage( maxx, maxy, VImage.BGRA );
    img.setData( pixels );
    
    _hdrTexture = new VTexture2D( _gl );
    _hdrTexture.loadFromImage( img, false );

    _hdrTextureFloat = new XTexture();
    _hdrTextureFloat.createGLFloat16Bit( GL.GL_RGBA16F_ARB, GL.GL_RGB, maxx, maxy, pixelsFloat );
*/
    
    extractCubemapFaces( pixelSize );
  }


  void flipImageHorizontal( int w, int h, int pixelsize, float[] buf )
  {
/*    int stride = 1;
    int w = _cubemapHDRFaceSize;
    int h = _cubemapHDRFaceSize;
    int m = h / 2;
    float[] temp = new float[ stride ];
    
    for (int y=0 ; y<m ; ++y)
    {
      for (int x=0 ; x<w ; ++x)
      {
	int offset = (y*w+x)*stride;
	int offsetOpp = ((h-y-1)*w+x)*stride;

        System.arraycopy( buf, offset, temp, 0, stride );
        System.arraycopy( buf, offsetOpp, temp, offset, stride );
        System.arraycopy( temp, 0, buf, offsetOpp, stride );
//	memcpy(temp, data+offset, stride);
//	memcpy(data+offset, data+offsetOpp, stride);
//	memcpy(data+offsetOpp, temp, stride);
      }
    }*/
    float[] temp = new float[ w*h*pixelsize ];
    System.arraycopy( buf, 0, temp, 0, w*h*pixelsize );
    for( int j=0; j<h; j++ )
    {
      for( int i=0; i<w*pixelsize; i++ )
      {
        buf[i+j*(w*pixelsize)] = temp[((w*pixelsize-1)-i)+j*(w*pixelsize)];
      }
    }
    
    // flip back RGB channels
    // the loop before we're swapping every channel, not pixel, so we need to ger data back to the correct format, RGB.
    int index = 0;
    for( int j=0; j<h; j++ )
    {
      for( int i=0; i<w*pixelsize; i+=pixelsize )
      {
        float b = buf[i+0+j*(w*pixelsize)];
        float g = buf[i+1+j*(w*pixelsize)];
        float r = buf[i+2+j*(w*pixelsize)];
        buf[i+0+j*(w*pixelsize)] = r;
        buf[i+1+j*(w*pixelsize)] = g;
        buf[i+2+j*(w*pixelsize)] = b;
/*        
        float b = buf[index+0];
        float g = buf[index+1];
        float r = buf[index+2];
        buf[index+0] = r;
        buf[index+1] = g;
        buf[index+2] = b;
        index += 3;*/
      }
    }
    
  }
    

  void flipImageVertical( int w, int h, int pixelsize, float[] buf )
  {
/*    int stride = 1;
    int w = _cubemapHDRFaceSize;
    int h = _cubemapHDRFaceSize;
    int m = w / 2;
    float[] temp = new float[ stride ];
    
    for (int y=0 ; y<h ; ++y)
    {
      for (int x=0 ; x<m ; ++x)
      {
        int offset = (y*w+x)*stride;
	int offsetOpp = (y*w+(w-x-1))*stride;

        System.arraycopy( buf, offset, temp, 0, stride );
        System.arraycopy( buf, offsetOpp, temp, offset, stride );
        System.arraycopy( temp, 0, buf, offsetOpp, stride );
//	memcpy(temp, data+offset, stride);
//	memcpy(data+offset, data+offsetOpp, stride);
//	memcpy(data+offsetOpp, temp, stride);
      }
    }*/
    
    float[] temp = new float[ w*h*pixelsize ];
    System.arraycopy( buf, 0, temp, 0, w*h*pixelsize );
    for( int j=0; j<h; j++ )
    {
      for( int i=0; i<w*pixelsize; i++ )
      {
        buf[i+j*(w*pixelsize)] = temp[i+((h-1)-j)*(w*pixelsize)];
      }
    }
  }



  void extractCubemapFaces( int pixelSize )
  {    
    // Calculate faces width and height
    int w = _imageWidth / 3;
    int h = _imageHeight / 4;
    println( "face size: " + w + ", " + h );
    
    // Check that the input image is really a cross cube map
    if (w != h) println( "this map is not really a cross cube map" );

    _cubemapHDRFaceSize = w;

    _hdrCubemapHDRFloat = new float[6][];
    _hdrCubemapHDRTexture = new XTexture[6];
    for( int i=0; i<6; i++ )
    {
      _hdrCubemapHDRTexture[i] = new XTexture();
      _hdrCubemapHDRFloat[i] = new float[w*h*pixelSize];
    }
    
   
    for( int y=0 ; y<_imageHeight; ++y )
    {
      for( int x=0 ; x<3 ; ++x )
      {
        // Calculate stride, source offset and face offset
	int stride = w * 3;
	int srcOffset = 3 * (y * _imageWidth + x * w);
	int offset = 3 * ((y%h) * w);

        // CUBE_FACE_POSITIVE_X
        if( y>=h && y<2*h && x==2 )
        {
	  System.arraycopy( pixelsFloat, srcOffset, _hdrCubemapHDRFloat[CUBE_FACE_POSITIVE_X], offset, stride );
        }

        // CUBE_FACE_NEGATIVE_X
        if (y>=h && y<2*h && x==0)
        {
	  System.arraycopy( pixelsFloat, srcOffset, _hdrCubemapHDRFloat[CUBE_FACE_NEGATIVE_X], offset, stride );
        }

        // CUBE_FACE_POSITIVE_Y
        if (y>=0 && y<h && x==1)
        {
	  System.arraycopy( pixelsFloat, srcOffset, _hdrCubemapHDRFloat[CUBE_FACE_POSITIVE_Y], offset, stride );
        }

        // CUBE_FACE_NEGATIVE_Y
        if (y>=2*h && y<3*h && x==1)
        {
	  System.arraycopy( pixelsFloat, srcOffset, _hdrCubemapHDRFloat[CUBE_FACE_NEGATIVE_Y], offset, stride );
        }
        
        // CUBE_FACE_POSITIVE_Z
        if (y>=h && y<2*h && x==1)
        {
	  System.arraycopy( pixelsFloat, srcOffset, _hdrCubemapHDRFloat[CUBE_FACE_POSITIVE_Z], offset, stride );
        }
        
        // CUBE_FACE_NEGATIVE_Z
        if (y>=3*h && y<4*h && x==1)
        {
	  System.arraycopy( pixelsFloat, srcOffset, _hdrCubemapHDRFloat[CUBE_FACE_NEGATIVE_Z], offset, stride );
        }
      }
    }

    // Need to flip horizontally and vertically the negative Z face
    flipImageHorizontal( _cubemapHDRFaceSize, _cubemapHDRFaceSize, pixelSize, _hdrCubemapHDRFloat[CUBE_FACE_NEGATIVE_Z] );
    flipImageVertical( _cubemapHDRFaceSize, _cubemapHDRFaceSize, pixelSize, _hdrCubemapHDRFloat[CUBE_FACE_NEGATIVE_Z] );
    

/*    // Upload textures to opengl
    _hdrCubemapHDRTexture[CUBE_FACE_POSITIVE_X].createGLFloat16Bit( GL.GL_RGBA16F_ARB, GL.GL_RGB, w, h, _hdrCubemapHDRFloat[CUBE_FACE_POSITIVE_X] );
    _hdrCubemapHDRTexture[CUBE_FACE_NEGATIVE_X].createGLFloat16Bit( GL.GL_RGBA16F_ARB, GL.GL_RGB, w, h, _hdrCubemapHDRFloat[CUBE_FACE_NEGATIVE_X] );
    _hdrCubemapHDRTexture[CUBE_FACE_POSITIVE_Y].createGLFloat16Bit( GL.GL_RGBA16F_ARB, GL.GL_RGB, w, h, _hdrCubemapHDRFloat[CUBE_FACE_POSITIVE_Y] );
    _hdrCubemapHDRTexture[CUBE_FACE_NEGATIVE_Y].createGLFloat16Bit( GL.GL_RGBA16F_ARB, GL.GL_RGB, w, h, _hdrCubemapHDRFloat[CUBE_FACE_NEGATIVE_Y] );
    _hdrCubemapHDRTexture[CUBE_FACE_POSITIVE_Z].createGLFloat16Bit( GL.GL_RGBA16F_ARB, GL.GL_RGB, w, h, _hdrCubemapHDRFloat[CUBE_FACE_POSITIVE_Z] );
    _hdrCubemapHDRTexture[CUBE_FACE_NEGATIVE_Z].createGLFloat16Bit( GL.GL_RGBA16F_ARB, GL.GL_RGB, w, h, _hdrCubemapHDRFloat[CUBE_FACE_NEGATIVE_Z] );*/
    
    _CubemapHDR = new XTexture();
    _CubemapHDR.createCubemapFloat( GL.GL_RGBA16F_ARB, GL.GL_FLOAT, w, h, _hdrCubemapHDRFloat, true );
//    _CubemapHDR.createCubemapFloat( GL.GL_RGBA16F_ARB, GL.GL_FLOAT, w, h, _hdrCubemapHDRFloat );
//    _CubemapHDR.createCubemapFloat( GL.GL_RGBA16F_ARB, GL.GL_HALF_FLOAT_ARB, w, h, _hdrCubemapHDRFloat );
  } 

}  
