import org.jouvieje.bass.*;
import org.jouvieje.bass.defines.*; 
import org.jouvieje.bass.exceptions.InitException; 
import org.jouvieje.bass.Init;
import org.jouvieje.bass.exceptions.InitException;
import org.jouvieje.bass.structures.*;
import org.jouvieje.bass.structures.HCHANNEL;
import org.jouvieje.bass.structures.HMUSIC;
import org.jouvieje.bass.structures.HSAMPLE;
import org.jouvieje.bass.structures.HSTREAM; 
import org.jouvieje.bass.misc.BufferUtils.*;
import com.sun.opengl.util.BufferUtil;


	int SPECTRUM_WIDTH = 512;
	HSTREAM stream = null; 
        HMUSIC music = null;
        int chan = 0;
	ByteBuffer buffer = null;

	public void initBass()
	{
		// NativeBass Init
		try
		{
			Init.loadLibraries( org.jouvieje.bass.defines.INIT_MODES.INIT_BASS );
		}
		catch(InitException e)
		{
			println( "NativeBass error! " + e.getMessage() );
			return;
		}
		
		// Checking NativeBass version
		if( VERSIONS.NATIVEBASS_LIBRARY_VERSION != VERSIONS.NATIVEBASS_JAR_VERSION )
		{
			println ("Error!  NativeBass library version (%08x) is different to jar version (%08x)" + 
					VERSIONS.NATIVEBASS_LIBRARY_VERSION + ",  " + VERSIONS.NATIVEBASS_JAR_VERSION);
			return;
		}
		
		//init = true;
	}

	public void runBass()
	{
		//if(!init) return;

		// check the correct BASS was loaded
		if( ((Bass.BASS_GetVersion() & 0xFFFF0000) >> 16) != org.jouvieje.bass.defines.VERSIONS.BASSVERSION )
		{
			println("An incorrect version of BASS.DLL was loaded");
			return;
		}
		
		// Initialize default output device
		if( !Bass.BASS_Init( BassDevice.forceNoSoundDevice(-1), BassDevice.forceFrequency(44100), 0, null, null) )
                {
			println("Can't initialize device");
                }
		
		//timer.start();
	}

        float[] getSpectrum( int mode )
        {
            float[] data = null;
            if( mode == 0 )
            {
		// waveform
		BASS_CHANNELINFO ci = BASS_CHANNELINFO.create();
		Bass.BASS_ChannelGetInfo( chan, ci );					//Get number of channels
		final int channels = ci.getChannels();
		ci.release();

		int size = channels * spectrumLength * BufferUtil.SIZEOF_FLOAT;
		if( buffer == null || buffer.capacity() < size )
			buffer = org.jouvieje.bass.misc.BufferUtils.newByteBuffer(size);	//Allocate buffer for data

		Bass.BASS_ChannelGetData( chan, buffer, size | BASS_DATA.BASS_DATA_FLOAT );		//Get the sample data (floating-point to avoid 8 & 16 bit processing)
		FloatBuffer floats = buffer.asFloatBuffer();

                data = new float[ size/4 ];
//                println( "channels: " + channels + "    size: " + data.length + "    " + floats.capacity() );
                for( int i=0; i<floats.capacity()/2; i+=1 )
                {
                    data[i] = abs( floats.get( i ) );    //*channels+1 ) );
                }
            }
            else if( mode == 1 )
            {
		int size = spectrumLength * BufferUtil.SIZEOF_FLOAT;
		if( buffer == null || buffer.capacity() < size )
			buffer = org.jouvieje.bass.misc.BufferUtils.newByteBuffer(size);

                if( spectrumLength == 512 )
    		    Bass.BASS_ChannelGetData( chan, buffer, BASS_DATA.BASS_DATA_FFT1024 );	//Get the FFT data
                else if( spectrumLength == 1024 )
    		    Bass.BASS_ChannelGetData( chan, buffer, BASS_DATA.BASS_DATA_FFT2048 );	//Get the FFT data
                else if( spectrumLength == 2048 )
    		    Bass.BASS_ChannelGetData( chan, buffer, BASS_DATA.BASS_DATA_FFT4096 );	//Get the FFT data
    
		FloatBuffer floats = buffer.asFloatBuffer();

                data = new float[ size/4 ];
//                println( "size: " + data.length + "    " + floats.capacity() );
                for( int i=0; i<floats.capacity(); i++ )
                {
                    data[i] = sqrt( floats.get(i)*3 );//floats.get( i );
                }
            }

            return data;
        }
        
        
        int getChannelLevel()
        {
            return Bass.BASS_ChannelGetLevel( chan );
        }
        

	boolean playFile( String filename )
	{
		stream = null; 
                music = null;
		if( (stream = Bass.BASS_StreamCreateFile(false, filename, 0, 0, org.jouvieje.bass.defines.BASS_SAMPLE.BASS_SAMPLE_LOOP)) == null
                    && (music = Bass.BASS_MusicLoad(false, filename, 0, 0, org.jouvieje.bass.defines.BASS_MUSIC.BASS_MUSIC_RAMP | org.jouvieje.bass.defines.BASS_SAMPLE.BASS_SAMPLE_LOOP, 0)) == null)
		{
			println("Can't play file");
			return false; // Can't load the file
		}

		chan = (stream != null) ? stream.asInt() : ((music != null) ?  music.asInt() : 0);

		Bass.BASS_ChannelPlay( chan, false );
		return true;
	}


	public void stopBass()
	{
//		if(!init || deinit) return;
//		deinit = true;
		
//		timer.stop();
		
		Bass.BASS_Free();
	} 
