/*
 * Decompiled with CFR 0.152.
 */
package vitamin.scenegraph;

import java.util.Vector;
import vitamin.math.Matrix;
import vitamin.math.Quaternion;
import vitamin.math.Vector3;
import vitamin.scenegraph.Entity;

public class SceneNode {
    int _id;
    String _name;
    String _parentName;
    Matrix _localMatrix;
    Vector3 _position;
    Vector3 _scale;
    Quaternion _orientation;
    Matrix _worldMatrix;
    Vector3 _worldPosition;
    Entity _associatedEntity;
    SceneNode _parentNode;
    int _numChildren;
    Vector<SceneNode> _children;
    float _radius;

    public SceneNode() {
        this._name = null;
        this._children = new Vector();
        this._numChildren = 0;
        this._position = new Vector3();
        this._associatedEntity = null;
    }

    public SceneNode(String n) {
        this._name = n;
        this._children = new Vector();
        this._numChildren = 0;
        this._position = new Vector3();
        this._associatedEntity = null;
    }

    public void addChild(SceneNode sn) {
        sn._parentName = this._name;
        sn._parentNode = this;
        this._children.add(sn);
        ++this._numChildren;
    }

    public String getName() {
        return this._name;
    }

    public boolean hasParent() {
        return this._parentNode != null;
    }

    public SceneNode getChildByName(String name) {
        int i = 0;
        while (i < this._numChildren) {
            SceneNode n = this._children.get(i);
            if (n.getName() == name) {
                return n;
            }
            ++i;
        }
        return null;
    }

    public void setPosition(float x, float y, float z) {
        this._position.x = x;
        this._position.y = y;
        this._position.z = z;
    }

    public void setPosition(Vector3 v) {
        this._position = v;
    }

    public void attachEntity(Entity e) {
        this._associatedEntity = e;
    }

    public void render() {
        int i = 0;
        while (i < this._numChildren) {
            SceneNode n = this._children.get(i);
            n.render();
            ++i;
        }
    }

    public void compile() {
        int i = 0;
        while (i < this._numChildren) {
            SceneNode n = this._children.get(i);
            n._position = Vector3.add(n._position, n._parentNode._position);
            n.compile();
            ++i;
        }
    }

    public void traverseTopDown() {
        int i = 0;
        while (i < this._numChildren) {
            SceneNode n = this._children.get(i);
            System.out.println(String.valueOf(n._name) + ": " + n._position.x + "," + n._position.y + "," + n._position.z);
            n.render();
            n.traverseTopDown();
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum eTransformSpace {
        TS_LOCAL,
        TS_PARENT,
        TS_WORLD;

    }
}

