/*
 * Decompiled with CFR 0.152.
 */
package vitamin.math;

import vitamin.math.MathUtils;

public class Vector2 {
    public static final Vector2 X_AXIS = new Vector2(1.0f, 0.0f);
    public static final Vector2 Y_AXIS = new Vector2(1.0f, 0.0f);
    public static final Vector2 ZERO = new Vector2(0.0f, 0.0f);
    public float x;
    public float y;

    public Vector2() {
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vector2(float[] v) {
        this.x = v[0];
        this.y = v[1];
    }

    public Vector2(float xx, float yy) {
        this.x = xx;
        this.y = yy;
    }

    public Vector2(Vector2 v) {
        this.x = v.x;
        this.y = v.y;
    }

    public void set(float xx, float yy) {
        this.x = xx;
        this.y = yy;
    }

    public void set(Vector2 v) {
        this.x = v.x;
        this.y = v.y;
    }

    public void reset() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public Vector2 copy() {
        return new Vector2(this.x, this.y);
    }

    public Vector2 clone() {
        return new Vector2(this.x, this.y);
    }

    public void add(Vector2 v) {
        this.x += v.x;
        this.y += v.y;
    }

    public void sub(Vector2 v) {
        this.x -= v.x;
        this.y -= v.y;
    }

    public Vector2 subtract(Vector2 v) {
        Vector2 tmp = new Vector2();
        tmp.x = this.x - v.x;
        tmp.y = this.y - v.y;
        return tmp;
    }

    public void mul(Vector2 v) {
        this.x *= v.x;
        this.y *= v.y;
    }

    public void div(Vector2 v) {
        this.x /= v.x;
        this.y /= v.y;
    }

    public void mul(float s) {
        this.x *= s;
        this.y *= s;
    }

    public void div(float s) {
        this.x /= s;
        this.y /= s;
    }

    public float dot(Vector2 v) {
        return this.x * v.x + this.y * v.y;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public float lengthSqr() {
        return this.x * this.x + this.y * this.y;
    }

    public void normalize() {
        float m = this.length();
        if (m > 0.0f) {
            this.div(m);
        }
    }

    public boolean SetCatmullRom(Vector2 V1, Vector2 V2, Vector2 V3, Vector2 V4, float s) {
        float ss = s * s;
        float sss = s * ss;
        float a = -0.5f * sss + ss - 0.5f * s;
        float b = 1.5f * sss - 2.5f * ss + 1.0f;
        float c = -1.5f * sss + 2.0f * ss + 0.5f * s;
        float d = 0.5f * sss - 0.5f * ss;
        this.x = a * V1.x + b * V2.x + c * V3.x + d * V4.x;
        this.y = a * V1.y + b * V2.y + c * V3.y + d * V4.y;
        return true;
    }

    public boolean SetHermite(Vector2 V1, Vector2 T1, Vector2 V2, Vector2 T2, float s) {
        float ss = s * s;
        float sss = s * ss;
        float a = 2.0f * sss - 3.0f * ss + 1.0f;
        float b = -2.0f * sss + 3.0f * ss;
        float c = sss - 2.0f * ss + s;
        float d = sss - ss;
        this.x = a * V1.x + b * V2.x + c * T1.x + d * T2.x;
        this.y = a * V1.y + b * V2.y + c * T1.y + d * T2.y;
        return true;
    }

    public boolean SetBaryCentric(Vector2 V1, Vector2 V2, Vector2 V3, float f, float g) {
        this.x = V1.x + f * (V2.x - V1.x) + g * (V3.x - V1.x);
        this.y = V1.y + f * (V2.y - V1.y) + g * (V3.y - V1.y);
        return true;
    }

    public Vector2 lerp(Vector2 V1, float s) {
        return new Vector2(this.x + s * (V1.x - this.x), this.y + s * (V1.y - this.y));
    }

    public static Vector2 add(Vector2 a, Vector2 b) {
        return new Vector2(a.x + b.x, a.y + b.y);
    }

    public static Vector2 sub(Vector2 a, Vector2 b) {
        return new Vector2(a.x - b.x, a.y - b.y);
    }

    public static Vector2 mul(Vector2 a, Vector2 b) {
        return new Vector2(a.x * b.x, a.y * b.y);
    }

    public static Vector2 mul(Vector2 a, float val) {
        return new Vector2(a.x * val, a.y * val);
    }

    public static float dot(Vector2 v1, Vector2 v2) {
        return v1.x * v2.x + v1.y * v2.y;
    }

    public static float distance(Vector2 v1, Vector2 v2) {
        float dx = v1.x - v2.x;
        float dy = v1.y - v2.y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static float angleBetween(Vector2 v1, Vector2 v2) {
        float dot = v1.dot(v2);
        float theta = (float)Math.acos(dot / (v1.length() * v2.length()));
        return theta;
    }

    public static Vector2 randomVector() {
        Vector2 rnd = new Vector2();
        rnd.x = MathUtils.normalizedRandom();
        rnd.y = MathUtils.normalizedRandom();
        rnd.normalize();
        return rnd;
    }

    public void debug() {
        System.out.println(String.valueOf(this.x) + ", " + this.y);
    }

    public String toString() {
        return new String(String.valueOf(this.x) + ", " + this.y);
    }
}

