/*
 * Decompiled with CFR 0.152.
 */
package vitamin.jsr231;

import com.sun.opengl.util.Animator;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.EventListener;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLEventListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class GLJFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private GLEventListener listener;
    private GLCapabilities caps;
    private GLCapabilitiesChooser chooser;
    private Animator animator;
    private GLContext contextToShareWith;
    private Canvas mainCanvas;

    public GLJFrame(GLEventListener listener) {
        this("OpenGL Window", listener);
    }

    public GLJFrame(String title, GLEventListener listener) {
        super(title);
        this.listener = listener;
        this.caps = new GLCapabilities();
        this.chooser = null;
        this.initComponents();
        ((GLCanvas)this.mainCanvas).addGLEventListener(listener);
        this.animator = null;
        this.contextToShareWith = null;
    }

    public GLJFrame(String title, GLEventListener listener, GLCapabilities caps, GLCapabilitiesChooser chooser, GLContext contextToShareWith) {
        super(title);
        this.listener = listener;
        this.caps = caps;
        this.chooser = chooser;
        this.contextToShareWith = contextToShareWith;
        this.initComponents();
        ((GLCanvas)this.mainCanvas).addGLEventListener(listener);
        this.animator = null;
    }

    public GLJFrame(String title, GLEventListener listener, GLCapabilities capabilities) {
        this(title, listener, capabilities, null, null);
    }

    public GLJFrame(String title, GLEventListener listener, GLCapabilities capabilities, GLCapabilitiesChooser chooser) {
        this(title, listener, capabilities, chooser, null);
    }

    public GLJFrame(GLEventListener listener, GLContext contextToShareWith) {
        this(listener);
        this.contextToShareWith = contextToShareWith;
    }

    public GLJFrame(GLEventListener listener, GLCapabilities capabilities) {
        this("OpenGL Window", listener, capabilities);
    }

    public GLJFrame(GLEventListener listener, int width, int height) {
        this("OpenGL Window", listener);
        this.mainCanvas.setSize(width, height);
        this.pack();
    }

    public GLJFrame(String title, GLEventListener listener, int width, int height) {
        this(title, listener);
        this.mainCanvas.setSize(width, height);
        this.pack();
    }

    public GLJFrame(GLEventListener listener, boolean fullscreen) {
        this("OpenGL Window", listener);
        this.setFullscreen(fullscreen);
    }

    public GLJFrame(String title, GLEventListener listener, boolean fullscreen) {
        this(title, listener);
        this.setFullscreen(fullscreen);
    }

    private void initComponents() {
        this.mainCanvas = new GLCanvas(this.caps, this.chooser, this.contextToShareWith, null);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                GLJFrame.this.formComponentResized(evt);
            }
        });
        this.mainCanvas.setSize(500, 500);
        this.getContentPane().add((Component)this.mainCanvas, "Center");
        this.pack();
    }

    private void formComponentResized(ComponentEvent evt) {
        this.mainCanvas.setSize(this.getRootPane().getSize());
    }

    public void setGLEventListener(GLEventListener listener) {
        ((GLCanvas)this.mainCanvas).removeGLEventListener(this.listener);
        this.listener = listener;
        ((GLCanvas)this.mainCanvas).addGLEventListener(listener);
    }

    public GLEventListener getGLEventListener() {
        return this.listener;
    }

    public boolean setFullscreen(boolean fs) {
        GraphicsDevice dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        boolean visible = this.isVisible();
        if (fs) {
            this.dispose();
            this.setUndecorated(true);
            this.setResizable(false);
            try {
                dev.setFullScreenWindow(this);
            }
            catch (Exception e) {
                dev.setFullScreenWindow(null);
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Could not enter fullscreen exclusive mode.", "Fullscreen error", 0);
            }
            this.setVisible(visible);
        } else {
            this.dispose();
            this.setUndecorated(false);
            this.setResizable(true);
            dev.setFullScreenWindow(null);
            this.setVisible(visible);
        }
        return dev.isFullScreenSupported();
    }

    public void setSize(int width, int height) {
        GraphicsDevice dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (dev.getFullScreenWindow() != this) {
            this.mainCanvas.setSize(width, height);
            this.pack();
            this.mainCanvas.repaint();
        }
    }

    public void setSize(Dimension d) {
        GraphicsDevice dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (dev.getFullScreenWindow() != this) {
            this.mainCanvas.setSize(d);
            this.pack();
        }
    }

    public boolean isFullscreen() {
        GraphicsDevice dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        return dev.getFullScreenWindow() == this;
    }

    public GLCapabilities getGLCapabilities() {
        return (GLCapabilities)this.caps.clone();
    }

    public void setGLCapabilities(GLCapabilities caps) {
        EventListener l;
        boolean vis = this.isVisible();
        this.caps = (GLCapabilities)caps.clone();
        boolean fs = this.isFullscreen();
        Dimension d = this.mainCanvas.getSize();
        this.dispose();
        this.mainCanvas = new GLCanvas(caps);
        this.getContentPane().removeAll();
        this.add(this.mainCanvas);
        this.mainCanvas.setSize(d);
        GLCanvas glc = (GLCanvas)this.mainCanvas;
        glc.addGLEventListener(this.listener);
        EventListener[] eventListenerArray = this.getInputMethodListeners();
        int n = eventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            l = eventListenerArray[n2];
            glc.addInputMethodListener(l);
            ++n2;
        }
        eventListenerArray = this.getKeyListeners();
        n = eventListenerArray.length;
        n2 = 0;
        while (n2 < n) {
            l = eventListenerArray[n2];
            glc.addKeyListener((KeyListener)l);
            ++n2;
        }
        eventListenerArray = this.getMouseListeners();
        n = eventListenerArray.length;
        n2 = 0;
        while (n2 < n) {
            l = eventListenerArray[n2];
            glc.addMouseListener((MouseListener)l);
            ++n2;
        }
        eventListenerArray = this.getMouseMotionListeners();
        n = eventListenerArray.length;
        n2 = 0;
        while (n2 < n) {
            l = eventListenerArray[n2];
            glc.addMouseMotionListener((MouseMotionListener)l);
            ++n2;
        }
        eventListenerArray = this.getMouseWheelListeners();
        n = eventListenerArray.length;
        n2 = 0;
        while (n2 < n) {
            l = eventListenerArray[n2];
            glc.addMouseWheelListener((MouseWheelListener)l);
            ++n2;
        }
        this.setFullscreen(fs);
        this.setVisible(vis);
    }

    public void repaint() {
        super.repaint();
        if (this.animator == null) {
            ((GLCanvas)this.mainCanvas).display();
        } else if (!this.animator.isAnimating()) {
            ((GLCanvas)this.mainCanvas).display();
        }
    }

    public void clearInputListeners() {
        EventListener l;
        InputMethodListener[] imls = super.getInputMethodListeners();
        KeyListener[] kls = super.getKeyListeners();
        MouseListener[] mls = super.getMouseListeners();
        MouseMotionListener[] mmls = super.getMouseMotionListeners();
        MouseWheelListener[] mwls = super.getMouseWheelListeners();
        EventListener[] eventListenerArray = imls;
        int n = imls.length;
        int n2 = 0;
        while (n2 < n) {
            l = eventListenerArray[n2];
            this.mainCanvas.removeInputMethodListener((InputMethodListener)l);
            super.removeInputMethodListener((InputMethodListener)l);
            ++n2;
        }
        eventListenerArray = kls;
        n = kls.length;
        n2 = 0;
        while (n2 < n) {
            l = eventListenerArray[n2];
            this.mainCanvas.removeKeyListener((KeyListener)l);
            super.removeKeyListener((KeyListener)l);
            ++n2;
        }
        eventListenerArray = mls;
        n = mls.length;
        n2 = 0;
        while (n2 < n) {
            l = eventListenerArray[n2];
            this.mainCanvas.removeMouseListener((MouseListener)l);
            super.removeMouseListener((MouseListener)l);
            ++n2;
        }
        eventListenerArray = mmls;
        n = mmls.length;
        n2 = 0;
        while (n2 < n) {
            l = eventListenerArray[n2];
            this.mainCanvas.removeMouseMotionListener((MouseMotionListener)l);
            super.removeMouseMotionListener((MouseMotionListener)l);
            ++n2;
        }
        eventListenerArray = mwls;
        n = mwls.length;
        n2 = 0;
        while (n2 < n) {
            l = eventListenerArray[n2];
            this.mainCanvas.removeMouseWheelListener((MouseWheelListener)l);
            super.removeMouseWheelListener((MouseWheelListener)l);
            ++n2;
        }
    }

    public Animator generateAnimator() {
        if (this.animator != null) {
            this.animator.stop();
            this.animator.remove((GLAutoDrawable)((GLCanvas)this.mainCanvas));
        }
        this.animator = new Animator((GLAutoDrawable)((GLCanvas)this.mainCanvas));
        this.animator.start();
        return this.animator;
    }

    public Animator getAnimator() {
        return this.animator;
    }

    public void setAnimator(Animator anim) {
        this.setAnimator(anim, true);
    }

    public void setAnimator(Animator anim, boolean start) {
        if (this.animator != null) {
            this.animator.stop();
            this.animator.remove((GLAutoDrawable)((GLCanvas)this.mainCanvas));
        }
        this.animator = anim;
        this.animator.add((GLAutoDrawable)((GLCanvas)this.mainCanvas));
        if (start) {
            this.animator.start();
        }
    }

    public void removeAnimator() {
        this.animator.stop();
        this.animator.remove((GLAutoDrawable)((GLCanvas)this.mainCanvas));
        this.animator = null;
    }

    public boolean isAnimated() {
        return this.animator != null;
    }

    public void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        this.mainCanvas.removeKeyListener(l);
    }

    public void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.mainCanvas.addKeyListener(l);
    }

    public void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.mainCanvas.removeMouseListener(l);
    }

    public void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.mainCanvas.addMouseListener(l);
    }

    public void removeMouseWheelListener(MouseWheelListener l) {
        super.removeMouseWheelListener(l);
        this.mainCanvas.removeMouseWheelListener(l);
    }

    public void removeMouseMotionListener(MouseMotionListener l) {
        super.removeMouseMotionListener(l);
        this.mainCanvas.removeMouseMotionListener(l);
    }

    public void addMouseWheelListener(MouseWheelListener l) {
        super.addMouseWheelListener(l);
        this.mainCanvas.addMouseWheelListener(l);
    }

    public void addMouseMotionListener(MouseMotionListener l) {
        super.addMouseMotionListener(l);
        this.mainCanvas.addMouseMotionListener(l);
    }

    public void removeInputMethodListener(InputMethodListener l) {
        super.removeInputMethodListener(l);
        this.mainCanvas.removeInputMethodListener(l);
    }

    public void addInputMethodListener(InputMethodListener l) {
        super.addInputMethodListener(l);
        this.mainCanvas.addInputMethodListener(l);
    }

    public GL getGL() {
        return ((GLCanvas)this.mainCanvas).getGL();
    }

    public void setGL(GL gl) {
        ((GLCanvas)this.mainCanvas).setGL(gl);
    }

    public GLContext getContext() {
        return ((GLCanvas)this.mainCanvas).getContext();
    }

    public GLAutoDrawable getAutoDrawable() {
        return (GLAutoDrawable)this.mainCanvas;
    }
}

