/*
 * Decompiled with CFR 0.152.
 */
package vitamin.jsr231;

import com.sun.opengl.util.Gamma;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLEventListener;
import vitamin.config.FSAA;
import vitamin.config.OpenGLLayer;
import vitamin.config.VDisplayMode;
import vitamin.jsr231.OldStyleGLCapabilitiesChooser;

public class CanvasPeerImplAWT
implements GLEventListener {
    private static final int RENDER_MODE_CLEAR = 1;
    private static final int RENDER_MODE_DESTROY = 2;
    private GLCapabilities gc;
    private GLCapabilitiesChooser gcc;
    private GLCanvas glCanvas;
    private GL gl;
    private boolean vsync;
    private int swapInterval = -1;
    protected boolean swapIntervalChanged = false;
    private float gamma = 1.0f;
    private float brightness = 0.0f;
    private float contrast = 1.0f;
    protected boolean isGammaChanged = false;
    private int renderMode = 0;
    private boolean isRendering = false;
    private Window window;
    private boolean closeRequested = false;

    public void setup() {
    }

    public void draw() {
    }

    public void stop() {
    }

    public CanvasPeerImplAWT(Object owner, VDisplayMode displayMode, boolean fullscreen, boolean vsync, FSAA fsaa, int depthBufferSize) {
        try {
            System.setProperty("org.xith3d.render.jsr231.displayGLInfos", String.valueOf(false));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.gc = new GLCapabilities();
        this.gc.setStencilBits(8);
        this.gc.setDepthBits(depthBufferSize);
        if (fsaa != FSAA.OFF) {
            this.gc.setSampleBuffers(true);
        }
        this.gc.setNumSamples(fsaa.getIntValue());
        this.gcc = new OldStyleGLCapabilitiesChooser();
        this.glCanvas = new GLCanvas(this.gc, this.gcc, null, null);
        this.glCanvas.setBounds(0, 0, displayMode.getWidth(), displayMode.getHeight());
        this.setVSyncEnabled(vsync);
        this.glCanvas.addGLEventListener((GLEventListener)this);
        this.glCanvas.setFocusable(true);
        this.gl = this.glCanvas.getGL();
        this.clear();
        if (owner == null) {
            Frame frame = new Frame("Xith3D (JOGL)");
            frame.setLayout(null);
            if (fullscreen) {
                frame.setBackground(Color.BLACK);
            }
            frame.setUndecorated(fullscreen);
            frame.setSize(displayMode.getWidth(), displayMode.getHeight());
            this.setWindow(frame);
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    CanvasPeerImplAWT.this.closeRequested = true;
                }
            });
            boolean exclusive = fullscreen && displayMode.getNativeMode() != null;
            frame.add((Component)this.glCanvas);
            frame.setVisible(true);
            if (!exclusive) {
                Dimension frameSize;
                Thread.yield();
                if (!fullscreen) {
                    Insets insets = frame.getInsets();
                    this.glCanvas.setLocation(insets.left, insets.top);
                    frameSize = new Dimension(displayMode.getWidth() + insets.left + insets.right, displayMode.getHeight() + insets.top + insets.bottom);
                    frame.setSize(frameSize);
                } else {
                    frameSize = new Dimension(displayMode.getWidth(), displayMode.getHeight());
                }
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Point upperLeft = new Point((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
                frame.setLocation(upperLeft);
            } else {
                DisplayMode awtMode = (DisplayMode)displayMode.getNativeMode();
                GraphicsDevice graphDev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                graphDev.setFullScreenWindow(frame);
                graphDev.setDisplayMode(awtMode);
            }
        } else {
            this.glCanvas.setBounds(0, 0, displayMode.getWidth(), displayMode.getHeight());
            ((Container)owner).add((Component)this.glCanvas);
        }
        Thread.yield();
    }

    public final void init(GLAutoDrawable drawable) {
        this.gl = this.glCanvas.getGL();
        this.setup();
    }

    public OpenGLLayer getType() {
        return OpenGLLayer.JOGL_AWT;
    }

    public void setGammaImpl(float gamma, float brightness, float contrast) {
        if (brightness < -1.0f || brightness > 1.0f) {
            throw new IllegalArgumentException("brightness must be in range [-1.0, +1.0]");
        }
        if (contrast < 0.0f || contrast > 1.0f) {
            throw new IllegalArgumentException("contrast must be in range [0.0, +1.0]");
        }
        this.gamma = gamma;
        this.brightness = brightness;
        this.contrast = contrast;
        this.isGammaChanged = true;
    }

    public float getGamma() {
        return this.gamma;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public float getContrast() {
        return this.contrast;
    }

    public final void setSwapInterval(int swapInterval) {
        this.swapInterval = swapInterval;
        this.swapIntervalChanged = true;
    }

    public final int getSwapInterval() {
        return this.swapInterval;
    }

    public void setVSyncEnabled(boolean vsync) {
        this.setVsync(vsync);
        this.setSwapInterval(vsync ? 1 : 0);
    }

    public void setVsync(boolean vsync) {
        this.vsync = vsync;
    }

    public boolean isVsync() {
        return this.vsync;
    }

    public final GL getGL() {
        return this.gl;
    }

    protected final void setWindow(Window w) {
        this.window = w;
    }

    public final Window getWindow() {
        return this.window;
    }

    public final Component getComponent() {
        return this.glCanvas;
    }

    public void setIcon(URL iconResource) {
        assert (this.window instanceof Frame) : "Window isn't a Frame";
        try {
            ((Frame)this.window).setIconImage(ImageIO.read(iconResource));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void setTitle(String title) {
        if (this.window != null) {
            assert (this.window instanceof Frame) : "Window isn't a Frame";
            ((Frame)this.window).setTitle(title);
        }
    }

    public final String getTitle() {
        if (this.window != null) {
            assert (this.window instanceof Frame) : "Window isn't a Frame";
            return ((Frame)this.window).getTitle();
        }
        return "";
    }

    public final boolean setLocation(int x, int y) {
        if (this.window.getLocation().x != x || this.window.getLocation().y != y) {
            this.window.setLocation(x, y);
            return true;
        }
        return false;
    }

    public final int getLeft() {
        return this.glCanvas.getLocationOnScreen().x;
    }

    public final int getTop() {
        return this.glCanvas.getLocationOnScreen().y;
    }

    public final boolean setSize(int width, int height) {
        if (this.glCanvas.getSize().width != width || this.glCanvas.getSize().height != height) {
            this.glCanvas.setSize(width, height);
            if (this.getWindow() != null) {
                Insets insets = this.getWindow().getInsets();
                this.glCanvas.setLocation(insets.left, insets.top);
                Dimension frameSize = new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
                this.getWindow().setSize(frameSize);
            }
            return true;
        }
        return false;
    }

    public final int getWidth() {
        return this.glCanvas.getWidth();
    }

    public final int getHeight() {
        return this.glCanvas.getHeight();
    }

    protected boolean setDisplayModeImpl(DisplayMode displayMode) {
        boolean result = true;
        this.setSize(displayMode.getWidth(), displayMode.getHeight());
        return true;
    }

    public final void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        this.gl = drawable.getGL();
    }

    public void setGamma(float gamma, float brightness, float contrast) {
        this.setGammaImpl(gamma, brightness, contrast);
        try {
            Gamma.setDisplayGamma((float)gamma, (float)brightness, (float)contrast);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public final void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
    }

    protected void setAutoSwapBufferMode(boolean mode) {
        this.glCanvas.setAutoSwapBufferMode(mode);
    }

    public final boolean isRendering() {
        return this.isRendering;
    }

    public void beforeThreadChanged() {
    }

    public final void display(GLAutoDrawable drawable) {
        this.isRendering = true;
        if (this.closeRequested) {
            this.closeRequested = false;
        }
        this.gl = drawable.getGL();
        if (this.swapIntervalChanged) {
            this.swapIntervalChanged = false;
            this.gl.setSwapInterval(this.getSwapInterval());
        }
        if (this.renderMode != 0) {
            boolean proceed = true;
            if ((this.renderMode & 1) != 0) {
                this.isRendering = false;
                proceed = false;
            }
            if ((this.renderMode & 2) != 0) {
                this.destroy();
                this.isRendering = false;
                proceed = false;
            }
            if (!proceed) {
                return;
            }
        }
        this.draw();
        this.isRendering = false;
    }

    public void clear() {
        this.renderMode |= 1;
        this.glCanvas.display();
    }

    public void destroy() {
        if ((this.renderMode & 2) == 0) {
            this.renderMode |= 3;
            if (this.isGammaChanged) {
                try {
                    Gamma.resetDisplayGamma();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.glCanvas.display();
        } else if (this.getWindow() != null) {
            this.getWindow().dispose();
        }
        this.stop();
    }

    public void dispose(GLAutoDrawable arg0) {
    }
}

