/*
 * Decompiled with CFR 0.152.
 */
package vitamin.config;

import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import vitamin.config.OpenGLLayer;
import vitamin.config.VDisplayMode;

public abstract class DisplayModeSelector {
    public static boolean debug = false;
    private static final HashMap<OpenGLLayer, DisplayModeSelector> selectorCache = new HashMap();

    protected void sortModes(VDisplayMode[] modes) {
    }

    public abstract VDisplayMode[] getAvailableModes();

    public VDisplayMode getDesktopMode() {
        GraphicsDevice graphDev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode dm = graphDev.getDisplayMode();
        return new VDisplayMode(null, dm.getWidth(), dm.getHeight(), dm.getBitDepth(), dm.getRefreshRate());
    }

    public VDisplayMode getBestMode(int width, int height, int optimalBPP, int optimalFreq) {
        int i;
        VDisplayMode[] modes = this.getAvailableModes();
        if (modes.length == 0) {
            modes = new VDisplayMode[]{this.getDesktopMode()};
            if (debug) {
                System.out.println("No DisplayMode available! Falling back to desktop mode!");
            }
        }
        if (debug) {
            System.out.println("Trying to find best mode matching (Width = " + width + ", Height = " + height + " , BPP = " + optimalBPP + ")");
        }
        ArrayList<VDisplayMode> foundModes = new ArrayList<VDisplayMode>();
        int i2 = 0;
        while (i2 < modes.length) {
            if (debug) {
                System.out.println("  Found Mode " + i2 + "... Width = " + modes[i2].getWidth() + ", Height = " + modes[i2].getHeight() + ", BPP = " + modes[i2].getBPP() + ", frequency = " + modes[i2].getFrequency());
            }
            if (modes[i2].getWidth() == width && modes[i2].getHeight() == height && modes[i2].getBPP() == optimalBPP) {
                foundModes.add(modes[i2]);
            }
            ++i2;
        }
        if (foundModes.size() == 0) {
            i2 = 0;
            while (i2 < modes.length) {
                if (modes[i2].getWidth() == width && modes[i2].getHeight() == height) {
                    foundModes.add(modes[i2]);
                }
                ++i2;
            }
        }
        if (foundModes.size() == 0) {
            if (debug) {
                System.out.println("No matching mode found so far. Trying to find a similar one...");
            }
            Arrays.sort(modes, new ModesComparator());
            VDisplayMode bestMode = modes[0];
            i = 1;
            while (i < modes.length) {
                int diffW0 = Math.abs(bestMode.getWidth() - width);
                int diffW1 = Math.abs(modes[i].getWidth() - width);
                int diffH0 = Math.abs(bestMode.getHeight() - height);
                int diffH1 = Math.abs(modes[i].getHeight() - height);
                if (diffW1 <= diffW0 && diffH1 <= diffH0) {
                    bestMode = modes[i];
                }
                ++i;
            }
            i = 0;
            while (i < modes.length) {
                if (modes[i].getWidth() == bestMode.getWidth() && modes[i].getHeight() == bestMode.getHeight()) {
                    foundModes.add(modes[i]);
                }
                ++i;
            }
            if (debug) {
                System.out.println("Found " + foundModes.size() + " similar mode(s) with (Width = " + bestMode.getWidth() + ", Height = " + bestMode.getHeight() + ").");
            }
        }
        VDisplayMode bestMode = null;
        if (foundModes.size() > 0) {
            bestMode = (VDisplayMode)foundModes.get(0);
            i = 1;
            while (i < foundModes.size()) {
                int diff0 = bestMode.getFrequency() - optimalFreq;
                int diff1 = ((VDisplayMode)foundModes.get(i)).getFrequency() - optimalFreq;
                if (diff1 >= 0 && (diff1 < diff0 || diff0 < 0)) {
                    bestMode = (VDisplayMode)foundModes.get(i);
                }
                ++i;
            }
        }
        if (debug) {
            if (bestMode == null) {
                System.out.println("No DisplayMode available!");
            } else {
                System.out.println("Using mode: Width = " + bestMode.getWidth() + ", Height = " + bestMode.getHeight() + ", BPP = " + bestMode.getBPP() + ", frequency = " + bestMode.getFrequency());
            }
        }
        return bestMode;
    }

    public VDisplayMode getBestMode(int width, int height, int optimalBPP) {
        return this.getBestMode(width, height, optimalBPP, VDisplayMode.getDefaultFrequency());
    }

    public VDisplayMode getBestMode(int width, int height) {
        return this.getBestMode(width, height, VDisplayMode.getDefaultBPP());
    }

    public static DisplayModeSelector getImplementation(OpenGLLayer layer) {
        DisplayModeSelector cached = selectorCache.get(layer);
        if (cached != null) {
            return cached;
        }
        try {
            DisplayModeSelector selector = (DisplayModeSelector)Class.forName(layer.getDisplayModeSelectorClassName()).newInstance();
            selectorCache.put(layer, selector);
            return selector;
        }
        catch (Exception e) {
            Error error = new Error(e);
            throw error;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModesComparator
    implements Comparator<VDisplayMode> {
        private ModesComparator() {
        }

        @Override
        public int compare(VDisplayMode mode1, VDisplayMode mode2) {
            if (mode1.getWidth() > mode2.getWidth()) {
                return 1;
            }
            if (mode1.getWidth() < mode2.getWidth()) {
                return -1;
            }
            if (mode1.getHeight() > mode2.getHeight()) {
                return 1;
            }
            if (mode1.getHeight() < mode2.getHeight()) {
                return -1;
            }
            if (mode1.getBPP() > mode2.getBPP()) {
                return 1;
            }
            if (mode1.getBPP() < mode2.getBPP()) {
                return -1;
            }
            if (mode1.getFrequency() > mode2.getFrequency()) {
                return 1;
            }
            if (mode1.getFrequency() < mode2.getFrequency()) {
                return -1;
            }
            return 0;
        }
    }
}

