/*
 * Decompiled with CFR 0.152.
 */
package vitamin.config;

import java.awt.Dimension;
import java.awt.Toolkit;
import vitamin.config.DisplayModeSelector;
import vitamin.config.FSAA;
import vitamin.config.OpenGLLayer;
import vitamin.config.VDisplayMode;

public class CanvasConstructionInfo {
    private static final Dimension DESKTOP_RESOLUTION = Toolkit.getDefaultToolkit().getScreenSize();
    private OpenGLLayer layer;
    private VDisplayMode dspMode;
    private boolean fullscreen;
    private boolean vsync;
    private FSAA fsaa;
    private int depthBufferSize = 16;
    private String title;

    private static VDisplayMode createDisplayMode(OpenGLLayer layer, int width, int height, int bpp) {
        assert (layer != null);
        DisplayModeSelector modeSelector = DisplayModeSelector.getImplementation(layer);
        VDisplayMode displayMode = modeSelector.getBestMode(width, height, bpp, VDisplayMode.getDefaultFrequency());
        if (displayMode == null) {
            displayMode = new VDisplayMode(null, width, height, VDisplayMode.getDefaultBPP(), VDisplayMode.getDefaultFrequency());
        }
        return displayMode;
    }

    public void setOpenGLLayer(OpenGLLayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer MUST NOT be null");
        }
        this.layer = layer;
    }

    public OpenGLLayer getOpenGLLayer() {
        return this.layer;
    }

    public void setDisplayMode(VDisplayMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode MUST NOT be null");
        }
        this.dspMode = mode;
    }

    public VDisplayMode getDisplayMode() {
        return this.dspMode;
    }

    public void setFullscreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public void setVSyncEnabled(boolean vsync) {
        this.vsync = vsync;
    }

    public boolean isVSyncEnabled() {
        return this.vsync;
    }

    public void setFSAAMode(FSAA fsaa) {
        this.fsaa = fsaa;
    }

    public FSAA getFSAAMode() {
        return this.fsaa;
    }

    public void setDepthBufferSize(int depthBufferSize) {
        this.depthBufferSize = depthBufferSize;
    }

    public int getDepthBufferSize() {
        return this.depthBufferSize;
    }

    public void setTitle(String title) {
        if (title == null) {
            this.setFullscreen(VDisplayMode.FULLSCREEN);
        } else {
            this.setFullscreen(VDisplayMode.WINDOWED);
        }
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public CanvasConstructionInfo(OpenGLLayer layer, VDisplayMode dspMode, boolean fullscreen, boolean vsync, FSAA fsaa, String title) {
        this.setOpenGLLayer(layer);
        this.setDisplayMode(dspMode);
        this.setTitle(title);
        this.setFullscreen(fullscreen);
        this.setVSyncEnabled(vsync);
        this.setFSAAMode(fsaa);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, VDisplayMode dspMode, boolean fullscreen, FSAA fsaa, String title) {
        this(layer, dspMode, fullscreen, VDisplayMode.VSYNC_ENABLED, fsaa, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, VDisplayMode dspMode, boolean fullscreen, boolean vsync, String title) {
        this(layer, dspMode, fullscreen, vsync, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, VDisplayMode dspMode, boolean fullscreen, String title) {
        this(layer, dspMode, fullscreen, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(VDisplayMode dspMode, boolean fullscreen, boolean vsync, FSAA fsaa, String title) {
        this(CanvasConstructionInfo.extractOpenGLLayer(dspMode), dspMode, fullscreen, vsync, fsaa, title);
    }

    private static final OpenGLLayer extractOpenGLLayer(VDisplayMode dspMode) {
        if (dspMode.getNativeMode() == null) {
            return OpenGLLayer.getDefault();
        }
        if (dspMode.getNativeMode().getClass().getName().contains("lwjgl")) {
            return OpenGLLayer.LWJGL;
        }
        return OpenGLLayer.getDefault();
    }

    public CanvasConstructionInfo(VDisplayMode dspMode, boolean fullscreen, FSAA fsaa, String title) {
        this(CanvasConstructionInfo.extractOpenGLLayer(dspMode), dspMode, fullscreen, fsaa, title);
    }

    public CanvasConstructionInfo(VDisplayMode dspMode, boolean fullscreen, boolean vsync, String title) {
        this(dspMode, fullscreen, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(VDisplayMode dspMode, boolean fullscreen, String title) {
        this(dspMode, fullscreen, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, int width, int height, int bpp, boolean fullscreen, boolean vsync, FSAA fsaa, String title) {
        this(layer, CanvasConstructionInfo.createDisplayMode(layer, width, height, bpp), fullscreen, vsync, fsaa, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, int width, int height, int bpp, boolean fullscreen, FSAA fsaa, String title) {
        this(layer, CanvasConstructionInfo.createDisplayMode(layer, width, height, bpp), fullscreen, fsaa, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, int width, int height, int bpp, boolean fullscreen, boolean vsync, String title) {
        this(layer, width, height, bpp, fullscreen, vsync, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, int width, int height, int bpp, boolean fullscreen, String title) {
        this(layer, width, height, bpp, fullscreen, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(int width, int height, int bpp, boolean fullscreen, boolean vsync, FSAA fsaa, String title) {
        this(OpenGLLayer.getDefault(), width, height, bpp, fullscreen, vsync, fsaa, title);
    }

    public CanvasConstructionInfo(int width, int height, int bpp, boolean fullscreen, FSAA fsaa, String title) {
        this(OpenGLLayer.getDefault(), width, height, bpp, fullscreen, fsaa, title);
    }

    public CanvasConstructionInfo(int width, int height, int bpp, boolean fullscreen, boolean vsync, String title) {
        this(width, height, bpp, fullscreen, vsync, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(int width, int height, int bpp, boolean fullscreen, String title) {
        this(width, height, bpp, fullscreen, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, int width, int height, boolean fullscreen, boolean vsync, FSAA fsaa, String title) {
        this(layer, width, height, VDisplayMode.getDefaultBPP(), fullscreen, vsync, fsaa, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, int width, int height, boolean fullscreen, FSAA fsaa, String title) {
        this(layer, width, height, VDisplayMode.getDefaultBPP(), fullscreen, fsaa, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, int width, int height, boolean fullscreen, boolean vsync, String title) {
        this(layer, width, height, fullscreen, vsync, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, int width, int height, boolean fullscreen, String title) {
        this(layer, width, height, fullscreen, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(int width, int height, boolean fullscreen, boolean vsync, FSAA fsaa, String title) {
        this(OpenGLLayer.getDefault(), width, height, fullscreen, vsync, fsaa, title);
    }

    public CanvasConstructionInfo(int width, int height, boolean fullscreen, FSAA fsaa, String title) {
        this(OpenGLLayer.getDefault(), width, height, fullscreen, fsaa, title);
    }

    public CanvasConstructionInfo(int width, int height, boolean fullscreen, boolean vsync, String title) {
        this(width, height, fullscreen, vsync, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(int width, int height, boolean fullscreen, String title) {
        this(width, height, fullscreen, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, boolean fullscreen, boolean vsync, FSAA fsaa, String title) {
        this(layer, CanvasConstructionInfo.DESKTOP_RESOLUTION.width, CanvasConstructionInfo.DESKTOP_RESOLUTION.height, VDisplayMode.getDefaultBPP(), fullscreen, vsync, fsaa, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, boolean fullscreen, FSAA fsaa, String title) {
        this(layer, CanvasConstructionInfo.DESKTOP_RESOLUTION.width, CanvasConstructionInfo.DESKTOP_RESOLUTION.height, VDisplayMode.getDefaultBPP(), fullscreen, fsaa, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, boolean fullscreen, boolean vsync, String title) {
        this(layer, fullscreen, vsync, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, boolean fullscreen, String title) {
        this(layer, fullscreen, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(boolean fullscreen, boolean vsync, FSAA fsaa, String title) {
        this(OpenGLLayer.getDefault(), fullscreen, vsync, fsaa, title);
    }

    public CanvasConstructionInfo(boolean fullscreen, FSAA fsaa, String title) {
        this(OpenGLLayer.getDefault(), fullscreen, fsaa, title);
    }

    public CanvasConstructionInfo(boolean fullscreen, boolean vsync, String title) {
        this(fullscreen, vsync, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(boolean fullscreen, String title) {
        this(fullscreen, FSAA.OFF, title);
    }

    public CanvasConstructionInfo(OpenGLLayer layer, boolean vsync, FSAA fsaa) {
        this(layer, VDisplayMode.WINDOWED, vsync, fsaa, "Powered by Xith3D");
    }

    public CanvasConstructionInfo(OpenGLLayer layer, FSAA fsaa) {
        this(layer, VDisplayMode.WINDOWED, fsaa, "Powered by Xith3D");
    }

    public CanvasConstructionInfo(OpenGLLayer layer, boolean vsync) {
        this(layer, vsync, FSAA.OFF);
    }

    public CanvasConstructionInfo(OpenGLLayer layer) {
        this(layer, FSAA.OFF);
    }

    public CanvasConstructionInfo(boolean vsync, FSAA fsaa) {
        this(OpenGLLayer.getDefault(), vsync, fsaa);
    }

    public CanvasConstructionInfo(FSAA fsaa) {
        this(OpenGLLayer.getDefault(), fsaa);
    }

    public CanvasConstructionInfo(boolean vsync) {
        this(vsync, FSAA.OFF);
    }

    public CanvasConstructionInfo() {
        this(FSAA.OFF);
    }
}

