/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import com.sun.opengl.util.FPSAnimator;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import vitamin.VGLEventListener;
import vitamin.VLogger;

public class VApplication {
    public static boolean USE_SWING = false;
    private static final int DEFAULT_WIDTH = 800;
    private static final int DEFAULT_HEIGHT = 600;
    private static final int DONT_CARE = -1;
    public String _contextID;
    private JFrame _jframe;
    private Frame _frame;
    private GLCanvas _glCanvas;
    private FPSAnimator _animator;
    private GraphicsDevice _device;
    private String _name;
    private boolean _fullscreen;
    private int _width;
    private int _height;
    private int _FPS;
    private boolean _fixedRate;
    private VExceptionHandler exceptionHandler = new VExceptionHandler();
    VGLEventListener _listener;

    public static VApplication createGLDisplay(String title) {
        return VApplication.createGLDisplay(title, new GLCapabilities());
    }

    public static VApplication createGLDisplay(String title, GLCapabilities caps) {
        boolean fullscreen = false;
        return new VApplication(title, 800, 600, fullscreen, caps, 60, true);
    }

    public static VApplication createGLDisplay(String title, int w, int h, boolean fullscreen, GLCapabilities caps, int fps, boolean fixedRate) {
        return new VApplication(title, w, h, fullscreen, caps, fps, fixedRate);
    }

    private VApplication(String title, int width, int height, boolean fullscreen, GLCapabilities caps, int fps, boolean fixedRate) {
        this.init(title, width, height, fullscreen, caps, fps, fixedRate);
    }

    public void init(String title, int width, int height, boolean fullscreen, GLCapabilities caps, int fps, boolean fixedRate) {
        if (USE_SWING) {
            System.out.println("Using Swing JFrame");
        } else {
            System.out.println("Using AWT Frame");
        }
        this._name = title;
        this._width = width;
        this._height = height;
        this._fullscreen = fullscreen;
        this._FPS = fps;
        this._fixedRate = fixedRate;
        if (USE_SWING) {
            VLogger.getSingleton().log("create Swing frame");
            this._jframe = new JFrame(this._name);
        } else {
            VLogger.getSingleton().log("create AWT frame");
            this._frame = new Frame(this._name);
        }
        VLogger.getSingleton().log("create gl canvas");
        this._glCanvas = new GLCanvas(caps);
    }

    public void start() {
        VLogger.getSingleton().log("VApplication start()");
        try {
            this._glCanvas.setBounds(0, 0, this._width, this._height);
            this._glCanvas.setPreferredSize(new Dimension(this._width, this._height));
            VLogger.getSingleton().log("add canvas to frame");
            if (USE_SWING) {
                this._jframe.getContentPane().add((Component)this._glCanvas);
            } else {
                this._frame.add((Component)this._glCanvas);
            }
            VLogger.getSingleton().log("set frame parameters");
            if (USE_SWING) {
                this._jframe.setPreferredSize(new Dimension(this._width, this._height));
                this._jframe.setUndecorated(this._fullscreen);
                this._jframe.setResizable(!this._fullscreen);
                this._jframe.setIgnoreRepaint(true);
                this._jframe.pack();
            } else {
                this._frame.setPreferredSize(new Dimension(this._width, this._height));
                this._frame.setUndecorated(this._fullscreen);
                this._frame.setResizable(!this._fullscreen);
                this._frame.setIgnoreRepaint(true);
                this._frame.pack();
            }
            if (this._fullscreen) {
                VLogger.getSingleton().log("fullscreen mode");
                VLogger.getSingleton().log("get device");
                GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                int i = 0;
                while (i < devices.length) {
                    System.out.println("Device String: " + devices[i].getIDstring());
                    ++i;
                }
                this._device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                System.out.println("VApplication init()  fullscreen supported?  " + this._device.isFullScreenSupported());
                if (USE_SWING) {
                    this._device.setFullScreenWindow(this._jframe);
                } else {
                    this._device.setFullScreenWindow(this._frame);
                }
                DisplayMode[] displayModes = this._device.getDisplayModes();
                int i2 = 0;
                while (i2 < displayModes.length) {
                    System.out.println("Device display modes: " + displayModes[i2].getWidth() + "x" + displayModes[i2].getHeight() + "x" + displayModes[i2].getBitDepth() + "x" + displayModes[i2].getRefreshRate());
                    ++i2;
                }
                DisplayMode displayMode = this.findDisplayMode(displayModes, this._width, this._height, this._device.getDisplayMode().getBitDepth(), this._device.getDisplayMode().getRefreshRate());
                System.out.println("* DisplayMode info: " + displayMode.getWidth() + ", " + displayMode.getHeight() + ", " + displayMode.getBitDepth() + ", " + displayMode.getRefreshRate());
                VLogger.getSingleton().log("* DisplayMode info: " + displayMode.getWidth() + ", " + displayMode.getHeight() + ", " + displayMode.getBitDepth() + ", " + displayMode.getRefreshRate());
                VLogger.getSingleton().log("set display mode");
                this._device.setDisplayMode(displayMode);
                if (USE_SWING) {
                    this._jframe.setSize(displayMode.getWidth(), displayMode.getHeight());
                } else {
                    this._frame.setSize(displayMode.getWidth(), displayMode.getHeight());
                }
            } else {
                VLogger.getSingleton().log("windowed mode");
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                if (USE_SWING) {
                    this._jframe.setSize(this._jframe.getContentPane().getPreferredSize());
                    this._jframe.setLocation((screenSize.width - this._jframe.getWidth()) / 2, (screenSize.height - this._jframe.getHeight()) / 2);
                } else {
                    VLogger.getSingleton().log("center window");
                    this._frame.setSize(this._frame.getPreferredSize());
                    this._frame.setLocation((screenSize.width - this._frame.getWidth()) / 2, (screenSize.height - this._frame.getHeight()) / 2);
                }
                VLogger.getSingleton().log("set frame visible");
                if (USE_SWING) {
                    this._jframe.setVisible(true);
                } else {
                    this._frame.setVisible(true);
                }
            }
            if (USE_SWING) {
                this._jframe.addWindowListener(new VWindowAdapter());
            } else {
                this._frame.addWindowListener(new VWindowAdapter());
            }
            VLogger.getSingleton().log("create and start animator");
            this._animator = new FPSAnimator((GLAutoDrawable)this._glCanvas, this._FPS, this._fixedRate);
            this._animator.setRunAsFastAsPossible(true);
            this._animator.start();
            VLogger.getSingleton().log("request focus");
            this._glCanvas.requestFocus();
        }
        catch (Exception e) {
            System.err.println("(VApplication)  " + e);
            this.exceptionHandler.handleException(e);
        }
    }

    public void stop() {
        block7: {
            try {
                try {
                    this._animator.stop();
                    if (this._fullscreen) {
                        this._device.setFullScreenWindow(null);
                        this._device = null;
                    }
                    if (USE_SWING) {
                        this._jframe.dispose();
                        break block7;
                    }
                    this._frame.dispose();
                }
                catch (Exception e) {
                    System.err.println("(VApplication)  " + e);
                    this.exceptionHandler.handleException(e);
                    System.exit(0);
                }
            }
            finally {
                System.exit(0);
            }
        }
    }

    private DisplayMode findDisplayMode(DisplayMode[] displayModes, int requestedWidth, int requestedHeight, int requestedDepth, int requestedRefreshRate) {
        System.out.println("Try to find exact match for displaymode...");
        DisplayMode displayMode = this.findDisplayModeInternal(displayModes, requestedWidth, requestedHeight, requestedDepth, requestedRefreshRate);
        if (displayMode == null) {
            System.out.println("Exact math for displaymode not found.. try ignoring bit depth and refresh rate");
            displayMode = this.findDisplayModeInternal(displayModes, requestedWidth, requestedHeight, -1, -1);
        }
        if (displayMode == null) {
            System.out.println("Exact math for displaymode not found.. try ignoring height, bit depth and refresh rate");
            displayMode = this.findDisplayModeInternal(displayModes, requestedWidth, -1, -1, -1);
        }
        if (displayMode == null) {
            System.out.println("Exact math for displaymode not found.. try ignoring everything. just pick anyone");
            displayMode = this.findDisplayModeInternal(displayModes, -1, -1, -1, -1);
        }
        return displayMode;
    }

    private DisplayMode findDisplayModeInternal(DisplayMode[] displayModes, int requestedWidth, int requestedHeight, int requestedDepth, int requestedRefreshRate) {
        DisplayMode displayModeToUse = null;
        int i = 0;
        while (i < displayModes.length) {
            DisplayMode displayMode = displayModes[i];
            if (!(requestedWidth != -1 && displayMode.getWidth() != requestedWidth || requestedHeight != -1 && displayMode.getHeight() != requestedHeight || requestedHeight != -1 && displayMode.getRefreshRate() != requestedRefreshRate || requestedDepth != -1 && displayMode.getBitDepth() != requestedDepth)) {
                displayModeToUse = displayMode;
            }
            ++i;
        }
        return displayModeToUse;
    }

    public void addGLEventListener(GLEventListener listener) {
        this._glCanvas.addGLEventListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this._glCanvas.addKeyListener(listener);
    }

    public void addListener(VGLEventListener listener) {
        this._listener = listener;
        this._glCanvas.addGLEventListener((GLEventListener)listener);
        this._glCanvas.addKeyListener((KeyListener)listener);
        this._glCanvas.addMouseListener((MouseListener)listener);
        this._glCanvas.addMouseMotionListener((MouseMotionListener)listener);
        this._glCanvas.addMouseWheelListener((MouseWheelListener)listener);
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public void showCursor() {
        if (USE_SWING) {
            ((Component)this._jframe).setCursor(Cursor.getDefaultCursor());
        } else {
            ((Component)this._frame).setCursor(Cursor.getDefaultCursor());
        }
    }

    public void hideCursor() {
        int size = 16;
        int[] pixels = new int[size * size];
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.createImage(new MemoryImageSource(size, size, pixels, 0, size));
        Cursor transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
        if (USE_SWING) {
            ((Component)this._jframe).setCursor(transparentCursor);
        } else {
            ((Component)this._frame).setCursor(transparentCursor);
        }
    }

    private class VExceptionHandler {
        private VExceptionHandler() {
        }

        public void handleException(final Exception e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    e.printStackTrace(printWriter);
                    if (USE_SWING) {
                        JOptionPane.showMessageDialog(VApplication.this._jframe, stringWriter.toString(), "Exception occurred", 0);
                    }
                    VApplication.this.stop();
                }
            });
        }
    }

    private class VWindowAdapter
    extends WindowAdapter {
        private VWindowAdapter() {
        }

        public void windowClosing(WindowEvent e) {
            VApplication.this.stop();
        }
    }
}

