/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import javax.media.opengl.GL;
import vitamin.SurfaceFormat;
import vitamin.VLogger;
import vitamin.VRenderBuffer;
import vitamin.VSamplerState;
import vitamin.VTexture;
import vitamin.VTexture2D;
import vitamin.VTextureRECT;

public class RenderTarget2D {
    GL _gl;
    VTexture _tex;
    VTexture _depthTex;
    VRenderBuffer _renderBuffer;
    int[] _savedID;
    private int[] _fboID;
    private int[] _depthStencilBufferID;
    int _targetID;
    int _width;
    int _height;
    int[] _appViewport = null;

    public RenderTarget2D(GL gl, int width, int height, int format) {
        this(gl, 3553, width, height, format, new VSamplerState(), null, false);
    }

    public RenderTarget2D(GL gl, int width, int height, int format, VSamplerState samp) {
        this(gl, 3553, width, height, format, samp, null);
    }

    public RenderTarget2D(GL gl, int width, int height, int format, VSamplerState samp, VRenderBuffer renderBuffer) {
        this(gl, 3553, width, height, format, samp, renderBuffer, false);
    }

    public RenderTarget2D(GL gl, int width, int height, int format, VSamplerState samp, VRenderBuffer renderBuffer, boolean depthAttachment) {
        this(gl, 3553, width, height, format, samp, renderBuffer, depthAttachment);
    }

    public RenderTarget2D(GL gl, int targetID, int width, int height, int format) {
        this(gl, targetID, width, height, format, null, null);
    }

    public RenderTarget2D(GL gl, int targetID, int width, int height, int format, VSamplerState samp) {
        this(gl, targetID, width, height, format, samp, null);
    }

    public RenderTarget2D(GL gl, int targetID, int width, int height, int format, VSamplerState samp, VRenderBuffer renderBuffer) {
        this(gl, targetID, width, height, format, samp, renderBuffer, false);
    }

    public RenderTarget2D(GL gl, int targetID, int width, int height, int format, VSamplerState samp, VRenderBuffer renderBuffer, boolean depthAttachment) {
        this._gl = gl;
        this._width = width;
        this._height = height;
        this._appViewport = null;
        this._targetID = targetID;
        switch (targetID) {
            case 3553: {
                this._tex = new VTexture2D(this._gl);
                break;
            }
            case 34037: {
                this._tex = new VTextureRECT(this._gl);
                break;
            }
            default: {
                System.err.println("Can't create a rendertarget with that format, try again");
                return;
            }
        }
        switch (SurfaceFormat.getValue(format)) {
            case 5: {
                this._tex.create(this._targetID, this._width, this._height, 5, samp);
                break;
            }
            case 6: {
                this._tex.create(this._targetID, this._width, this._height, 6, samp);
                break;
            }
            case 4: {
                this._tex.create(this._targetID, this._width, this._height, 4, samp);
                break;
            }
            case 7: {
                this._tex.create(this._targetID, this._width, this._height, 7, samp);
                break;
            }
            case 8: {
                this._tex.create(this._targetID, this._width, this._height, 8, samp);
                break;
            }
            case 21: {
                this._tex.create(this._targetID, this._width, this._height, 21, samp);
                break;
            }
            case 22: {
                this._tex.create(this._targetID, this._width, this._height, 22, samp);
                break;
            }
            case 23: {
                this._tex.create(this._targetID, this._width, this._height, 23, samp);
                break;
            }
            case 9: {
                this._tex.create(this._targetID, this._width, this._height, 9, samp);
                break;
            }
            case 10: {
                this._tex.create(this._targetID, this._width, this._height, 10, samp);
                break;
            }
            case 11: {
                this._tex.create(this._targetID, this._width, this._height, 11, samp);
                break;
            }
            case 12: {
                this._tex.create(this._targetID, this._width, this._height, 12, samp);
                break;
            }
            case 13: {
                this._tex.createDepthRT(this._width, this._height, 13);
                break;
            }
            case 14: {
                this._tex.createDepthRT(this._width, this._height, 14);
                break;
            }
            case 15: {
                this._tex.createDepthRT(this._width, this._height, 15);
                break;
            }
            case 16: {
                this._tex.createDepthRT(this._width, this._height, 16);
                break;
            }
            case 19: {
                this._tex.create(this._targetID, this._width, this._height, 19, samp);
                break;
            }
            case 20: {
                this._tex.create(this._targetID, this._width, this._height, 20, samp);
                break;
            }
            default: {
                System.err.println("Surface Format not yet implemented");
            }
        }
        if (SurfaceFormat.getValue(format) != 13 && SurfaceFormat.getValue(format) != 14 && SurfaceFormat.getValue(format) != 15 && SurfaceFormat.getValue(format) != 16) {
            this._fboID = new int[1];
            this._savedID = new int[1];
            this._savedID[0] = 0;
            if (depthAttachment) {
                this._depthTex = new VTexture2D(this._gl);
                this._depthTex.create(this._targetID, this._width, this._height, 13, samp);
            }
            this._gl.glGenFramebuffersEXT(1, this._fboID, 0);
            this._gl.glBindFramebufferEXT(36160, this._fboID[0]);
            this._gl.glFramebufferTexture2DEXT(36160, 36064, 3553, this._tex.getID(), 0);
            if (depthAttachment) {
                this._gl.glFramebufferTexture2DEXT(36160, 36096, 3553, this._depthTex.getID(), 0);
            }
            if (renderBuffer != null) {
                renderBuffer.bind();
            }
            this.setDrawBuffer(0);
        } else {
            this._fboID = new int[1];
            this._gl.glGenFramebuffersEXT(1, this._fboID, 0);
            this._gl.glBindFramebufferEXT(36160, this._fboID[0]);
            this._gl.glFramebufferTexture2DEXT(36160, 36096, 3553, this._tex.getID(), 0);
            if (renderBuffer != null) {
                renderBuffer.bind();
            }
            this.setDrawBuffer(-1);
        }
        this.validate();
        this._gl.glBindFramebufferEXT(36160, 0);
    }

    public void release() {
        if (this._tex != null) {
            this._tex.release();
        }
        if (this._depthTex != null) {
            this._depthTex.release();
        }
        this._gl.glDeleteTextures(1, this._fboID, 0);
    }

    public void bind() {
        if (this._appViewport == null) {
            this._appViewport = new int[4];
            this._gl.glGetIntegerv(2978, this._appViewport, 0);
        }
        this._gl.glViewport(0, 0, this._width, this._height);
        this._gl.glGetIntegerv(36006, this._savedID, 0);
        if (this._fboID[0] != this._savedID[0]) {
            this._gl.glBindFramebufferEXT(36160, this._fboID[0]);
        }
    }

    public void unbind() {
        if (this._fboID[0] != this._savedID[0]) {
            this._gl.glBindFramebufferEXT(36160, this._savedID[0]);
        }
        if (this._appViewport != null) {
            this._gl.glViewport(this._appViewport[0], this._appViewport[1], this._appViewport[2], this._appViewport[3]);
        }
    }

    public void enable() {
        this.bind();
    }

    public void disable() {
        this.unbind();
    }

    public void attachTexture(int attachment, int texTarget, int texId) {
        this._gl.glFramebufferTexture2DEXT(36160, attachment, texTarget, texId, 0);
    }

    public void attachRenderBuffer(int attachment) {
        this._depthStencilBufferID = new int[1];
        this._gl.glGenRenderbuffersEXT(1, this._depthStencilBufferID, 0);
        this._gl.glBindRenderbufferEXT(36161, this._depthStencilBufferID[0]);
        this._gl.glRenderbufferStorageEXT(36161, attachment, this._width, this._height);
        this._gl.glFramebufferRenderbufferEXT(36160, 36096, 36161, this._depthStencilBufferID[0]);
    }

    public void setDrawBuffer(int idx) {
        switch (idx) {
            case -1: {
                this._gl.glDrawBuffer(0);
                this._gl.glReadBuffer(0);
                break;
            }
            case 0: {
                this._gl.glDrawBuffer(36064);
                break;
            }
            case 1: {
                this._gl.glDrawBuffer(36065);
                break;
            }
            case 2: {
                this._gl.glDrawBuffer(36066);
                break;
            }
            case 3: {
                this._gl.glDrawBuffer(36067);
                break;
            }
            case 4: {
                this._gl.glDrawBuffer(36068);
                break;
            }
            default: {
                this._gl.glDrawBuffer(36064);
            }
        }
    }

    public void restoreDrawBuffer() {
        this._gl.glReadBuffer(1029);
        this._gl.glDrawBuffer(1029);
    }

    public void validate() {
        int stat = this._gl.glCheckFramebufferStatusEXT(36160);
        switch (stat) {
            case 36053: {
                VLogger.getSingleton().log("(RenderTarget2D)  GL_FRAMEBUFFER_COMPLETE_EXT");
                System.out.println("(RenderTarget2D)  GL_FRAMEBUFFER_COMPLETE_EXT");
                break;
            }
            case 36054: {
                VLogger.getSingleton().log("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT");
                System.err.println("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT");
                break;
            }
            case 36055: {
                VLogger.getSingleton().log("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT");
                System.err.println("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT");
                break;
            }
            case 36057: {
                VLogger.getSingleton().log("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT");
                System.err.println("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT");
                break;
            }
            case 36058: {
                VLogger.getSingleton().log("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT");
                System.err.println("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT");
                break;
            }
            case 36059: {
                VLogger.getSingleton().log("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT");
                System.err.println("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT");
                break;
            }
            case 36060: {
                VLogger.getSingleton().log("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT");
                System.err.println("(RenderTarget2D)  GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT");
                break;
            }
            case 36061: {
                VLogger.getSingleton().log("(RenderTarget2D)  GL_FRAMEBUFFER_UNSUPPORTED_EXT");
                System.err.println("(RenderTarget2D)  GL_FRAMEBUFFER_UNSUPPORTED_EXT");
                break;
            }
            default: {
                VLogger.getSingleton().log("(RenderTarget2D)  Unknown");
                System.err.println("(RenderTarget2D)  Unknown");
            }
        }
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public int getID() {
        return this._fboID[0];
    }

    public VTexture getDepthTexture() {
        return this._depthTex;
    }

    public int getDepthID() {
        return this._depthTex.getID();
    }

    public VTexture getTexture() {
        return this._tex;
    }

    public int getTextureID() {
        return this._tex.getID();
    }
}

