function getPoint(x, y, z, origo) {
	
	x = origo['x'] + x * origo['z'] / (z + origo['z']);
	y = origo['y'] - y * origo['z'] / (z + origo['z']);
	
	return [x, y];
}

function drawObject(context, object, origo) {

	var x, y, z;
	
	for (var i = 0; i < object.length; i++) {
	
		context.beginPath();
		
		for (var j = 0; j < object[i].length; j++) {
		
			x = getPoint(object[i][j][0], object[i][j][1], object[i][j][2], origo)[0];
			y = getPoint(object[i][j][0], object[i][j][1], object[i][j][2], origo)[1];
			
			if (j == 0) {
				context.moveTo(x, y);
			} else {
				context.lineTo(x, y);
			}
		}
		
		context.closePath();
		context.stroke();
	}	
}

function resizeObject(object, multiplier) {
	
	for (var i = 0; i < object.length; i++) {
		
		for (var j = 0; j < object[i].length; j++) {
			
			object[i][j][0] = object[i][j][0] * multiplier;
			object[i][j][1] = object[i][j][1] * multiplier;
			object[i][j][2] = object[i][j][2] * multiplier;
		}
	}
}

function moveObject(object, x, y, z) {

	for (var i = 0; i < object.length; i++) {
		
		for (var j = 0; j < object[i].length; j++) {
			
			object[i][j][0] = object[i][j][0] + x;
			object[i][j][1] = object[i][j][1] + y;
			object[i][j][2] = object[i][j][2] + z;
		}
	}	
}

function rotateObjectX(object, degree) {

	var x, y, z;
	
	for (var i = 0; i < object.length; i++) {
	
		for (var j = 0; j < object[i].length; j++) {
		
			y = object[i][j][1];
			z = object[i][j][2];
			
			object[i][j][1] = Math.cos(degree) * y - Math.sin(degree) * z;
			object[i][j][2] = Math.sin(degree) * y + Math.cos(degree) * z;
		}
	}
}

function rotateObjectY(object, degree) {

	var x, y, z;
	
	for (var i = 0; i < object.length; i++) {
	
		for (var j = 0; j < object[i].length; j++) {
		
			x = object[i][j][0];
			z = object[i][j][2];
			
			object[i][j][0] = Math.cos(degree) * x - Math.sin(degree) * z;
			object[i][j][2] = Math.sin(degree) * x + Math.cos(degree) * z;
		}
	}
}

function rotateObjectZ(object, degree) {

	var x, y, z;
	
	for (var i = 0; i < object.length; i++) {
	
		for (var j = 0; j < object[i].length; j++) {
		
			x = object[i][j][0];
			y = object[i][j][1];
			
			object[i][j][0] = Math.cos(degree) * x - Math.sin(degree) * y;
			object[i][j][1] = Math.sin(degree) * x + Math.cos(degree) * y;
		}
	}
}