varying vec2 texcoord;
uniform sampler2DRect tex0;
uniform sampler2DRect tex1;
uniform float angle;
uniform float alpha;


void main (void)
{
	vec2 texcoord0 = texcoord;
	float theta = radians(angle);
	float blurAmount=6.0;

	float amount=(1.0-alpha)*blurAmount;


	// our offsets, where we sample
	vec2 amount1,amount2,amount3,amount4,amount5,amount6,amount7,amount8;

	amount1 = vec2(cos(theta) , sin(theta)) * amount;

	amount2 = amount1 *2.0;
	amount3 = amount1 *3.0;
	amount4 = amount1 *4.0;
	amount5 = -amount1;
	amount6 = amount5 * 2.0;
	amount7 = amount5 * 3.0;
	amount8 = amount5 * 4.0;


	// sample our textures
	vec4 sample0 = texture2DRect(tex0, texcoord0);
	vec4 sample1 = texture2DRect(tex0, texcoord0 + amount1);
	vec4 sample2 = texture2DRect(tex0, texcoord0 + amount2);
	vec4 sample3 = texture2DRect(tex0, texcoord0 + amount3);
	vec4 sample4 = texture2DRect(tex0, texcoord0 + amount4);
	vec4 sample5 = texture2DRect(tex0, texcoord0 + amount5);
	vec4 sample6 = texture2DRect(tex0, texcoord0 + amount6);
	vec4 sample7 = texture2DRect(tex0, texcoord0 + amount7);
	vec4 sample8 = texture2DRect(tex0, texcoord0 + amount8);

	vec4 cola=(sample0 + sample1 + sample2 + sample3 + sample4 + sample5 + sample6 + sample7 + sample8) / 9.0;

	///////////////////////////////////////////

	amount=(alpha)*blurAmount;


	amount1 = vec2(cos(theta) , sin(theta)) * amount;

	amount2 = amount1 *2.0;
	amount3 = amount1 *3.0;
	amount4 = amount1 *4.0;
	amount5 = -amount1;
	amount6 = amount5 * 2.0;
	amount7 = amount5 * 3.0;
	amount8 = amount5 * 4.0;



	sample0 = texture2DRect(tex1, texcoord0);
	sample1 = texture2DRect(tex1, texcoord0 + amount1);
	sample2 = texture2DRect(tex1, texcoord0 + amount2);
	sample3 = texture2DRect(tex1, texcoord0 + amount3);
	sample4 = texture2DRect(tex1, texcoord0 + amount4);
	sample5 = texture2DRect(tex1, texcoord0 + amount5);
	sample6 = texture2DRect(tex1, texcoord0 + amount6);
	sample7 = texture2DRect(tex1, texcoord0 + amount7);
	sample8 = texture2DRect(tex1, texcoord0 + amount8);

	vec4 colb=(sample0 + sample1 + sample2 + sample3 + sample4 + sample5 + sample6 + sample7 + sample8) / 9.0;


	
	//gl_FragColor =(texture2DRect(tex0, texcoord0)+texture2DRect(tex1, texcoord0))*0.2;
	gl_FragColor=
		cola*alpha+
		colb*(1.0-alpha);

}
