/*
 * Decompiled with CFR 0.152.
 */
package sumoTween;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumoTween.KeyFloat;
import sumoTween.Tweener;
import sumoTween.easing.Back;
import sumoTween.easing.Bounce;
import sumoTween.easing.Circ;
import sumoTween.easing.Cubic;
import sumoTween.easing.EasingIF;
import sumoTween.easing.Expo;
import sumoTween.easing.Linear;
import sumoTween.easing.None;
import sumoTween.easing.Quad;
import sumoTween.easing.Quart;
import sumoTween.easing.Quint;
import sumoTween.easing.Sine;

public class TweenerXML {
    public static EasingIF[] easings = new EasingIF[]{new Linear(), new Sine(), new Quad(), new Cubic(), new Expo(), new Back(), new Bounce(), new Quart(), new Quint(), new Circ(), new None()};

    public static EasingIF getEasingByName(String name) {
        for (int i = 0; i < easings.length; ++i) {
            if (!easings[i].getClass().getSimpleName().equals(name)) continue;
            return easings[i];
        }
        return null;
    }

    public static Tweener fromXML(Element element) {
        return TweenerXML.fromXML(element, null);
    }

    public static Tweener fromXML(Element element, Tweener tween) {
        if (tween == null) {
            tween = new Tweener();
        }
        tween.setName(element.getAttribute("name"));
        tween.setEasing(TweenerXML.getEasingByName(element.getAttribute("easing")));
        tween.setKeyframed(true);
        tween.setEnabled(Boolean.parseBoolean(element.getAttribute("enabled")));
        tween.useFFT = Boolean.parseBoolean(element.getAttribute("usefft"));
        NodeList nl = element.getElementsByTagName("fftconfig");
        if (nl.getLength() > 0) {
            Element e = (Element)nl.item(0);
            tween.FFTSpectrumStart = Integer.parseInt(e.getAttribute("start"));
            tween.FFTSpectrumEnd = Integer.parseInt(e.getAttribute("end"));
            tween.FFTMode = Integer.parseInt(e.getAttribute("mode"));
            tween.FFTMinus = Float.parseFloat(e.getAttribute("minus"));
            tween.FFTMulti = Float.parseFloat(e.getAttribute("multi"));
            tween.FFTHitMode = Integer.parseInt(e.getAttribute("hitmode"));
            tween.FFTHitValue = Float.parseFloat(e.getAttribute("hitvalue"));
        }
        NodeList keyElements = element.getElementsByTagName("key");
        for (int k = 0; k < keyElements.getLength(); ++k) {
            Element el = (Element)keyElements.item(k);
            float t = Float.parseFloat(el.getAttribute("t"));
            float v = Float.parseFloat(el.getAttribute("v"));
            int d = Integer.parseInt(el.getAttribute("d"));
            String easing = el.getAttribute("e");
            KeyFloat kf = tween.set(t, v, d);
            if (easing != null && !easing.equals("")) {
                kf.setEasing(TweenerXML.getEasingByName(easing));
                continue;
            }
            kf.setEasing(tween.getEasing());
        }
        tween.sort();
        tween.setKeyframed(Boolean.parseBoolean(element.getAttribute("keyframed")));
        tween.notifyKeysChanged();
        return tween;
    }

    public static Element toXML(Element element, Tweener tween) {
        Element ele = element.getOwnerDocument().createElement("tween");
        KeyFloat[] keys = tween.getKeys();
        ele.setAttribute("name", tween.getName());
        ele.setAttribute("easing", tween.getEasing().getClass().getSimpleName());
        ele.setAttribute("keyframed", String.valueOf(tween.isKeyframed()));
        ele.setAttribute("enabled", String.valueOf(tween.isEnabled()));
        ele.setAttribute("usefft", String.valueOf(tween.useFFT));
        Element fftEle = element.getOwnerDocument().createElement("fftconfig");
        fftEle.setAttribute("start", String.valueOf(tween.FFTSpectrumStart));
        fftEle.setAttribute("end", String.valueOf(tween.FFTSpectrumEnd));
        fftEle.setAttribute("mode", String.valueOf(tween.FFTMode));
        fftEle.setAttribute("minus", String.valueOf(tween.FFTMinus));
        fftEle.setAttribute("multi", String.valueOf(tween.FFTMulti));
        fftEle.setAttribute("hitmode", String.valueOf(tween.FFTHitMode));
        fftEle.setAttribute("hitvalue", String.valueOf(tween.FFTHitValue));
        ele.appendChild(fftEle);
        for (int i = 0; i < keys.length; ++i) {
            Element k = ele.getOwnerDocument().createElement("key");
            ele.appendChild(k);
            k.setAttribute("t", String.valueOf(keys[i].getTime()));
            k.setAttribute("v", String.valueOf(keys[i].getValue()));
            k.setAttribute("d", String.valueOf(keys[i].getEasingDirection()));
            if (keys[i].getEasing().getClass().equals(tween.getEasing().getClass())) continue;
            k.setAttribute("e", String.valueOf(keys[i].getEasing().getClass().getSimpleName()));
        }
        return ele;
    }
}

