/*
 * Decompiled with CFR 0.152.
 */
package sumoTween;

import java.util.ArrayList;
import java.util.Vector;
import org.lwjgl.Sys;
import sumo.audio.FFT;
import sumoTween.KeyFloat;
import sumoTween.easing.Cubic;
import sumoTween.easing.EasingIF;
import sumoTween.events.KeyEvent;
import sumoTween.events.TweenEvent;
import sumoTween.timer.TimerIF;
import sumoTween.timer.freeTimer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tweener {
    public static final int EASING_IN = 0;
    public static final int EASING_OUT = 1;
    public static final int EASING_INOUT = 2;
    public static final int EASING_NONE = 3;
    private boolean isKeyframed = true;
    private KeyFloat[] keyframes;
    private int lastNotifiedKey = -1;
    EasingIF defaultEasing;
    TimerIF timer = null;
    Vector tweenEventListeners = null;
    public boolean useFFT = false;
    public int FFTSpectrumStart = 0;
    public int FFTSpectrumEnd = 0;
    public int FFTMode = 0;
    public float FFTMinus = 0.0f;
    public float FFTMulti = 1.0f;
    public int FFTHitMode = 0;
    public float FFTHitValue = 0.0f;
    public static final int FFT_HITMODE_NONE = 0;
    public static final int FFT_HITMODE_CYCLE = 1;
    public static final int FFT_HITMODE_HITFALL = 2;
    float allValue = 0.0f;
    KeyFloat min;
    private String name = "";
    float tempFFTValue = 0.0f;
    long lastffthit = 0L;
    boolean fftcycledir = false;
    public float slopeDiff = 0.25f;
    boolean enabled = true;
    String[] titlevalues;

    public Tweener() {
        this.defaultEasing = new Cubic();
        this.initKeyframes();
    }

    public Tweener(EasingIF easing) {
        this.defaultEasing = easing;
        this.initKeyframes();
    }

    private void initKeyframes() {
        if (this.timer == null) {
            this.timer = freeTimer.timer;
        }
        this.keyframes = new KeyFloat[1];
        this.keyframes[0] = new KeyFloat(this, 0.0f, 0.0f, 3);
        this.keyframes[0].setEasing(this.defaultEasing);
        if (this.tweenEventListeners == null) {
            this.tweenEventListeners = new Vector();
        }
    }

    public void addTweenEventListener(TweenEvent ev) {
        this.tweenEventListeners.add(ev);
    }

    protected void notifyKeysChanged() {
        for (int i = 0; i < this.tweenEventListeners.size(); ++i) {
            TweenEvent ev = (TweenEvent)this.tweenEventListeners.elementAt(i);
            ev.keysChanged();
        }
    }

    public KeyFloat add(float timeDiff, float value) {
        return this.set(this.timer.getTime() + timeDiff, value, 3, null, null);
    }

    public KeyFloat add(float timeDiff, float value, int dir, EasingIF ease, KeyEvent keyEvent) {
        return this.set(this.timer.getTime() + timeDiff, value, dir, ease, keyEvent);
    }

    public KeyFloat add(float timeDiff, float value, int dir, KeyEvent event) {
        return this.set(this.timer.getTime() + timeDiff, value, dir, null, event);
    }

    public KeyFloat add(float timeDiff, float value, int dir, EasingIF easing) {
        return this.set(this.timer.getTime() + timeDiff, value, dir, easing, null);
    }

    public KeyFloat add(float timeDiff, float value, int dir) {
        return this.set(this.timer.getTime() + timeDiff, value, dir, null, null);
    }

    public KeyFloat set(float time, float value) {
        return this.set(time, value, 3, null, null);
    }

    public KeyFloat add(float timeDiff, float value, KeyEvent keyEvent) {
        return this.set(timeDiff, value, 3, null, keyEvent);
    }

    public KeyFloat set(float time, float value, int dir) {
        return this.set(time, value, dir, null, null);
    }

    public KeyFloat set(float time, float value, int dir, EasingIF ease) {
        return this.set(time, value, dir, ease, null);
    }

    public KeyFloat set(float time, float value, int dir, EasingIF ease, KeyEvent event) {
        KeyFloat ret = null;
        if (!this.isKeyframed) {
            this.keyframes[0].setValue(value);
            if (event != null) {
                this.keyframes[0].addKeyEventListener(event);
            }
            ret = this.keyframes[0];
            this.notifyKeysChanged();
        } else {
            boolean alldone = false;
            for (int i = 0; i < this.keyframes.length; ++i) {
                if (this.keyframes[i].getTime() != time) continue;
                this.keyframes[i].setValue(value);
                this.keyframes[i].setEasingDirection(dir);
                this.keyframes[i].addKeyEventListener(event);
                this.normalize();
                alldone = true;
                this.notifyKeysChanged();
                ret = this.keyframes[i];
            }
            if (!alldone) {
                if (time > this.keyframes[this.keyframes.length - 1].getTime()) {
                    this.keyframes = this.resizeArray(this.keyframes, 1);
                    this.keyframes[this.keyframes.length - 1] = new KeyFloat(this, time, value, dir);
                    this.keyframes[this.keyframes.length - 1].addKeyEventListener(event);
                    ret = this.keyframes[this.keyframes.length - 1];
                } else {
                    int keystart = this.getKeyIndex(time);
                    this.keyframes = this.resizeArray(this.keyframes, 1);
                    for (int i = this.keyframes.length - 1; i > keystart + 1; --i) {
                        this.keyframes[i] = this.keyframes[i - 1];
                    }
                    this.keyframes[keystart + 1] = new KeyFloat(this, time, value, dir);
                    this.keyframes[keystart + 1].addKeyEventListener(event);
                    ret = this.keyframes[keystart + 1];
                }
                this.notifyKeysChanged();
                this.normalize();
            }
        }
        if (ease != null) {
            ret.setEasing(ease);
        } else {
            ret.setEasing(this.defaultEasing);
        }
        return ret;
    }

    private KeyFloat getMaxValueKey() {
        KeyFloat max = new KeyFloat(this, 0.0f, -9999999.0f, 3);
        for (int i = 0; i < this.keyframes.length; ++i) {
            if (this.keyframes[i] == null || !(this.keyframes[i].getValue() > max.getValue())) continue;
            max = this.keyframes[i];
        }
        return max;
    }

    private KeyFloat getMinValueKey() {
        KeyFloat min = new KeyFloat(this, 0.0f, 9999999.0f, 3);
        for (int i = 0; i < this.keyframes.length; ++i) {
            if (this.keyframes[i] == null || !(this.keyframes[i].getValue() < min.getValue())) continue;
            min = this.keyframes[i];
        }
        return min;
    }

    public void normalize() {
        this.min = this.getMinValueKey();
        KeyFloat max = this.getMaxValueKey();
        this.allValue = Math.abs(max.getValue() - this.min.getValue());
        for (int i = 0; i < this.keyframes.length; ++i) {
            if (this.keyframes[i] == null) continue;
            float idiff = Math.abs(this.keyframes[i].getValue() - this.min.getValue());
            this.keyframes[i].setInternalValue(idiff / this.allValue);
        }
    }

    public int getKeyIndex(float time) {
        int which = 0;
        for (int i = 0; i < this.keyframes.length; ++i) {
            if (!(this.keyframes[i].getTime() <= time)) continue;
            which = i;
        }
        return which;
    }

    public float getValue(float time) {
        return this.getValue(time, true);
    }

    private float getFFTValue() {
        if (this.FFTHitMode == 0) {
            return FFT.getFFT(this.FFTMode, this.FFTSpectrumStart, this.FFTSpectrumEnd, this.FFTMinus, this.FFTMulti);
        }
        if (this.FFTHitMode == 1) {
            float r = FFT.getFFT(this.FFTMode, this.FFTSpectrumStart, this.FFTSpectrumEnd, this.FFTMinus, this.FFTMulti);
            if (r > 0.0f) {
                this.lastffthit = Sys.getTime();
                this.tempFFTValue = !this.fftcycledir ? (this.tempFFTValue += this.FFTHitValue * (float)Math.random()) : (this.tempFFTValue -= this.FFTHitValue * (float)Math.random());
                if (this.tempFFTValue > 1.0f) {
                    this.fftcycledir = true;
                    this.tempFFTValue = 1.0f;
                }
                if (this.tempFFTValue < 0.0f) {
                    this.fftcycledir = false;
                    this.tempFFTValue = 0.0f;
                }
            }
            return this.tempFFTValue;
        }
        if (this.FFTHitMode == 2) {
            float r;
            if (Sys.getTime() - this.lastffthit >= 30L) {
                this.tempFFTValue -= this.FFTHitValue * 0.33f;
                if (this.tempFFTValue < 0.0f) {
                    this.tempFFTValue = 0.0f;
                }
            }
            if ((r = FFT.getFFT(this.FFTMode, this.FFTSpectrumStart, this.FFTSpectrumEnd, this.FFTMinus, this.FFTMulti)) > 0.0f) {
                this.tempFFTValue = 1.0f;
                this.lastffthit = Sys.getTime();
            }
            return this.tempFFTValue;
        }
        return 0.0f;
    }

    public float getValueFFT() {
        return this.getFFTValue();
    }

    public float getValueWithoutFFT() {
        boolean pre = this.useFFT;
        this.useFFT = false;
        float r = this.getValue(this.timer.getTime());
        this.useFFT = pre;
        return r;
    }

    public float getValue(float time, boolean notify) {
        float ret = 0.0f;
        if (this.useFFT) {
            ret = this.getFFTValue();
        } else if (!this.isKeyframed) {
            if (notify && 0 != this.lastNotifiedKey) {
                this.lastNotifiedKey = 0;
                this.keyframes[0].notifyKeyEventListeners();
            }
            ret = this.keyframes[0].getValue();
        } else {
            if (this.min == null) {
                this.normalize();
            }
            ret = this.getInternalValue(time, notify) * this.allValue + this.min.getValue();
        }
        if (Float.isNaN(ret)) {
            ret = 0.0f;
        }
        return ret;
    }

    public float getInternalValue(float time, boolean notify) {
        EasingIF theEasing;
        if (this.keyframes.length == 1) {
            return this.keyframes[0].getValue();
        }
        if (time >= this.keyframes[this.keyframes.length - 1].getTime()) {
            if (notify && this.keyframes[this.keyframes.length - 1].hasKeyEventListeners()) {
                this.lastNotifiedKey = this.keyframes.length - 1;
                this.keyframes[this.lastNotifiedKey].notifyKeyEventListeners();
            }
            return this.keyframes[this.keyframes.length - 1].getInternalValue();
        }
        int which = this.getKeyIndex(time);
        int next = which + 1;
        float ttime = time - this.keyframes[which].getTime();
        float ratio = 0.0f;
        if (notify && this.lastNotifiedKey != which && this.keyframes[which].hasKeyEventListeners()) {
            this.lastNotifiedKey = which;
            this.keyframes[which].notifyKeyEventListeners();
        }
        if ((theEasing = this.keyframes[which].getEasing()) == null) {
            return 0.0f;
        }
        if (this.keyframes[which].getEasingDirection() == 0) {
            ratio = theEasing.easeIn(ttime, 0.0f, 1.0f, this.keyframes[next].getTime() - this.keyframes[which].getTime());
        } else if (this.keyframes[which].getEasingDirection() == 1) {
            ratio = theEasing.easeOut(ttime, 0.0f, 1.0f, this.keyframes[next].getTime() - this.keyframes[which].getTime());
        } else if (this.keyframes[which].getEasingDirection() == 2) {
            ratio = theEasing.easeInOut(ttime, 0.0f, 1.0f, this.keyframes[next].getTime() - this.keyframes[which].getTime());
        } else if (this.keyframes[which].getEasingDirection() == 3) {
            ratio = theEasing.easeNone(ttime, 0.0f, 1.0f, this.keyframes[next].getTime() - this.keyframes[which].getTime());
        }
        float r = 1.0f;
        float di = Math.abs(this.keyframes[next].getInternalValue() - this.keyframes[which].getInternalValue());
        r = this.keyframes[next].getValue() > this.keyframes[which].getValue() ? this.keyframes[which].getInternalValue() + di * ratio : this.keyframes[which].getInternalValue() - di * ratio;
        if (Float.isNaN(r)) {
            r = 0.0f;
        }
        return r;
    }

    private int getLastkeyIndex() {
        return this.keyframes.length - 1;
    }

    private KeyFloat[] resizeArray(KeyFloat[] storedObjects, int growthFactor) {
        if (storedObjects == null) {
            throw new NullPointerException();
        }
        int currentCapacity = storedObjects.length;
        int newCapacity = currentCapacity + growthFactor;
        KeyFloat[] newStore = new KeyFloat[newCapacity];
        int l = storedObjects.length;
        if (newCapacity < storedObjects.length) {
            l = newCapacity;
        }
        System.arraycopy(storedObjects, 0, newStore, 0, l);
        return newStore;
    }

    public void printKeys() {
        System.out.println("------------------------------------");
        String easing = "";
        if (this.getEasing() != null) {
            easing = easing + this.getEasing().getClass().getSimpleName();
        }
        System.out.println("tween: " + this.getName() + " keyframed:" + this.isKeyframed + " easing:" + easing);
        System.out.println("time \tintervalue \tvalue \tevents \teasing");
        for (int i = 0; i < this.keyframes.length; ++i) {
            String eas = "";
            if (this.keyframes[i].getEasing() != null) {
                this.keyframes[i].getEasing().getClass().getSimpleName();
            }
            if (this.keyframes[i] == null) {
                System.out.println("null!");
                continue;
            }
            System.out.println(this.keyframes[i].getTime() + " \t " + this.keyframes[i].getInternalValue() + "\t\t" + this.keyframes[i].getValue() + "\t" + this.keyframes[i].hasKeyEventListeners() + "\t" + eas);
        }
    }

    public int getIntValue() {
        return (int)this.getValue(this.timer.getTime(), true);
    }

    public void clear(float f) {
        this.initKeyframes();
        this.keyframes[0].setValue(f);
        this.notifyKeysChanged();
    }

    public void clear() {
        float val = this.getLastKey().getValue();
        this.clear(val);
    }

    public float getTime() {
        return this.timer.getTime();
    }

    public boolean isAnimFinished() {
        return this.getTime() > this.getLastKey().getTime();
    }

    public void setEasing(EasingIF easing) {
        this.defaultEasing = easing;
    }

    public EasingIF getEasing() {
        return this.defaultEasing;
    }

    public KeyFloat getLastKey() {
        return this.keyframes[this.keyframes.length - 1];
    }

    public float getValue() {
        return this.getValue(this.timer.getTime());
    }

    public KeyFloat getKey(float time) {
        return this.keyframes[this.getKeyIndex(time)];
    }

    public int getIntValue(float time) {
        return (int)this.getValue(time, true);
    }

    public int getIntValue(float time, boolean notify) {
        return (int)this.getValue(time, notify);
    }

    public void resetTimer() {
        this.timer.setTime(0.0f);
    }

    public void setTimer(TimerIF timer) {
        this.timer = timer;
    }

    public void set(float value) {
        this.set(this.timer.getTime(), value);
    }

    public double getAngle() {
        float v1 = this.getInternalValue(freeTimer.timer.getTime() + this.slopeDiff, false);
        float v2 = this.getInternalValue(freeTimer.timer.getTime() - this.slopeDiff, false);
        double angle = 180.0 * Math.atan2(v2 - v1, -2.0f * this.slopeDiff) / Math.PI;
        return angle;
    }

    public boolean isKeyframed() {
        return this.isKeyframed;
    }

    public void setKeyframed(boolean b) {
        this.isKeyframed = b;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public KeyFloat[] getKeys() {
        return this.keyframes;
    }

    public KeyFloat getKeyByIndex(int i) {
        return this.keyframes[i];
    }

    public float getNormalizedValue() {
        return this.getNormalizedValue(this.timer.getTime());
    }

    public float getNormalizedValue(float time) {
        return this.getInternalValue(time, false);
    }

    public KeyFloat add(KeyFloat k) {
        return this.set(k.getTime(), k.getValue(), k.getEasingDirection());
    }

    public void deleteKeys(ArrayList<KeyFloat> markedKeys) {
        System.out.println("before:" + this.keyframes.length);
        for (KeyFloat key : markedKeys) {
            this.deleteKeyAt(key.getTime());
        }
        System.out.println("after:" + this.keyframes.length);
    }

    public void deleteKeyAt(float time) {
        for (int i = 0; i < this.keyframes.length; ++i) {
            if (this.keyframes[i].getTime() != time) continue;
            System.out.println("key found..");
            this.keyframes[i].setTime(1.0E9f);
        }
        this.sort();
        this.resizeArray(this.keyframes, -1);
    }

    public void setEnabled(boolean b) {
        this.notifyKeysChanged();
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void sort() {
        for (int i = 0; i < this.keyframes.length; ++i) {
            if (!Float.isNaN(this.keyframes[i].getTime())) continue;
            this.keyframes[i].setTime(0.0f);
            System.out.println("found NaN!!!");
        }
        for (int out = this.keyframes.length - 1; out > 0; --out) {
            for (int in = 0; in < out; ++in) {
                if (!(this.keyframes[in].getTime() > this.keyframes[out].getTime())) continue;
                KeyFloat temp = this.keyframes[in];
                this.keyframes[in] = this.keyframes[out];
                this.keyframes[out] = temp;
            }
        }
    }

    public void setTitleValues(String[] values) {
        this.titlevalues = values;
    }

    public String getTitleValue() {
        if (this.titlevalues == null) {
            return "";
        }
        int i = this.getIntValue();
        if (i < 0 || i >= this.titlevalues.length) {
            return " ---";
        }
        return ": " + this.titlevalues[i];
    }

    public int getNumKeys() {
        return this.keyframes.length;
    }
}

