/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d.material;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumo.project.Project;
import sumo.resource.types.Texture;
import sumo.v3d.material.TextureMap;
import sumo.v3d.math.VEC3Tweened;
import sumoTween.Tweener;
import sumoTween.TweenerXML;
import sumoTween.easing.Linear;

public class MaterialSettings {
    private FloatBuffer colorSpecularFB = BufferUtils.createFloatBuffer(4);
    private FloatBuffer colorDiffuseFB = BufferUtils.createFloatBuffer(4);
    private FloatBuffer colorAmbientFB = BufferUtils.createFloatBuffer(4);
    public VEC3Tweened colorDiffuse;
    public VEC3Tweened colorAmbient;
    public VEC3Tweened colorSpecular;
    public boolean twosided = false;
    public boolean wireframe = false;
    public boolean faceted = false;
    public float opacity = 1.0f;
    public float selfillumination = 0.0f;
    public Tweener shininess;
    public Tweener emission = new Tweener(new Linear());
    public TextureMap mapDiffuse = null;
    public TextureMap mapOpacity = null;
    public TextureMap mapReflection = null;
    public String title = "";
    public Texture shadowMap = null;
    public boolean forceNoShadow = true;

    public MaterialSettings() {
        this.emission.setName("emission");
        this.emission.setKeyframed(false);
        this.emission.clear(0.5f);
        this.emission.setTimer(Project.getProject().getTimer());
        this.shininess = new Tweener(new Linear());
        this.shininess.setName("shininess");
        this.shininess.setKeyframed(false);
        this.shininess.clear(0.5f);
        this.shininess.setTimer(Project.getProject().getTimer());
    }

    public void setDiffuse(float[] c) {
        if (this.colorDiffuse == null) {
            this.colorDiffuse = new VEC3Tweened(new Linear(), Project.getProject().getTimer());
            this.colorDiffuse.setKeyframed(false);
            this.colorDiffuse.x.set(c[0]);
            this.colorDiffuse.y.set(c[1]);
            this.colorDiffuse.z.set(c[2]);
        }
        this.colorDiffuseFB.put(c).rewind();
    }

    public void setSpecular(float[] c) {
        if (this.colorSpecular == null) {
            this.colorSpecular = new VEC3Tweened(new Linear(), Project.getProject().getTimer());
            this.colorSpecular.setKeyframed(false);
            this.colorSpecular.x.set(c[0]);
            this.colorSpecular.y.set(c[1]);
            this.colorSpecular.z.set(c[2]);
        }
        this.colorSpecularFB.put(c).rewind();
    }

    public void setAmbient(float[] c) {
        if (this.colorAmbient == null) {
            this.colorAmbient = new VEC3Tweened(new Linear(), Project.getProject().getTimer());
            this.colorAmbient.setKeyframed(false);
            this.colorAmbient.x.set(c[0]);
            this.colorAmbient.y.set(c[1]);
            this.colorAmbient.z.set(c[2]);
        }
        this.colorAmbientFB.put(c).rewind();
    }

    public void setGlossiness(float[] readFloatArray) {
        this.shininess.set(readFloatArray[0] / 100.0f);
    }

    public void saveXML(Element root) {
        Element mat = root.getOwnerDocument().createElement("materialsettings");
        mat.setAttribute("title", this.title);
        mat.appendChild(TweenerXML.toXML(mat, this.shininess));
        mat.appendChild(TweenerXML.toXML(mat, this.emission));
        this.colorAmbient.x.setName("colorAmbient.x");
        this.colorAmbient.y.setName("colorAmbient.y");
        this.colorAmbient.z.setName("colorAmbient.z");
        mat.appendChild(TweenerXML.toXML(mat, this.colorAmbient.x));
        mat.appendChild(TweenerXML.toXML(mat, this.colorAmbient.y));
        mat.appendChild(TweenerXML.toXML(mat, this.colorAmbient.z));
        this.colorSpecular.x.setName("colorSpecular.x");
        this.colorSpecular.y.setName("colorSpecular.y");
        this.colorSpecular.z.setName("colorSpecular.z");
        mat.appendChild(TweenerXML.toXML(mat, this.colorSpecular.x));
        mat.appendChild(TweenerXML.toXML(mat, this.colorSpecular.y));
        mat.appendChild(TweenerXML.toXML(mat, this.colorSpecular.z));
        this.colorDiffuse.x.setName("colorDiffuse.x");
        this.colorDiffuse.y.setName("colorDiffuse.y");
        this.colorDiffuse.z.setName("colorDiffuse.z");
        mat.appendChild(TweenerXML.toXML(mat, this.colorDiffuse.x));
        mat.appendChild(TweenerXML.toXML(mat, this.colorDiffuse.y));
        mat.appendChild(TweenerXML.toXML(mat, this.colorDiffuse.z));
        root.appendChild(mat);
    }

    public void loadXML(Element root) {
        NodeList nl = root.getElementsByTagName("tween");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            String tweenName = e.getAttribute("name");
            if (tweenName.equals("shininess")) {
                TweenerXML.fromXML(e, this.shininess);
                continue;
            }
            if (tweenName.equals("emission")) {
                TweenerXML.fromXML(e, this.emission);
                continue;
            }
            if (tweenName.equals("colorDiffuse.x")) {
                TweenerXML.fromXML(e, this.colorDiffuse.x);
                continue;
            }
            if (tweenName.equals("colorDiffuse.y")) {
                TweenerXML.fromXML(e, this.colorDiffuse.y);
                continue;
            }
            if (tweenName.equals("colorDiffuse.z")) {
                TweenerXML.fromXML(e, this.colorDiffuse.z);
                continue;
            }
            if (tweenName.equals("colorSpecular.x")) {
                TweenerXML.fromXML(e, this.colorSpecular.x);
                continue;
            }
            if (tweenName.equals("colorSpecular.y")) {
                TweenerXML.fromXML(e, this.colorSpecular.y);
                continue;
            }
            if (tweenName.equals("colorSpecular.z")) {
                TweenerXML.fromXML(e, this.colorSpecular.z);
                continue;
            }
            if (tweenName.equals("colorAmbient.x")) {
                TweenerXML.fromXML(e, this.colorAmbient.x);
                continue;
            }
            if (tweenName.equals("colorAmbient.y")) {
                TweenerXML.fromXML(e, this.colorAmbient.y);
                continue;
            }
            if (!tweenName.equals("colorAmbient.z")) continue;
            TweenerXML.fromXML(e, this.colorAmbient.z);
        }
    }

    public FloatBuffer getColorDiffuseFB() {
        this.colorDiffuseFB.put(this.colorDiffuse.getAsArray()).rewind();
        return this.colorDiffuseFB;
    }

    public FloatBuffer getColorAmbientFB() {
        this.colorAmbientFB.put(this.colorAmbient.getAsArray()).rewind();
        return this.colorAmbientFB;
    }

    public FloatBuffer getColorSpecularFB() {
        this.colorSpecularFB.put(this.colorSpecular.getAsArray()).rewind();
        return this.colorSpecularFB;
    }
}

