/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d.material;

import org.lwjgl.opengl.GL11;
import sumo.shader.SumoShader;
import sumo.v3d.material.MaterialRendererIF;
import sumo.v3d.material.MaterialSettings;
import sumo.v3d.material.MaterialShaderLib;

public class MaterialRendererShader
implements MaterialRendererIF {
    public SumoShader shader;
    MaterialSettings settings;
    boolean shaderBuilt = false;

    public void reload() {
        this.shader = MaterialShaderLib.createShader(this.settings);
    }

    public void buildShader() {
        this.shader = MaterialShaderLib.createShader(this.settings);
        this.shaderBuilt = true;
        if (this.settings.mapDiffuse != null && this.settings.mapDiffuse.texture != null) {
            this.shader.setMultiTexture(0, this.settings.mapDiffuse.texture.getID(), "map_diffuse");
        }
    }

    public void setSettings(MaterialSettings m) {
        this.settings = m;
    }

    public void bind() {
        if (!this.shaderBuilt) {
            this.buildShader();
        }
        if (this.shader == null) {
            System.out.println("materialrenderershader null");
            return;
        }
        if (this.settings.opacity != 1.0f) {
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glColor4f(this.settings.getColorDiffuseFB().get(0), this.settings.getColorDiffuseFB().get(1), this.settings.getColorDiffuseFB().get(2), this.settings.opacity);
            GL11.glDepthMask(false);
        } else {
            GL11.glColor3f(this.settings.getColorDiffuseFB().get(0), this.settings.getColorDiffuseFB().get(1), this.settings.getColorDiffuseFB().get(2));
        }
        if (this.settings.selfillumination == 100.0f) {
            GL11.glDisable(2896);
        }
        GL11.glEnable(2903);
        GL11.glMaterial(1032, 4609, this.settings.getColorDiffuseFB());
        GL11.glMaterial(1032, 4610, this.settings.getColorSpecularFB());
        GL11.glMaterial(1032, 4608, this.settings.getColorAmbientFB());
        GL11.glMaterialf(1032, 5633, (this.settings.shininess.getValue() + 0.01f) * 120.0f);
        GL11.glEnable(3553);
        if (this.shader != null) {
            this.shader.bind();
        }
    }

    public void unbind() {
        if (this.shader == null) {
            return;
        }
        this.shader.unbind();
        if (this.settings.opacity != 1.0f) {
            GL11.glDisable(3042);
            GL11.glDepthMask(true);
        }
        if (this.settings.selfillumination == 100.0f) {
            GL11.glEnable(2896);
        }
    }
}

