/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumo.project.Project;
import sumo.v3d.Node;
import sumo.v3d.NodeIF;
import sumo.v3d.math.VEC3Tweened;
import sumo.v3d.math.Vec3fkeyframed;
import sumoTween.Tweener;
import sumoTween.TweenerXML;
import sumoTween.easing.Linear;

public class Light
extends Node
implements NodeIF {
    private FloatBuffer colorDiffuseFB = BufferUtils.createFloatBuffer(4);
    private FloatBuffer colorAmbientFB = BufferUtils.createFloatBuffer(4);
    private FloatBuffer colorSpecularFB = BufferUtils.createFloatBuffer(4);
    public Tweener attenuationConstant;
    public Tweener attenuationLinear;
    public Tweener attenuationQuadratic;
    public VEC3Tweened colorDiffuse;
    public VEC3Tweened colorSpecular;
    public VEC3Tweened colorAmbient;
    public Vec3fkeyframed posAnim = null;
    public FloatBuffer pos = BufferUtils.createFloatBuffer(4);

    public void setPos(float x, float y, float z) {
        float[] fff = new float[]{x, y, z};
        this.pos.put(fff).rewind();
    }

    public Light() {
        this.type = 2;
        this.setOrder(10);
        this.setAmbient(0.2f, 0.2f, 0.2f);
        this.setSpecular(1.0f, 1.0f, 1.0f);
        this.setAmbient(1.0f, 1.0f, 1.0f);
        this.attenuationConstant = new Tweener(new Linear());
        this.attenuationConstant.setName("attenuationConstant");
        this.attenuationConstant.setKeyframed(false);
        this.attenuationConstant.clear(1.0f);
        this.attenuationConstant.setTimer(Project.getProject().getTimer());
        this.attenuationLinear = new Tweener(new Linear());
        this.attenuationLinear.setName("attenuationLinear");
        this.attenuationLinear.setKeyframed(false);
        this.attenuationLinear.clear(0.5f);
        this.attenuationLinear.setTimer(Project.getProject().getTimer());
        this.attenuationQuadratic = new Tweener(new Linear());
        this.attenuationQuadratic.setName("attenuationQuadratic");
        this.attenuationQuadratic.setKeyframed(false);
        this.attenuationQuadratic.clear(0.25f);
        this.attenuationQuadratic.setTimer(Project.getProject().getTimer());
    }

    public void render(float time) {
        if (this.posAnim != null) {
            this.setPos(this.posAnim.x.getValue(time), this.posAnim.y.getValue(time), this.posAnim.z.getValue(time));
        }
        GL11.glLight(16384, 4611, this.pos);
        GL11.glEnable(2896);
        GL11.glLightModel(2899, this.colorAmbientFB);
        GL11.glEnable(16384);
        GL11.glLight(16384, 4608, this.getColorAmbientFB());
        GL11.glLight(16384, 4609, this.getColorDiffuseFB());
        GL11.glLight(16384, 4610, this.getColorSpecularFB());
        GL11.glLightf(16384, 4615, 2.0f * this.attenuationConstant.getValue(Project.getProject().getTime()));
        GL11.glLightf(16384, 4616, 2.0f * this.attenuationLinear.getValue(Project.getProject().getTime()));
        GL11.glLightf(16384, 4617, 2.0f * this.attenuationQuadratic.getValue(Project.getProject().getTime()));
    }

    private FloatBuffer getColorAmbientFB() {
        this.colorAmbientFB.put(this.colorAmbient.getAsArray()).rewind();
        return this.colorAmbientFB;
    }

    private FloatBuffer getColorSpecularFB() {
        this.colorSpecularFB.put(this.colorSpecular.getAsArray()).rewind();
        return this.colorSpecularFB;
    }

    private FloatBuffer getColorDiffuseFB() {
        this.colorDiffuseFB.put(this.colorDiffuse.getAsArray()).rewind();
        return this.colorDiffuseFB;
    }

    void initDiffuse() {
        this.colorDiffuse = new VEC3Tweened(new Linear(), Project.getProject().getTimer());
        this.colorDiffuse.setKeyframed(false);
    }

    void initSpecular() {
        this.colorSpecular = new VEC3Tweened(new Linear(), Project.getProject().getTimer());
        this.colorSpecular.setKeyframed(false);
    }

    void initAmbient() {
        this.colorAmbient = new VEC3Tweened(new Linear(), Project.getProject().getTimer());
        this.colorAmbient.setKeyframed(false);
    }

    public void setAmbient(float r, float g, float b) {
        if (this.colorAmbient == null) {
            this.initAmbient();
        }
        this.colorAmbient.x.set(r);
        this.colorAmbient.y.set(g);
        this.colorAmbient.z.set(b);
        this.colorAmbientFB.put(new float[]{r, g, b, 1.0f}).rewind();
    }

    public void setSpecular(float r, float g, float b) {
        if (this.colorSpecular == null) {
            this.initSpecular();
        }
        this.colorSpecular.x.set(r);
        this.colorSpecular.y.set(g);
        this.colorSpecular.z.set(b);
        this.colorSpecularFB.put(new float[]{r, g, b, 1.0f}).rewind();
    }

    public void setDiffuse(float r, float g, float b) {
        if (this.colorDiffuse == null) {
            this.initDiffuse();
        }
        this.colorDiffuse.x.set(r);
        this.colorDiffuse.y.set(g);
        this.colorDiffuse.z.set(b);
        this.colorDiffuseFB.put(new float[]{r, g, b, 1.0f}).rewind();
    }

    public void setColorDiffuse(float[] readFloatArray) {
        if (this.colorDiffuse == null) {
            this.initDiffuse();
            this.colorDiffuse.x.set(readFloatArray[0]);
            this.colorDiffuse.y.set(readFloatArray[0]);
            this.colorDiffuse.z.set(readFloatArray[0]);
        }
        this.colorDiffuseFB.put(this.colorDiffuse.getAsArray()).rewind();
    }

    public void glVertex() {
        GL11.glVertex3f(this.pos.get(0), this.pos.get(1), this.pos.get(2));
    }

    public void saveXML(Element root) {
        Element lightEle = root.getOwnerDocument().createElement("light");
        lightEle.setAttribute("title", this.getName());
        lightEle.appendChild(TweenerXML.toXML(lightEle, this.attenuationConstant));
        lightEle.appendChild(TweenerXML.toXML(lightEle, this.attenuationLinear));
        lightEle.appendChild(TweenerXML.toXML(lightEle, this.attenuationQuadratic));
        this.colorAmbient.x.setName("colorAmbient.x");
        this.colorAmbient.y.setName("colorAmbient.y");
        this.colorAmbient.z.setName("colorAmbient.z");
        lightEle.appendChild(TweenerXML.toXML(lightEle, this.colorAmbient.x));
        lightEle.appendChild(TweenerXML.toXML(lightEle, this.colorAmbient.y));
        lightEle.appendChild(TweenerXML.toXML(lightEle, this.colorAmbient.z));
        this.colorSpecular.x.setName("colorSpecular.x");
        this.colorSpecular.y.setName("colorSpecular.y");
        this.colorSpecular.z.setName("colorSpecular.z");
        lightEle.appendChild(TweenerXML.toXML(lightEle, this.colorSpecular.x));
        lightEle.appendChild(TweenerXML.toXML(lightEle, this.colorSpecular.y));
        lightEle.appendChild(TweenerXML.toXML(lightEle, this.colorSpecular.z));
        this.colorDiffuse.x.setName("colorDiffuse.x");
        this.colorDiffuse.y.setName("colorDiffuse.y");
        this.colorDiffuse.z.setName("colorDiffuse.z");
        lightEle.appendChild(TweenerXML.toXML(lightEle, this.colorDiffuse.x));
        lightEle.appendChild(TweenerXML.toXML(lightEle, this.colorDiffuse.y));
        lightEle.appendChild(TweenerXML.toXML(lightEle, this.colorDiffuse.z));
        root.appendChild(lightEle);
    }

    public void loadXML(Element root) {
        NodeList nl = root.getElementsByTagName("tween");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            String tweenName = e.getAttribute("name");
            if (tweenName.equals("attenuationConstant")) {
                TweenerXML.fromXML(e, this.attenuationConstant);
                continue;
            }
            if (tweenName.equals("attenuationLinear")) {
                TweenerXML.fromXML(e, this.attenuationLinear);
                continue;
            }
            if (tweenName.equals("attenuationQuadratic")) {
                TweenerXML.fromXML(e, this.attenuationQuadratic);
                continue;
            }
            if (tweenName.equals("colorDiffuse.x")) {
                TweenerXML.fromXML(e, this.colorDiffuse.x);
                continue;
            }
            if (tweenName.equals("colorDiffuse.y")) {
                TweenerXML.fromXML(e, this.colorDiffuse.y);
                continue;
            }
            if (tweenName.equals("colorDiffuse.z")) {
                TweenerXML.fromXML(e, this.colorDiffuse.z);
                continue;
            }
            if (tweenName.equals("colorSpecular.x")) {
                TweenerXML.fromXML(e, this.colorSpecular.x);
                continue;
            }
            if (tweenName.equals("colorSpecular.y")) {
                TweenerXML.fromXML(e, this.colorSpecular.y);
                continue;
            }
            if (tweenName.equals("colorSpecular.z")) {
                TweenerXML.fromXML(e, this.colorSpecular.z);
                continue;
            }
            if (tweenName.equals("colorAmbient.x")) {
                TweenerXML.fromXML(e, this.colorAmbient.x);
                continue;
            }
            if (tweenName.equals("colorAmbient.y")) {
                TweenerXML.fromXML(e, this.colorAmbient.y);
                continue;
            }
            if (!tweenName.equals("colorAmbient.z")) continue;
            TweenerXML.fromXML(e, this.colorAmbient.z);
        }
    }
}

