/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d;

import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;
import sumo.v3d.Node;
import sumo.v3d.NodeIF;
import sumo.v3d.math.Quaternion;
import sumo.v3d.math.Vec3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BSpline
extends Node
implements NodeIF {
    public boolean closed = true;
    private ArrayList<Vec3f> points = new ArrayList();
    private ArrayList<Vec3f> SmoothedPoints = new ArrayList();
    boolean recalc = false;
    private int resolution = 5;
    public Vec3f scale = new Vec3f();
    public Vec3f pos = new Vec3f();
    public Quaternion rotation = new Quaternion();
    private String name = "";

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<Vec3f> getSmoothedPoints() {
        return this.SmoothedPoints;
    }

    public List<Vec3f> getPoints() {
        return this.points;
    }

    public void addPoint(Vec3f p) {
        this.points.add(p);
        this.recalc = true;
    }

    public BSpline() {
        this.type = 5;
        this.setOrder(990);
    }

    public BSpline(ArrayList<Vec3f> _points) {
        this.points = _points;
        this.recalc = true;
    }

    @Override
    public void render(float time) {
        if (this.recalc) {
            this.calc();
        }
        GL11.glPushMatrix();
        this.pos.glTranslate();
        this.rotation.getMatrix().glMulMatrix();
        GL11.glScalef(this.scale.x, this.scale.y, this.scale.z);
        GL11.glDisable(2903);
        GL11.glDisable(3042);
        GL11.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
        GL11.glBegin(3);
        for (Vec3f p : this.SmoothedPoints) {
            p.glVertex();
        }
        GL11.glEnd();
        GL11.glPointSize(10.0f);
        GL11.glBegin(0);
        for (Vec3f p : this.points) {
            p.glVertex();
        }
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    Vec3f getPoint(int i) {
        if (!this.closed) {
            if (i < 0) {
                return this.points.get(0);
            }
            if (i >= this.points.size()) {
                return this.points.get(this.points.size() - 1);
            }
            return this.points.get(i);
        }
        if (i < 0) {
            return this.points.get(this.points.size() + i);
        }
        if (i >= this.points.size()) {
            int a = i - this.points.size();
            return this.points.get(i - this.points.size());
        }
        return this.points.get(i);
    }

    public void calc() {
        int Segments = this.points.size();
        this.SmoothedPoints.removeAll(this.SmoothedPoints);
        try {
            for (int I = 0; I <= Segments - 1; ++I) {
                for (int J = 0; J <= this.resolution; ++J) {
                    float F = (float)J / (float)this.resolution;
                    Vec3f p = new Vec3f(BSpline.Hermite(this.getPoint((int)(I - 1)).x, this.getPoint((int)(I + 0)).x, this.getPoint((int)(I + 1)).x, this.getPoint((int)(I + 2)).x, F), BSpline.Hermite(this.getPoint((int)(I - 1)).y, this.getPoint((int)(I + 0)).y, this.getPoint((int)(I + 1)).y, this.getPoint((int)(I + 2)).y, F), BSpline.Hermite(this.getPoint((int)(I - 1)).z, this.getPoint((int)(I + 0)).z, this.getPoint((int)(I + 1)).z, this.getPoint((int)(I + 2)).z, F));
                    this.SmoothedPoints.add(p);
                }
            }
        }
        catch (Exception e) {
            System.out.println("calc exception:" + e);
        }
        this.recalc = false;
    }

    public static float Hermite(float A, float B, float C, float D, float F) {
        float mu2 = F * F;
        float mu3 = mu2 * F;
        float m0 = (B - A + (C - B)) / 2.0f;
        float m1 = (C - B + (D - C)) / 2.0f;
        float a0 = 2.0f * mu3 - 3.0f * mu2 + 1.0f;
        float a1 = mu3 - 2.0f * mu2 + F;
        float a2 = mu3 - mu2;
        float a3 = -2.0f * mu3 + 3.0f * mu2;
        return a0 * B + a1 * m0 + a2 * m1 + a3 * C;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
        this.recalc = true;
    }

    public void setPoints(ArrayList<Vec3f> points) {
        this.points = points;
    }

    public void setSmoothedPoints(ArrayList<Vec3f> smoothedPoints) {
        this.SmoothedPoints = smoothedPoints;
    }

    public void setPoints(float[] arr) {
        for (int i = 0; i < arr.length; i += 3) {
            this.addPoint(new Vec3f(arr[i + 0], arr[i + 1], arr[i + 2]));
        }
    }
}

