/*
 * Decompiled with CFR 0.152.
 */
package sumo.resource.types;

import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import sumo.gui.Icons;
import sumo.logger.Logger;
import sumo.project.Project;
import sumo.resource.resourceIF;
import sumo.resource.types.textureFile;
import sumo.util.stopwatch;

public class videoFile
extends textureFile
implements resourceIF {
    public int id = -1;
    public static String typedescr = "texture";
    boolean loaded = false;
    IPacket packet;
    IVideoPicture picture;
    long firstTimestampInStream = Global.NO_PTS;
    long systemClockStartTime = 0L;
    long millisecondsToSleep = 9L;
    public boolean isPlaying = false;
    public boolean finished = false;
    private long lastUpdate = 0L;
    IContainer container;
    int audioStreamId = -1;
    int videoStreamId = -1;
    IStreamCoder audioCoder = null;
    IStreamCoder videoCoder = null;
    IVideoResampler resampler = null;
    IVideoPicture newPic;
    long lastGC = 0L;
    IntBuffer buf = null;

    public int getIcon() {
        return Icons.RESOURCE_IMAGE;
    }

    public String getTypeDescr() {
        return typedescr;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isValid() {
        return this.id != -1;
    }

    public String getInfo() {
        return this.width + "x" + this.height + " glid:" + this.getID();
    }

    public void reload() {
        Project.getProject().getResourceManager().setAllLoaded(false);
        this.loaded = false;
    }

    public void load() {
        stopwatch stop = new stopwatch("loaded texture: " + this.filename + " ");
        Logger.log(this.getClass(), "loading resource texture...: " + this.path + " -- " + this.filename);
        try {
            this.systemClockStartTime = System.currentTimeMillis();
            if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
                throw new RuntimeException("you must install the GPL version of Xuggler (with IVideoResampler support) for this demo to work");
            }
            this.container = IContainer.make();
            if (this.container.open(this.path + this.filename, IContainer.Type.READ, null) < 0) {
                throw new IllegalArgumentException("could not open file: " + this.filename);
            }
            int numStreams = this.container.getNumStreams();
            System.out.println("num streams: " + numStreams);
            for (int i = 0; i < numStreams; ++i) {
                IStream stream = this.container.getStream((long)i);
                IStreamCoder coder = stream.getStreamCoder();
                if (coder.getCodecType() == ICodec.Type.CODEC_TYPE_VIDEO) {
                    System.out.println("found video stream...");
                    this.videoStreamId = i;
                    this.videoCoder = coder;
                    this.videoCoder.open();
                }
                if (coder.getCodecType() == ICodec.Type.CODEC_TYPE_UNKNOWN) {
                    System.out.println("found unknown stream...");
                }
                if (coder.getCodecType() == ICodec.Type.CODEC_TYPE_ATTACHMENT) {
                    System.out.println("found attachment stream...");
                }
                if (coder.getCodecType() == ICodec.Type.CODEC_TYPE_DATA) {
                    System.out.println("found data stream...");
                }
                if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_SUBTITLE) continue;
                System.out.println("found subtitle stream...");
            }
            if (this.videoCoder.getPixelType() != IPixelFormat.Type.BGR24) {
                this.resampler = IVideoResampler.make((int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight(), (IPixelFormat.Type)IPixelFormat.Type.RGB24, (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight(), (IPixelFormat.Type)this.videoCoder.getPixelType());
                if (this.resampler == null) {
                    throw new RuntimeException("could not create color space resampler for: " + this.filename);
                }
            }
            this.packet = IPacket.make();
            System.out.println("HALLO!!!!!!" + this.videoCoder.getWidth());
            System.out.println("pixeltype: " + this.videoCoder.getPixelType());
            this.picture = IVideoPicture.make((IPixelFormat.Type)this.videoCoder.getPixelType(), (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight());
            if (this.container == null) {
                System.out.println("container null!!");
            }
        }
        catch (Exception e) {
            Logger.log(this.getClass(), e);
        }
        this.loaded = true;
        stop.stop();
        System.out.println("-----------------------------------");
    }

    public int getID() {
        return this.id;
    }

    public void renderPreview() {
        float h;
        GL11.glClearColor(0.5f, 0.5f, 0.5f, 1.0f);
        GL11.glClear(16640);
        GL11.glLoadIdentity();
        float f1 = this.height;
        float f2 = 0.0f;
        float x = 0.0f;
        float y = 0.0f;
        float w = this.width;
        for (h = (float)this.height; w > 1.0f || h > 1.0f; w *= 0.9f, h *= 0.9f) {
        }
        w = 1.0f;
        h = 1.0f;
        GL11.glLoadIdentity();
        GL11.glDisable(2884);
        GL11.glDisable(2903);
        GL11.glDisable(2896);
        GL11.glDisable(3042);
        GL11.glDisable(2929);
        GL11.glClear(256);
        GL11.glEnable(34037);
        GL13.glActiveTexture(33984);
        this.bind();
        GL11.glBlendFunc(770, 771);
        GL11.glTranslatef(0.0f, 0.0f, -1.0f);
        GL11.glBegin(7);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glTexCoord2f(0.0f, f1);
        GL11.glVertex2f(x - w / 2.0f, -1.0f * y + h / 2.0f);
        GL11.glTexCoord2f(0.0f, f2);
        GL11.glVertex2f(x - w / 2.0f, -1.0f * y - h / 2.0f);
        GL11.glTexCoord2f(1.0f * (float)this.width, f2);
        GL11.glVertex2f(x + w / 2.0f, -1.0f * y - h / 2.0f);
        GL11.glTexCoord2f(1.0f * (float)this.width, f1);
        GL11.glVertex2f(x + w / 2.0f, -1.0f * y + h / 2.0f);
        GL11.glEnd();
        GL13.glActiveTexture(33984);
        GL11.glDisable(34037);
    }

    public void bind() {
        this.updateTexture();
        if (this.id != -1) {
            GL11.glEnable(34037);
            GL11.glBindTexture(34037, this.getID());
        }
    }

    public void updateTexture() {
        if (System.currentTimeMillis() - this.lastUpdate < 20L) {
            return;
        }
        if (this.container == null) {
            System.out.println("container null!!");
        }
        if (this.packet == null) {
            System.out.println("packet null!!");
        }
        if (this.container.readNextPacket(this.packet) >= 0 && this.packet.getStreamIndex() == this.videoStreamId) {
            int bytesDecoded;
            for (int offset = 0; offset < this.packet.getSize(); offset += bytesDecoded) {
                bytesDecoded = this.videoCoder.decodeVideo(this.picture, this.packet, offset);
                if (bytesDecoded >= 0) continue;
                System.out.println("no bytes...");
                return;
            }
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    public void setData(int w, int h, ByteBuffer data, int type) {
        this.width = w;
        this.height = h;
        if (this.id == -1) {
            this.buf = null;
            this.buf = BufferUtils.createIntBuffer(1);
            GL11.glGenTextures(this.buf);
            GL11.glBindTexture(34037, this.buf.get(0));
            GL11.glTexParameteri(34037, 10241, 9729);
            GL11.glTexParameteri(34037, 10240, 9729);
            GL11.glTexImage2D(34037, 0, type, this.width, this.height, 0, type, 5121, data);
            this.id = this.buf.get(0);
        } else {
            GL11.glBindTexture(34037, this.id);
            GL11.glTexImage2D(34037, 0, type, this.width, this.height, 0, type, 5121, data);
        }
        data = BufferUtils.createByteBuffer(1);
        data = null;
    }
}

