/*
 * Decompiled with CFR 0.152.
 */
package sumo.resource.types;

import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumo.gui.Icons;
import sumo.project.Project;
import sumo.resource.resource;
import sumo.resource.resourceIF;
import sumo.shader.ShaderPartProgram;
import sumo.shader.ShaderVariable;
import sumo.shader.SumoShader;
import sumoTween.TweenerXML;

public class sShader
extends resource
implements resourceIF {
    boolean loaded = false;
    SumoShader shader;

    public void recompile() {
        Project.getProject().getResourceManager().setAllLoaded(false);
        this.loaded = false;
    }

    public SumoShader getSumoShader() {
        return this.shader;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void reload() {
        System.out.println("yo shader reload...");
        this.shader.recompile();
        this.loaded = true;
    }

    public void save() {
    }

    public void load() {
        if (this.shader != null) {
            this.shader.recompile();
        } else {
            this.shader = new SumoShader();
            this.shader.recompile();
        }
        this.loaded = true;
    }

    public int getIcon() {
        return Icons.RESOURCE_SHADER;
    }

    public void renderPreview() {
    }

    public void saveXML(Element xmlRes) {
        xmlRes.setAttribute("class", this.getClass().getName());
        for (ShaderPartProgram prog : this.shader.getProgramms()) {
            Element tweenxml;
            Element elvar;
            Element el = xmlRes.getOwnerDocument().createElement("shaderProgramm");
            el.setAttribute("filename", prog.getFilename());
            Element eltex = xmlRes.getOwnerDocument().createElement("textures");
            eltex.setAttribute("shader", "fragment");
            ArrayList<String> textureNums = prog.getTextureNames();
            for (int i = 0; i < textureNums.size(); ++i) {
                Element eltx = xmlRes.getOwnerDocument().createElement("texture");
                eltx.setAttribute("value", String.valueOf(prog.getTextureNums()[i]));
                eltx.setAttribute("slot", String.valueOf(i));
                eltx.setAttribute("name", prog.getTextureNames().get(i));
                eltex.appendChild(eltx);
            }
            el.appendChild(eltex);
            if (prog.getFragmentPart() != null) {
                for (ShaderVariable var : prog.getFragmentPart().getUniforms()) {
                    elvar = xmlRes.getOwnerDocument().createElement("uniform");
                    elvar.setAttribute("name", var.getName());
                    elvar.setAttribute("type", var.getType());
                    elvar.setAttribute("shader", "fragment");
                    tweenxml = TweenerXML.toXML(elvar, var.getKeyframed());
                    elvar.appendChild(tweenxml);
                    el.appendChild(elvar);
                }
            }
            if (prog.getVertexPart() != null) {
                for (ShaderVariable var : prog.getVertexPart().getUniforms()) {
                    elvar = xmlRes.getOwnerDocument().createElement("uniform");
                    elvar.setAttribute("name", var.getName());
                    elvar.setAttribute("type", var.getType());
                    elvar.setAttribute("shader", "vertex");
                    tweenxml = TweenerXML.toXML(elvar, var.getKeyframed());
                    elvar.appendChild(tweenxml);
                    el.appendChild(elvar);
                }
            }
            xmlRes.appendChild(el);
        }
    }

    public void loadXML(Element ele) {
        NodeList childs = ele.getElementsByTagName("shaderProgramm");
        for (int i = 0; i < childs.getLength(); ++i) {
            Element el = (Element)childs.item(i);
            System.out.println("shaderprogram!  " + el.getAttribute("filename"));
            if (this.shader == null) {
                this.shader = new SumoShader();
            }
            this.loaded = false;
            this.shader.setNeedsRecompile();
            ShaderPartProgram pr = this.shader.addPartFilename(el.getAttribute("filename"));
            NodeList xmlTextures = el.getElementsByTagName("textures");
            Element elt = (Element)xmlTextures.item(0);
            NodeList xmlTexturess = elt.getElementsByTagName("texture");
            for (int j = 0; j < xmlTexturess.getLength(); ++j) {
                Element eltt = (Element)xmlTexturess.item(j);
                int slot = Integer.parseInt(eltt.getAttribute("slot"));
                int value = Integer.parseInt(eltt.getAttribute("value"));
                String target = eltt.getAttribute("name");
                pr.setTextureNum(slot, value);
            }
            NodeList xmlUniforms = el.getElementsByTagName("uniform");
            for (int j = 0; j < xmlUniforms.getLength(); ++j) {
                Element u = (Element)xmlUniforms.item(j);
                String name = u.getAttribute("name");
                String type = u.getAttribute("type");
                ShaderVariable var = pr.getUniform(name);
                TweenerXML.fromXML((Element)u.getElementsByTagName("tween").item(0), var.getKeyframed());
                System.out.println("loaded tween!");
            }
        }
    }

    public void setShader(SumoShader effectShader) {
        this.shader = effectShader;
    }
}

