/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.superrandomevoke;

import org.lwjgl.opengl.GL11;
import sumo.v3d.material.Material;
import sumo.v3d.math.Vec3f;
import sumo.v3d.math.Vec3fkeyframed;
import sumo.v3d.mesh.Mesh;
import sumo.v3d.mesh.MeshObject;

public class RandomParticle {
    static Material lastmaterial = null;
    private MeshObject obj;
    Vec3f pos = new Vec3f();
    float scale = 1.0f;
    Vec3f rot = new Vec3f();
    Vec3fkeyframed animpos;
    int size = 1300;
    float rotatef = 1.0f;

    RandomParticle() {
        this.pos.x = (float)Math.random() * (float)this.size - (float)(this.size / 2);
        this.pos.z = (float)Math.random() * (float)this.size - (float)(this.size / 2);
        this.scale = (float)Math.random() * 5.0f;
    }

    public MeshObject getObj() {
        return this.obj;
    }

    public void setObj(MeshObject obj) {
        this.obj = obj;
        if (Math.random() > 0.5) {
            this.animpos = new Vec3fkeyframed();
            float start = (float)(Math.random() * (double)this.size - (double)(this.size / 2));
            this.animpos.x.addKey(0.0f, Float.valueOf((float)Math.random() * (float)this.size - (float)(this.size / 2)));
            this.animpos.z.addKey(0.0f, Float.valueOf(start));
            this.animpos.z.addKey(32.0f, Float.valueOf(start + (float)(Math.random() * (double)this.size - (double)(this.size / 2))));
        }
        this.rotatef = (float)Math.random();
    }

    public void render(float time, float space) {
        GL11.glPushMatrix();
        if (this.animpos == null) {
            this.pos.glTranslate();
        } else {
            GL11.glTranslatef(this.animpos.x.getValue(time) * space, this.animpos.y.getValue(time) * space, this.animpos.z.getValue(time) * space);
        }
        GL11.glScalef(this.scale, this.scale, this.scale);
        GL11.glRotatef((time + 103040.0f) * 5.0f * this.rotatef, 0.0f, this.rotatef, 0.0f);
        GL11.glScalef(this.obj.scale.x, this.obj.scale.y, this.obj.scale.z);
        GL11.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        boolean bind = false;
        for (Mesh m : this.obj.meshes) {
            if (lastmaterial != m.materials.get(0)) {
                if (lastmaterial != null) {
                    lastmaterial.unbind();
                }
                m.materials.get(0).bind();
                lastmaterial = m.materials.get(0);
            }
            m.rendererVBO.render(time, m, false);
        }
        GL11.glPopMatrix();
    }
}

