/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.socialStream.twitter;

import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import sumo.logger.Logger;
import sumo.plugins.socialStream.SocialStreamSettings;
import sumo.plugins.socialStream.twitter.Tweet;
import sumo.util.Web;

public class TwitterAPI {
    ArrayList<Tweet> tweets = new ArrayList();
    String JSonURL = "";

    public TwitterAPI(SocialStreamSettings s) {
        this.JSonURL = "http://search.twitter.com/search.json?q=" + s.TwitterSearch;
    }

    public void update() {
        try {
            System.out.println("url: " + this.JSonURL);
            System.out.println("downloading...");
            String s = Web.getWebAsString(this.JSonURL);
            System.out.println("ok");
            JSONObject json = (JSONObject)new JSONParser().parse(s);
            System.out.println(json.toJSONString());
            JSONArray arr = (JSONArray)json.get("results");
            System.out.println(arr.get(0).toString());
            for (int i = 0; i < arr.size(); ++i) {
                JSONObject o = (JSONObject)arr.get(i);
                System.out.println(" - " + (String)o.get("text"));
                System.out.println("  - user:" + (String)o.get("from_user"));
                System.out.println("  - " + (String)o.get("profile_image_url"));
                Tweet tweet = new Tweet();
                tweet.setText((String)o.get("text"));
                tweet.setUserName((String)o.get("from_user"));
                tweet.setUserProfileImageURL((String)o.get("profile_image_url"));
                this.addTweet(tweet);
            }
            System.out.println("finished.");
        }
        catch (Exception e) {
            Logger.log(this.getClass(), e);
        }
    }

    private void addTweet(Tweet t) {
        this.tweets.add(t);
    }

    public Tweet getRandomTweet() {
        int ind = (int)((double)this.tweets.size() * Math.random());
        return this.tweets.get(ind);
    }
}

