/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.sceneparticles;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import sumo.v3d.math.Vec3f;
import sumo.v3d.math.Vec3fkeyframed;

public class Particle {
    Vec3f rot;
    public static boolean drawLines = false;
    Vec3fkeyframed animpos = new Vec3fkeyframed();
    static FloatBuffer modelView = BufferUtils.createFloatBuffer(16);
    static FloatBuffer projView = BufferUtils.createFloatBuffer(16);
    static IntBuffer viewport = BufferUtils.createIntBuffer(16);
    static Vec3f Up;
    static Vec3f Right;
    static Vec3f BPos;

    Particle(Vec3f max) {
        this.rot = new Vec3f();
        this.animpos.x.setKeyframingEnabled(false);
        this.animpos.y.setKeyframingEnabled(false);
        this.animpos.z.setKeyframingEnabled(false);
        float x = (float)Math.random() * max.x - max.x / 2.0f;
        float y = (float)Math.random() * max.y - max.y / 2.0f;
        float z = (float)Math.random() * max.z - max.z / 2.0f;
        float i = -5.0f;
        while (i < 100.0f) {
            this.animpos.x.setValue(0.0f, x += (float)Math.random() * 200.0f - 150.0f);
            this.animpos.y.setValue(0.0f, y += (float)Math.random() * 200.0f - 150.0f);
            this.animpos.z.setValue(0.0f, z += (float)Math.random() * 200.0f - 150.0f);
            i = (float)((double)i + (Math.random() * 5.0 + 4.0));
        }
        this.rot.z = (float)Math.random();
        this.rot.x = (float)Math.random();
        this.rot.y = (float)Math.random();
    }

    void drawPre(float time) {
        GL11.glPushMatrix();
        if (drawLines) {
            GL11.glBegin(3);
            float t = time;
            GL11.glVertex3f(this.animpos.x.getValue(t), this.animpos.y.getValue(t), this.animpos.z.getValue(t));
            GL11.glVertex3f(this.animpos.x.getValue(t -= 0.5f), this.animpos.y.getValue(t), this.animpos.z.getValue(t));
            GL11.glVertex3f(this.animpos.x.getValue(t -= 0.5f), this.animpos.y.getValue(t), this.animpos.z.getValue(t));
            GL11.glVertex3f(this.animpos.x.getValue(t -= 0.5f), this.animpos.y.getValue(t), this.animpos.z.getValue(t));
            GL11.glEnd();
        }
        GL11.glTranslatef(this.animpos.x.getValue(time), this.animpos.y.getValue(time), this.animpos.z.getValue(time));
        GL11.glRotatef(180.0f + time * 30.0f * this.rot.x, this.rot.x, this.rot.y, this.rot.z);
    }

    void drawpost() {
        GL11.glPopMatrix();
    }

    void draw(float time) {
        this.drawPre(time);
        GL11.glBegin(4);
        GL11.glVertex3f(1.0f, 1.0f, 0.0f);
        GL11.glVertex3f(-1.0f, 1.0f, 0.0f);
        GL11.glVertex3f(-0.0f, -0.0f, 0.0f);
        GL11.glEnd();
        this.drawpost();
    }

    void drawBillBoard(float resize, float texturesize) {
        GL11.glGetFloat(2982, modelView);
        GL11.glGetFloat(2983, projView);
        GL11.glGetInteger(2978, viewport);
        Right = new Vec3f(modelView.get(0), modelView.get(4), modelView.get(8));
        Up = new Vec3f(modelView.get(1), modelView.get(5), modelView.get(9));
        GL11.glPushMatrix();
        Particle.Right.x *= resize;
        Particle.Right.y *= resize;
        Particle.Right.z *= resize;
        Particle.Up.x *= resize;
        Particle.Up.y *= resize;
        Particle.Up.z *= resize;
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(Particle.BPos.x + Particle.Right.x + Particle.Up.x, Particle.BPos.y + Particle.Right.y + Particle.Up.y, Particle.BPos.z + Particle.Right.z + Particle.Up.z);
        GL11.glTexCoord2f(texturesize, 0.0f);
        GL11.glVertex3f(Particle.BPos.x - Particle.Right.x + Particle.Up.x, Particle.BPos.y - Particle.Right.y + Particle.Up.y, Particle.BPos.z - Particle.Right.z + Particle.Up.z);
        GL11.glTexCoord2f(texturesize, texturesize);
        GL11.glVertex3f(Particle.BPos.x - Particle.Right.x - Particle.Up.x, Particle.BPos.y - Particle.Right.y - Particle.Up.y, Particle.BPos.z - Particle.Right.z - Particle.Up.z);
        GL11.glTexCoord2f(0.0f, texturesize);
        GL11.glVertex3f(Particle.BPos.x + Particle.Right.x - Particle.Up.x, Particle.BPos.y + Particle.Right.y - Particle.Up.y, Particle.BPos.z + Particle.Right.z - Particle.Up.z);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    static {
        BPos = new Vec3f(0.0f, 0.0f, 0.0f);
    }
}

