/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.playScene;

import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyFramesChangedListener;
import sumo.keyframing.KeyframedResource;
import sumo.math.vec2f;
import sumo.opengl.FBO;
import sumo.opengl.FBOManager;
import sumo.opengl.OpenGLSettings;
import sumo.opengl.common;
import sumo.plugin.Plugin;
import sumo.plugin.PluginIF;
import sumo.project.Project;
import sumo.resource.types.sShader;
import sumo.resource.types.textureFile;
import sumoTween.KeyFloat;
import sumoTween.Tweener;
import sumoTween.events.TweenEvent;

public class PlayScene
extends Plugin
implements PluginIF {
    public Tweener speed;
    public static final int TIMING_ABSOLUTE = 0;
    public static final int TIMING_FROM0 = 1;
    public Tweener whichscene;
    public Tweener effect;
    public Tweener timing;
    public KeyframedResource shader;
    ArrayList<Tweener> shadervalues = new ArrayList();
    float projectTime = 0.0f;
    int currentscene = -1;
    int lastscene = -1;
    float starttime;
    boolean inited = false;
    OpenGLSettings gl;
    static final float res16_9 = 0.5625f;
    static final float res16_10 = 0.625f;
    static final float res4_3 = 0.75f;

    public String getName() {
        return "playscene";
    }

    public String getAuthor() {
        return "pandur";
    }

    public float getVersion() {
        return 1.0f;
    }

    public void init() {
        this.effect.setTitleValues(new String[]{"none"});
        this.timing.setTitleValues(new String[]{"absolute", "from 0"});
        this.shader.setResource(new sShader());
        this.shader.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
            }
        });
        this.whichscene.addTweenEventListener(new TweenEvent(){

            public void keysChanged() {
                int i;
                for (i = 0; i < Project.getProject().getNumScenes(); ++i) {
                    Project.getProject().getScene(i).clearTimeAreas();
                }
                for (i = 0; i < PlayScene.this.whichscene.getKeys().length - 1; ++i) {
                    KeyFloat sc = PlayScene.this.whichscene.getKeys()[i];
                    Project.getProject().getScene((int)sc.getValue()).addTimeArea(new vec2f(PlayScene.this.whichscene.getKeys()[i].getTime(), PlayScene.this.whichscene.getKeys()[i + 1].getTime()));
                }
            }

            public void finished() {
            }
        });
    }

    public void renderScene(int which) {
        if (which != Project.getProject().getCurrentSceneNum() && which >= 0 && which < Project.getProject().getNumScenes()) {
            if (this.timing.getIntValue() == 1) {
                this.projectTime = Project.getProject().getTime();
                KeyFloat f = this.whichscene.getKey(this.projectTime);
                if (f == null) {
                    return;
                }
                Project.getProject().getTimer().setTimeDiff(-f.getTime());
            }
            Project.getProject().getScene(which).render();
            if (this.timing.getIntValue() == 1) {
                Project.getProject().getTimer().setTimeDiff(0.0f);
            }
        }
    }

    public void render() {
        GL11.glClear(16640);
        FBOManager.bind(FBO.FBOs[0]);
        GL11.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        GL11.glClear(16640);
        FBOManager.glViewport();
        this.renderScene(this.whichscene.getIntValue());
        FBOManager.unbind();
        FBOManager.glViewport();
        this.renderFullscreen();
    }

    public void saveXML(Element root) {
    }

    public void loadXML(Element root) {
    }

    public void renderFullscreen() {
        GL11.glLoadIdentity();
        this.gl = Project.getProject().getOpenGLSsettings();
        common.switchTo2d();
        GL11.glLoadIdentity();
        GL11.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        GL11.glClear(16640);
        int height = (int)((float)this.gl.getWidth() * 0.5625f);
        int y1 = (this.gl.getHeight() - height) / 2;
        int y2 = this.gl.getHeight() - (this.gl.getHeight() - height) / 2;
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        FBO.FBOs[0].getTexture();
        textureFile.disable();
        FBO.FBOs[0].getTexture().bind();
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex2f(0.0f, y1);
        GL11.glTexCoord2f(0.0f, 1.0f * (float)FBO.FBOs[0].getTexture().height);
        GL11.glVertex2f(0.0f, y2);
        GL11.glTexCoord2f(1.0f * (float)FBO.FBOs[0].getTexture().width, 1.0f * (float)FBO.FBOs[0].getTexture().height);
        GL11.glVertex2f(this.gl.getWidth(), y2);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glTexCoord2f(1.0f * (float)FBO.FBOs[0].getTexture().width, 0.0f);
        GL11.glVertex2f(this.gl.getWidth(), y1);
        GL11.glEnd();
        common.switchTo3d();
    }
}

