/*
 * Decompiled with CFR 0.152.
 */
package sumo.opengl;

import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.Drawable;
import sumo.logger.Logger;
import sumo.opengl.GLWindow;

public class OpenGLSettings {
    Drawable sharedContext = null;
    private int bpp = 24;
    private int alpha = 8;
    private int depth = 16;
    private int stencil = 8;
    private int multisampling = 0;
    private int width = 640;
    private int height = 360;
    private boolean fullScreen = true;
    private int currentFPS = 0;
    private float fakeMS = 1.0f;
    private boolean vsynch = true;
    private int hz = 60;

    public OpenGLSettings() {
    }

    public OpenGLSettings(int width, int height, boolean fullscreen) {
        this.width = width;
        this.height = height;
        this.fullScreen = fullscreen;
    }

    public float getFakeMS() {
        return this.fakeMS;
    }

    public void setFakeMS(float fakeMS) {
        this.fakeMS = fakeMS;
    }

    public int getBpp() {
        return this.bpp;
    }

    public void setBpp(int bpp) {
        this.bpp = bpp;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getDepth() {
        Logger.log(this.getClass(), "depth " + this.depth);
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getStencil() {
        return this.stencil;
    }

    public void setStencil(int stencil) {
        this.stencil = stencil;
    }

    public int getMultisampling() {
        return this.multisampling;
    }

    public void setMultisampling(int multisampling) {
        this.multisampling = multisampling;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isFullScreen() {
        return this.fullScreen;
    }

    public void setFullScreen(boolean fullScreen) {
        if (fullScreen) {
            Mouse.setGrabbed(true);
        } else {
            Mouse.setGrabbed(false);
        }
        this.fullScreen = fullScreen;
    }

    public int getCurrentFPS() {
        return this.currentFPS;
    }

    public void setCurrentFPS(int fps) {
        this.currentFPS = fps;
    }

    public float getFBHeight() {
        return 720.0f * this.fakeMS;
    }

    public float getFBWidth() {
        return 1280.0f * this.fakeMS;
    }

    public boolean getVsynch() {
        return this.vsynch;
    }

    public int getFrequency() {
        return this.hz;
    }

    public void setVsynch(boolean b) {
        this.vsynch = b;
    }

    public void setFrequency(int frequency) {
        this.hz = frequency;
    }

    public DisplayMode findMode() {
        return GLWindow.findDisplayMode(this.width, this.height, this.bpp, this.hz);
    }

    public void print() {
        System.out.println("width:" + this.width);
        System.out.println("height:" + this.height);
        System.out.println("bpp:" + this.bpp);
        System.out.println("hz:" + this.hz);
        System.out.println("stencil:" + this.stencil);
        System.out.println("multisampling:" + this.multisampling);
        System.out.println("depth:" + this.depth);
        System.out.println("alpha:" + this.alpha);
        System.out.println("fakeMS:" + this.fakeMS);
    }
}

