/*
 * Decompiled with CFR 0.152.
 */
package sumo.keyframing;

import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumo.keyframing.KeyBoolean;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyFramesChangedListener;
import sumo.keyframing.KeyIF;
import sumo.keyframing.KeyInt;
import sumo.keyframing.KeyframedBoolean;
import sumo.keyframing.KeyframedInt;
import sumo.keyframing.KeyframedResource;
import sumo.project.Project;
import sumo.resource.resourceIF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KeyFramedBase
implements KeyFramedIF {
    private boolean enabled = true;
    boolean isKeyframed = false;
    public static int INTERPOLATION_LINEAR = 0;
    public static int INTERPOLATION_ABSOLUTE = 1;
    private Object data = null;
    boolean visible = true;
    private ArrayList<KeyFramesChangedListener> changeListener = new ArrayList();

    @Override
    public void setVisible(boolean v) {
        this.visible = v;
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    @Override
    public boolean getKeyframingEnabled() {
        return this.isKeyframed;
    }

    public ArrayList<String> getKeysListAsText() {
        ArrayList<String> keystrings = new ArrayList<String>();
        for (KeyIF k : this.getKeys()) {
            keystrings.add(String.valueOf(k.getTime()));
        }
        return keystrings;
    }

    public void removeKeyChangedListener(KeyFramesChangedListener cl) {
        this.changeListener.remove(cl);
    }

    @Override
    public void addKeysChangedListener(KeyFramesChangedListener cl) {
        if (this.changeListener.contains(cl)) {
            return;
        }
        this.changeListener.add(cl);
    }

    protected void notifyKeysChanged(KeyFramedIF k) {
        for (int x = 0; x < this.changeListener.size(); ++x) {
            KeyFramesChangedListener l = this.changeListener.get(x);
            l.keysChanged(k);
        }
    }

    @Override
    public KeyIF[] getKeys() {
        System.out.println("getkeys() not implemented!!!! ");
        return null;
    }

    @Override
    public String getName() {
        System.out.println("getname() not implemented!!!! ");
        return null;
    }

    @Override
    public String getClassSimpleName() {
        return null;
    }

    @Override
    public short getDefaultInterpolationMode() {
        return 0;
    }

    @Override
    public void save(Element root) {
        Element xmlPlug = root.getOwnerDocument().createElement("keyframed");
        xmlPlug.setAttribute("isKeyframed", String.valueOf(this.getKeyframingEnabled()));
        xmlPlug.setAttribute("defaultInterpolation", String.valueOf(this.getDefaultInterpolationMode()));
        xmlPlug.setAttribute("name", String.valueOf(this.getName()));
        KeyIF[] keyframes = this.getKeys();
        if (keyframes != null) {
            for (int i = 0; i < keyframes.length; ++i) {
                keyframes[i].save(xmlPlug);
            }
        }
        root.appendChild(xmlPlug);
    }

    @Override
    public void setEnabled(boolean e) {
        this.enabled = e;
        this.notifyKeysChanged(this);
    }

    @Override
    public void setKeyframingEnabled(boolean k) {
        this.isKeyframed = k;
        this.notifyKeysChanged(this);
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setData(Object o) {
        this.data = o;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public static void parseXML(KeyFramedIF kf, Element ek) {
        if (kf == null) {
            return;
        }
        boolean b = Boolean.parseBoolean(ek.getAttribute("isKeyframed"));
        kf.setKeyframingEnabled(b);
        kf.clear();
        NodeList rs = ek.getElementsByTagName("resource");
        if (rs.item(0) != null) {
            Element er = (Element)rs.item(0);
            resourceIF r = Project.getProject().getResourceManager().getResourceByFileName(er.getAttribute("filename"));
            if (r == null) {
                r = Project.getProject().getResourceManager().add(er.getAttribute("path"), er.getAttribute("filename"));
            }
            ((KeyframedResource)kf).setResource(r);
        }
        NodeList keys = ek.getElementsByTagName("k");
        for (int ik = 0; ik < keys.getLength(); ++ik) {
            Element ekey = (Element)keys.item(ik);
            float time = Float.parseFloat(ekey.getAttribute("t"));
            String v = ekey.getAttribute("v");
            short mi = Short.parseShort(ekey.getAttribute("mi"));
            short mo = Short.parseShort(ekey.getAttribute("mo"));
            if (kf.getClass().equals(KeyframedInt.class)) {
                ((KeyframedInt)kf).insertKey(new KeyInt(time, Integer.parseInt(v), mi, mo, kf));
                continue;
            }
            if (kf.getClass().equals(KeyframedBoolean.class)) {
                ((KeyframedBoolean)kf).insertKey(new KeyBoolean(time, Boolean.parseBoolean(v), kf));
                continue;
            }
            System.out.println("unknown keyframedtype while loading");
        }
    }
}

