/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.sumoComponents;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import sumo.gui.Settings;

public class SumoScroll
extends JComponent {
    int scrollerY = 0;
    int mousey = 0;
    boolean dragging = false;
    boolean mouseOver = false;
    private int scrollHeight = 10;

    public SumoScroll() {
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent e) {
                if (!SumoScroll.this.dragging) {
                    SumoScroll.this.mousey = e.getY();
                }
            }

            public void mouseDragged(MouseEvent e) {
                SumoScroll.this.dragging = true;
                SumoScroll.this.scrollerY = e.getY() - SumoScroll.this.mousey;
                SumoScroll.this.repaint();
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent arg0) {
                SumoScroll.this.dragging = false;
            }

            public void mousePressed(MouseEvent arg0) {
                SumoScroll.this.dragging = true;
            }

            public void mouseClicked(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
                SumoScroll.this.mouseOver = false;
                SumoScroll.this.repaint();
            }

            public void mouseEntered(MouseEvent arg0) {
                SumoScroll.this.mouseOver = true;
                SumoScroll.this.repaint();
            }
        });
    }

    public void paint(Graphics g) {
        g.setColor(Settings.SUMO2_BRIGHTER);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.red);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        if (this.mouseOver) {
            g.setColor(Settings.SUMO2_DARKER);
        } else {
            g.setColor(Settings.SUMO2_DARK);
        }
        g.fillRect(0, this.scrollerY, this.getWidth() - 1, this.scrollHeight);
    }

    public void setHeight(float scrollHeightPercent) {
        this.scrollHeight = (int)(scrollHeightPercent * (float)this.getHeight());
    }
}

