/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.lineTypeElements;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import sumo.gui.AbstractLine;
import sumo.gui.Icons;
import sumo.gui.ScenePanel;
import sumo.gui.Settings;
import sumo.gui.debug.guiDebugData;
import sumo.gui.debug.guiStopWatch;
import sumo.gui.lineTypeElements.guiLineTypeIF;
import sumo.gui.timing.KeyFramePanel;
import sumo.gui.timing.KeyFramePanelIF;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyFramesChangedListener;
import sumo.keyframing.KeyframedResource;
import sumo.logger.Logger;
import sumo.project.Project;
import sumo.resource.resourceIF;
import sumoTween.Tweener;

public class guiResource
extends JPanel
implements guiLineTypeIF,
DropTargetListener {
    private boolean dndOver = false;
    private Color bgColor = Settings.SUMO2_BG;
    KeyframedResource theResource;
    private boolean mouseOver = false;
    DropTarget dt = new DropTarget(this, this);
    guiStopWatch watch = null;
    KeyFramePanel sp = null;
    AbstractLine abstractLine = null;

    public guiResource(KeyframedResource keyframedResource) {
        this.theResource = keyframedResource;
        this.theResource.guiResource = this;
        this.setBounds(new Rectangle(100, 16));
        this.theResource.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                guiResource.this.repaint();
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                guiResource.this.mouseOver = true;
                guiResource.this.setCursor(Cursor.getPredefinedCursor(12));
                guiResource.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                guiResource.this.mouseOver = false;
                guiResource.this.setCursor(Cursor.getPredefinedCursor(0));
                guiResource.this.repaint();
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    public Component getComponent() {
        return this;
    }

    public void setBgColor(Color c) {
        this.bgColor = c;
    }

    public void paint(Graphics g) {
        if (guiDebugData.debug) {
            this.watch = new guiStopWatch(guiDebugData.STOP_GUIRESOURCE);
        }
        Graphics2D gd = (Graphics2D)g;
        gd.setFont(Settings.smallfont);
        if (this.dndOver) {
            gd.setColor(Settings.mainColor1);
            gd.fillRect(0, 0, this.getWidth(), this.getHeight());
            gd.setColor(Settings.SUMO2_BG);
        } else {
            gd.setColor(this.bgColor);
            gd.fillRect(0, 0, this.getWidth(), this.getHeight() - 1);
            gd.setColor(Settings.SUMO2_TEXT_DARK);
        }
        if (this.theResource != null) {
            if (this.theResource.getResource() == null) {
                gd.drawString("-", 20, 12);
            } else {
                Icons.drawIcon(gd, this.theResource.getResource().getIcon(), 1, 1);
                gd.drawString(this.theResource.getResource().getFilename(), 20, 12);
            }
        } else {
            gd.drawString("none", 2, 12);
        }
        gd.setColor(Color.WHITE);
        gd.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        if (guiDebugData.debug) {
            this.watch.stop();
        }
    }

    public boolean isKeyframeAble() {
        return false;
    }

    public boolean isKeyFramed() {
        return false;
    }

    public void setIsKeyFramed(boolean b) {
    }

    public void setKeyframePanel(KeyFramePanelIF kf) {
    }

    public void setMarked(boolean b) {
        this.repaint();
    }

    public Tweener getKeyframed() {
        return null;
    }

    public KeyFramePanelIF getKeyFramePanel(ScenePanel p) {
        if (this.sp == null) {
            this.sp = new KeyFramePanel(p);
        }
        return this.sp;
    }

    public void setAbstractLine(AbstractLine al) {
        this.abstractLine = al;
    }

    public void setEnableDisableSwitch(boolean parseBoolean) {
    }

    public boolean getEnableDisableSwitch() {
        return false;
    }

    public void dragEnter(DropTargetDragEvent arg0) {
        this.dndOver = true;
        this.repaint();
    }

    public void dragExit(DropTargetEvent arg0) {
        this.dndOver = false;
        this.repaint();
    }

    public void dragOver(DropTargetDragEvent arg0) {
    }

    public void dropActionChanged(DropTargetDragEvent arg0) {
    }

    public void drop(DropTargetDropEvent ev) {
        try {
            this.dndOver = false;
            this.repaint();
            Transferable tr = ev.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String data = (String)tr.getTransferData(DataFlavor.stringFlavor);
                Project.getProject();
                Project.setStatus("drag and drop: " + data);
                if (data.startsWith("resource:")) {
                    resourceIF r = Project.getProject().getResourceManager().getResourceByFileName(data.split(":")[1]);
                    if (this.theResource.getResource().getTypeDescr().equals(r.getTypeDescr())) {
                        this.theResource.setResource(r);
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.log(this.getClass(), e);
        }
    }
}

