/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.detail.resources;

import sumo.gui.Icons;
import sumo.gui.detail.DetailButtonPressedListener;
import sumo.gui.detail.DetailEmpty;
import sumo.gui.detail.DetailIF;
import sumo.gui.detail.Elements.Area;
import sumo.gui.detail.Elements.DetailButton;
import sumo.gui.detail.Elements.DetailLabel;
import sumo.project.Project;
import sumo.resource.types.v3d;
import sumo.v3d.simpleview.v3dsimpleview;

public class V3DDetail
extends DetailEmpty
implements DetailIF {
    v3d v3dresource;
    DetailButton reload;
    DetailButton detail;

    public void dispose() {
    }

    public V3DDetail(v3d tx) {
        this.v3dresource = tx;
        this.setTitle(this, "v3d: " + tx.getTitle());
        this.setSize(300, 300);
        this.setLayout(null);
        Area areaInfos = new Area("infos", this, Area.LAYOUT_ONE);
        DetailLabel l = new DetailLabel("filename: " + tx.getFilename());
        areaInfos.addLine(l);
        DetailLabel l1 = new DetailLabel("path: " + tx.getPath());
        areaInfos.addLine(l1);
        DetailLabel l2 = new DetailLabel("animlength: " + tx.getScene().animLength + "s");
        areaInfos.addLine(l2);
        DetailLabel l3 = new DetailLabel("nodes: " + tx.getScene().getNumNodes() + " nodes");
        areaInfos.addLine(l3);
        DetailLabel l4 = new DetailLabel("" + tx.getScene().materials.size() + " materials");
        areaInfos.addLine(l4);
        DetailLabel l5 = new DetailLabel(tx.getScene().getNumCameras() + " cameras");
        areaInfos.addLine(l5);
        DetailLabel l6 = new DetailLabel(tx.getScene().getNumLights() + " lights");
        areaInfos.addLine(l6);
        DetailLabel l7 = new DetailLabel(tx.getScene().getNumMeshes() + " meshobjects");
        areaInfos.addLine(l7);
        DetailLabel l8 = new DetailLabel(tx.getScene().getNumShapes() + " shapes");
        areaInfos.addLine(l8);
        this.addArea(areaInfos);
        this.addResourceFunctions();
    }

    public void addResourceFunctions() {
        Area areaInfos = new Area("resource functions", this, Area.LAYOUT_ONE);
        DetailButton reload = new DetailButton(Icons.ICON_REFRESH, "reload");
        DetailButton remove = new DetailButton(Icons.ICON_TRASH, "remove");
        DetailButton view = new DetailButton(Icons.ICON_TRASH, "view data");
        areaInfos.addLine(reload);
        areaInfos.addLine(remove);
        areaInfos.addLine(view);
        reload.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                V3DDetail.this.v3dresource.reload();
            }
        });
        remove.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                Project.getProject().getResourceManager().removeResourceWhenNotUsed(V3DDetail.this.v3dresource.getFilename());
            }
        });
        view.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                v3dsimpleview simpleview = new v3dsimpleview(false);
                simpleview.setFilename(V3DDetail.this.v3dresource.getPath() + "" + V3DDetail.this.v3dresource.getFilename());
                simpleview.readV3D();
            }
        });
        this.addArea(areaInfos);
    }
}

