/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.detail.SelectLists;

import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import sumo.gui.Settings;
import sumo.gui.detail.DefaultResourceDetail;
import sumo.gui.detail.DetailEmpty;
import sumo.gui.detail.DetailIF;
import sumo.gui.detail.ShaderDetail;
import sumo.gui.detail.resources.TextureDetail;
import sumo.gui.detail.resources.V3DDetail;
import sumo.gui.dialogs.exceptionDialog;
import sumo.gui.dialogs.selector.SelectorItem;
import sumo.gui.sumoComponents.list.ListLine;
import sumo.gui.sumoComponents.list.ListLineSelectListener;
import sumo.gui.sumoComponents.list.SumoList;
import sumo.project.Project;
import sumo.resource.ResourcesChangedEvent;
import sumo.resource.resourceIF;
import sumo.resource.types.sShader;
import sumo.resource.types.textureFile;
import sumo.resource.types.v3d;

public class ResourceSelect
extends DetailEmpty
implements DetailIF,
DropTargetListener {
    DropTarget dt = new DropTarget(this, this);
    SumoList mylist;
    JScrollPane scrollList;

    public void dispose() {
    }

    public ResourceSelect() {
        this.setSize(300, 300);
        this.setLayout(null);
        this.setBackground(Settings.SUMO2_BG);
        this.mylist = new SumoList();
        this.mylist.setBounds(0, 0, 100, this.getHeight());
        System.out.println("h" + this.getHeight());
        this.mylist.setPreferredSize(new Dimension(500, 500));
        this.rebuild();
        this.scrollList = new JScrollPane();
        this.scrollList = new JScrollPane(this.mylist);
        this.scrollList.getViewport().setBackground(Settings.SUMO2_BG);
        this.scrollList.setBorder(BorderFactory.createLineBorder(Settings.lineBackground, 0));
        this.scrollList.setBounds(10, 10, this.getWidth() - 20, this.getHeight() - 20);
        this.scrollList.getHorizontalScrollBar().setVisible(false);
        this.add(this.scrollList);
        Project.getProject().getResourceManager().addResourcesChangedListener(new ResourcesChangedEvent(){

            public void resourcesChanged() {
                ResourceSelect.this.scrollList.setBounds(10, 10, 280, ResourceSelect.this.getHeight() - 20);
                ResourceSelect.this.rebuild();
            }
        });
    }

    public void rebuild() {
        this.mylist.getRoot().removeChilds();
        ArrayList<SelectorItem> items = Project.getProject().getResourceManager().getAsGuiITems(null);
        String lastTypeDesc = "";
        for (SelectorItem item : items) {
            ListLine l = this.mylist.createLine(item.getTitle());
            l.setDNDString("resource:" + item.getTitle());
            l.setSelectable(true);
            l.setIcon(item.getIcon());
            this.mylist.getRoot().addChild(l);
            this.mylist.repaint();
            this.mylist.updateUI();
            l.addSelectListener(new ListLineSelectListener(){

                public void selected(ListLine item) {
                    if (item.getDNDString().startsWith("resource:")) {
                        String rf = item.getDNDString().split(":")[1];
                        resourceIF si = Project.getProject().getResourceManager().getResourceByFileName(rf);
                        if (si == null) {
                            return;
                        }
                        if (si instanceof sShader) {
                            sShader s = (sShader)si;
                            Project.getProject().setDetailPanel(new ShaderDetail(s));
                        } else if (si instanceof textureFile) {
                            textureFile s = (textureFile)si;
                            Project.getProject().setDetailPanel(new TextureDetail(s));
                        } else if (si instanceof v3d) {
                            v3d s = (v3d)si;
                            Project.getProject().setDetailPanel(new V3DDetail(s));
                        } else {
                            Project.getProject().setDetailPanel(new DefaultResourceDetail(si));
                        }
                    }
                }
            });
        }
        int height = this.mylist.reOrder();
        this.mylist.setBounds(0, 0, this.getWidth() - 20, height);
        this.mylist.setPreferredSize(new Dimension(this.getWidth() - 20, height));
    }

    public void dragEnter(DropTargetDragEvent arg0) {
    }

    public void dragExit(DropTargetEvent arg0) {
    }

    public void dragOver(DropTargetDragEvent arg0) {
    }

    public void dropActionChanged(DropTargetDragEvent arg0) {
    }

    public void drop(DropTargetDropEvent ev) {
        try {
            Transferable tr = ev.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                Project.getProject().getResourceManager().importDragAndDrop(ev, tr);
            }
        }
        catch (Exception e) {
            new exceptionDialog(e);
        }
        System.out.println("drop!!!");
    }
}

