/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.detail;

import java.awt.datatransfer.Clipboard;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sumo.app.guitest;
import sumo.gui.Icons;
import sumo.gui.ScenePanel;
import sumo.gui.detail.DetailButtonPressedListener;
import sumo.gui.detail.DetailEmpty;
import sumo.gui.detail.DetailIF;
import sumo.gui.detail.Elements.Area;
import sumo.gui.detail.Elements.DetailButton;
import sumo.project.Project;
import sumoTween.KeyFloat;
import sumoTween.TweenerXML;
import sumoTween.easing.Cubic;
import sumoTween.easing.EasingIF;
import sumoTween.easing.Linear;
import sumoTween.easing.None;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyDetail
extends DetailEmpty
implements DetailIF {
    ArrayList<KeyFloat> keys;
    ScenePanel sp;
    DetailButton easing;
    DetailButton direction;
    DetailButton directionInOut;
    DetailButton easingLinear;
    DetailButton easingCubic;
    DetailButton easingNone;
    JList list;
    JLabel l;

    @Override
    public void dispose() {
    }

    String getKeyInfo() {
        return this.keys.size() + " keys";
    }

    public KeyDetail(ArrayList<KeyFloat> _keys, ScenePanel s) {
        this.sp = s;
        this.keys = _keys;
        this.setTitle(this, this.getKeyInfo());
        this.setSize(270, 300);
        this.setLayout(null);
        Area areaMoveKeys = new Area("move keys", this, Area.LAYOUT_TWO);
        DetailButton move_back = new DetailButton(Icons.ICON_TIME_REWIND, "0.1 seconds");
        DetailButton move_for = new DetailButton(Icons.ICON_TIME_FORWARD, "0.1 seconds");
        DetailButton move_backf = new DetailButton(Icons.ICON_TIME_REWIND, "1 frame");
        DetailButton move_forf = new DetailButton(Icons.ICON_TIME_FORWARD, "1 frame");
        DetailButton move2time = new DetailButton(Icons.ICON_TIME_PLAY, "move to time");
        areaMoveKeys.addLine(move_back);
        areaMoveKeys.addLine(move_for);
        areaMoveKeys.addLine(move_backf);
        areaMoveKeys.addLine(move_forf);
        areaMoveKeys.addLine(move2time);
        this.addArea(areaMoveKeys);
        Area areaInterpolation = new Area("interpolation", this, Area.LAYOUT_TWO);
        this.easing = new DetailButton(Icons.ICON_BOX, "easing: ");
        this.direction = new DetailButton(Icons.ICON_BOX, "direction:");
        this.easingLinear = new DetailButton(Icons.ICON_BOX, "all: linear easing");
        this.easingNone = new DetailButton(Icons.ICON_BOX, "all: NO easing");
        this.easingCubic = new DetailButton(Icons.ICON_BOX, "all: cubic easing");
        this.directionInOut = new DetailButton(Icons.ICON_BOX, "all: in&out");
        areaInterpolation.addLine(this.easing);
        areaInterpolation.addLine(this.direction);
        areaInterpolation.addLine(this.easingLinear);
        areaInterpolation.addLine(this.easingNone);
        areaInterpolation.addLine(this.easingCubic);
        areaInterpolation.addLine(this.directionInOut);
        this.addArea(areaInterpolation);
        Area areaMiscc = new Area("misc", this, Area.LAYOUT_TWO);
        DetailButton del = new DetailButton(Icons.ICON_BOX_X, "delete key");
        DetailButton settime = new DetailButton(Icons.ICON_BOX, "goto key");
        DetailButton copy2time = new DetailButton(Icons.ICON_BOX, "copy to time");
        areaMiscc.addLine(del);
        areaMiscc.addLine(settime);
        areaMiscc.addLine(copy2time);
        this.addArea(areaMiscc);
        this.addKeyList();
        this.direction.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                String title = "";
                int newdir = 0;
                if (KeyDetail.this.keys.get(0).getEasingDirection() == 0) {
                    newdir = 1;
                    title = "OUT";
                } else if (KeyDetail.this.keys.get(0).getEasingDirection() == 1) {
                    newdir = 2;
                    title = "IN & OUT";
                } else if (KeyDetail.this.keys.get(0).getEasingDirection() == 2) {
                    newdir = 3;
                    title = "NONE";
                } else if (KeyDetail.this.keys.get(0).getEasingDirection() == 3) {
                    newdir = 0;
                    title = "IN";
                }
                for (KeyFloat key : KeyDetail.this.keys) {
                    key.setEasingDirection(newdir);
                }
                KeyDetail.this.sp.repaintTimings();
                KeyDetail.this.direction.setTitle("direction: " + title);
            }
        });
        this.directionInOut.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                for (KeyFloat key : KeyDetail.this.keys) {
                    key.setEasingDirection(2);
                }
                KeyDetail.this.sp.repaintTimings();
            }
        });
        this.easingLinear.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                Linear l = new Linear();
                for (KeyFloat key : KeyDetail.this.keys) {
                    key.setEasing(l);
                }
                KeyDetail.this.sp.repaintTimings();
            }
        });
        this.easingNone.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                None l = new None();
                for (KeyFloat key : KeyDetail.this.keys) {
                    key.setEasing(l);
                }
                KeyDetail.this.sp.repaintTimings();
            }
        });
        this.easingCubic.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                Cubic l = new Cubic();
                for (KeyFloat key : KeyDetail.this.keys) {
                    key.setEasing(l);
                }
                KeyDetail.this.sp.repaintTimings();
            }
        });
        this.easing.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                Object neweasing = null;
                for (int i = 0; i < TweenerXML.easings.length; ++i) {
                    if (!KeyDetail.this.keys.get(0).getEasing().getClass().equals(TweenerXML.easings[i].getClass())) continue;
                    neweasing = i == TweenerXML.easings.length - 1 ? TweenerXML.easings[0] : TweenerXML.easings[i + 1];
                }
                for (KeyFloat key : KeyDetail.this.keys) {
                    key.setEasing((EasingIF)neweasing);
                }
                KeyDetail.this.sp.repaintTimings();
                KeyDetail.this.easing.setTitle("easing: " + neweasing.getClass().getSimpleName());
            }
        });
        this.setBounds(10, 10, 300, 500);
        settime.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                KeyDetail.this.moveToTime();
            }
        });
        copy2time.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                if (KeyDetail.this.keys.size() > 0) {
                    ArrayList<KeyFloat> newkeys = new ArrayList<KeyFloat>();
                    float timediff = KeyDetail.this.keys.get(0).getTime();
                    for (KeyFloat k : KeyDetail.this.keys) {
                        newkeys.add(k.getCopy());
                    }
                    for (KeyFloat k : newkeys) {
                        k.setTime(Project.getProject().getTime() + k.getTime() - timediff);
                        k.getParent().add(k);
                        k.getParent().sort();
                    }
                }
                Clipboard clipboard = KeyDetail.this.getToolkit().getSystemClipboard();
                KeyDetail.this.sp.repaintTimings();
                KeyDetail.this.title.setTitle(KeyDetail.this.getKeyInfo());
            }
        });
        move2time.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                for (KeyFloat key : KeyDetail.this.keys) {
                    key.setTime(Project.getProject().getTime());
                    key.getParent().sort();
                }
                KeyDetail.this.sp.repaintTimings();
                KeyDetail.this.title.setTitle(KeyDetail.this.getKeyInfo());
            }
        });
        move_for.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                for (KeyFloat key : KeyDetail.this.keys) {
                    key.setTime(key.getTime() + 0.1f);
                }
                KeyDetail.this.sp.repaintTimings();
                KeyDetail.this.title.setTitle(KeyDetail.this.getKeyInfo());
            }
        });
        move_back.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                for (KeyFloat key : KeyDetail.this.keys) {
                    key.setTime(key.getTime() - 0.1f);
                }
                KeyDetail.this.sp.repaintTimings();
                KeyDetail.this.title.setTitle(KeyDetail.this.getKeyInfo());
            }
        });
        move_forf.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                for (KeyFloat key : KeyDetail.this.keys) {
                    key.setTime(key.getTime() + 0.03f);
                }
                KeyDetail.this.sp.repaintTimings();
                KeyDetail.this.title.setTitle(KeyDetail.this.getKeyInfo());
            }
        });
        move_backf.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                for (KeyFloat key : KeyDetail.this.keys) {
                    key.setTime(key.getTime() - 0.03f);
                }
                KeyDetail.this.sp.repaintTimings();
                KeyDetail.this.title.setTitle(KeyDetail.this.getKeyInfo());
            }
        });
        del.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                System.out.println("delete keys...");
                for (KeyFloat key : KeyDetail.this.keys) {
                    key.getParent().deleteKeyAt(key.getTime());
                }
                KeyDetail.this.sp.repaintTimings();
            }
        });
    }

    private void addKeyList() {
        Area area = new Area("keylist", this, Area.LAYOUT_FREE);
        area.setLayout(null);
        area.setAreaHeight(250);
        ArrayList<String> keyStrings = new ArrayList<String>();
        for (KeyFloat key : this.keys) {
            keyStrings.add(key.getTime() + ": " + key);
        }
        this.list = new JList<Object>(keyStrings.toArray());
        this.list.setVisibleRowCount(10);
        JScrollPane js = new JScrollPane(this.list);
        js.setBounds(15, 25, 130, 200);
        this.l = new JLabel("...");
        this.l.setBounds(160, 25, 120, 30);
        area.add(this.l);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (KeyDetail.this.list.getSelectedIndex() >= 0 && KeyDetail.this.list.getSelectedIndex() < KeyDetail.this.keys.size()) {
                    Project.getProject().setTime(Float.valueOf(KeyDetail.this.keys.get(KeyDetail.this.list.getSelectedIndex()).getTime()));
                    guitest.scenePanel.repaintTimings();
                    KeyDetail.this.l.setText("value:" + KeyDetail.this.keys.get(KeyDetail.this.list.getSelectedIndex()));
                }
            }
        });
        area.add(js);
        DetailButton deleteKey = new DetailButton(-1, "delete");
        deleteKey.setBounds(160, 60, 70, 17);
        area.add(deleteKey);
        deleteKey.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
            }
        });
        this.addArea(area);
    }

    public void moveToTime() {
        if (this.keys.size() > 0) {
            Project.getProject().getTimer().setTime(this.keys.get(0).getTime());
        }
        ((ScenePanel)Project.getProject().getCurrentScene()).repaintTimings();
        ((ScenePanel)Project.getProject().getCurrentScene()).repaintValueControllers();
    }

    public void moveKeysFrames(int i) {
        if (this.keys.size() > 0) {
            for (KeyFloat key : this.keys) {
                key.setTime(key.getTime() + (float)i * Project.getProject().getFrameLength());
            }
        }
        ((ScenePanel)Project.getProject().getCurrentScene()).repaintTimings();
        ((ScenePanel)Project.getProject().getCurrentScene()).repaintValueControllers();
    }
}

