/*
 * Decompiled with CFR 0.152.
 */
package sumo.app;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.GLU;
import org.lwjgl.opengl.glu.Sphere;
import sumo.gui.dialogs.exceptionDialog;
import sumo.opengl.GLWindow;
import sumo.opengl.OpenGLSettings;
import sumo.project.Project;
import sumo.resource.types.Texture;
import sumo.util.FPSCounter;
import sumo.v3d.Shader;
import sumo.v3d.ShaderProgram;
import sumoTween.timer.TimerIF;

public class shadowtest {
    public static TimerIF timer;
    static float[] lightpos;
    static float[] lightView;
    static float g_Direction;
    static float camPosx;
    static float camPosy;
    static float camPosz;
    static float camViewx;
    static float camViewy;
    static float camViewz;
    static float camUpx;
    static float camUpy;
    static float camUpz;
    static FloatBuffer matrixModelView;
    static FloatBuffer matrixProjection;
    static FloatBuffer matrixCameraInverse;
    static ShaderProgram shadowShader;
    static Texture shadowTexture;
    static Shader sv;
    static Shader sf;
    static float rotY;
    static int SHADOW_WIDTH;
    static int SHADOW_HEIGHT;

    public static void main(String[] args) {
        Project p = new Project();
        Project.guimode = false;
        p.init();
        Project.setProject(p);
        OpenGLSettings settings = new OpenGLSettings(1280, 720, false);
        settings.setMultisampling(4);
        p.setOpenGLSsettings(settings);
        GLWindow win = new GLWindow(settings.findMode(), settings);
        win.open();
        boolean isPlaying = false;
        FPSCounter fpsCounter = new FPSCounter();
        try {
            shadowtest.initShadow();
            while (!Keyboard.isKeyDown(1)) {
                GL11.glClear(16640);
                shadowtest.renderScene();
                fpsCounter.nextFrame();
                Display.update();
                Display.setTitle("fps:" + fpsCounter.fps);
                try {
                    Thread.sleep(5L);
                }
                catch (Exception e) {}
            }
            win.close();
        }
        catch (Exception e) {
            new exceptionDialog(e);
        }
        System.exit(0);
    }

    public static void initShadow() {
        sf = new Shader("c:/demogame/", "shadow.fs", 1);
        sv = new Shader("c:/demogame/", "shadow.vs", 2);
        shadowShader.changeShader(sf);
        shadowShader.changeShader(sv);
        shadowTexture = new Texture("", SHADOW_WIDTH, SHADOW_HEIGHT, true, false);
        FloatBuffer fb = BufferUtils.createFloatBuffer(4);
        fb.put(lightpos).rewind();
        GL11.glLight(16384, 4611, fb);
        GL11.glClearColor(0.2f, 0.2f, 0.2f, 1.0f);
        GL11.glEnable(2896);
        GL11.glEnable(16384);
        GL11.glEnable(2903);
    }

    public static void RenderWorld() {
        GL11.glPushMatrix();
        GL11.glTranslatef(0.0f, 0.0f, -15.0f);
        shadowtest.DrawWalls();
        GL11.glPopMatrix();
        GL11.glColor4f(0.0f, 1.0f, 0.1f, 1.0f);
        GL11.glColor4f(1.0f, 1.0f, 0.1f, 1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef(2.0f, 0.0f, -10.0f);
        Sphere sphere = new Sphere();
        sphere.draw(0.5f, 25, 25);
        GL11.glPopMatrix();
    }

    public static void renderScene() {
        shadowtest.storeLightMatrices();
        GL11.glClear(16640);
        GL11.glLoadIdentity();
        GL11.glViewport(0, 0, SHADOW_WIDTH, SHADOW_HEIGHT);
        GL11.glMatrixMode(5889);
        GL11.glPushMatrix();
        GL11.glLoadMatrix(matrixProjection);
        GL11.glMatrixMode(5888);
        GL11.glLoadMatrix(matrixModelView);
        GL11.glColorMask(false, false, false, false);
        GL11.glPolygonOffset(8.0f, 4.0f);
        GL11.glEnable(32823);
        shadowtest.RenderWorld();
        GL11.glBindTexture(3553, shadowTexture.getID());
        GL11.glCopyTexSubImage2D(3553, 0, 0, 0, 0, 0, SHADOW_WIDTH, SHADOW_HEIGHT);
        GL11.glColorMask(true, true, true, true);
        GL11.glDisable(32823);
        GL11.glViewport(0, 0, 1280, 720);
        GL11.glMatrixMode(5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode(5888);
        GL11.glClear(16640);
        GL11.glLoadIdentity();
        shadowtest.look();
        shadowtest.getInverseMatrix();
        shadowtest.applyShadowMap();
    }

    private static void getInverseMatrix() {
        FloatBuffer mfb = BufferUtils.createFloatBuffer(16);
        GL11.glGetFloat(2982, mfb);
        float[] m = new float[16];
        mfb.get(m);
        float[] mCameraInverse = new float[16];
        mCameraInverse[0] = m[0];
        mCameraInverse[1] = m[4];
        mCameraInverse[2] = m[8];
        mCameraInverse[4] = m[1];
        mCameraInverse[5] = m[5];
        mCameraInverse[6] = m[9];
        mCameraInverse[8] = m[2];
        mCameraInverse[9] = m[6];
        mCameraInverse[10] = m[10];
        mCameraInverse[3] = 0.0f;
        mCameraInverse[7] = 0.0f;
        mCameraInverse[11] = 0.0f;
        mCameraInverse[15] = 1.0f;
        mCameraInverse[12] = -(m[12] * m[0]) - m[13] * m[1] - m[14] * m[2];
        mCameraInverse[13] = -(m[12] * m[4]) - m[13] * m[5] - m[14] * m[6];
        mCameraInverse[14] = -(m[12] * m[8]) - m[13] * m[9] - m[14] * m[10];
        FloatBuffer mmm = BufferUtils.createFloatBuffer(16);
        mmm.put(mCameraInverse).rewind();
        matrixCameraInverse = mmm;
    }

    public static void storeLightMatrices() {
        if (matrixModelView == null) {
            matrixModelView = BufferUtils.createFloatBuffer(16);
            matrixModelView.put(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}).rewind();
            matrixProjection = BufferUtils.createFloatBuffer(16);
            matrixProjection.put(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}).rewind();
        }
        GL11.glPushMatrix();
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GLU.gluLookAt(lightpos[0], lightpos[1], lightpos[2], lightView[0], lightView[1], lightView[2], 0.0f, 1.0f, 0.0f);
        GL11.glGetFloat(2982, matrixModelView);
        GL11.glPopMatrix();
        GL11.glLoadIdentity();
        GLU.gluPerspective(60.0f, 1.0f, 0.5f, 25.0f);
        GL11.glGetFloat(2982, matrixProjection);
        GL11.glPopMatrix();
    }

    static void applyShadowMap() {
        shadowShader.bind();
        ARBMultitexture.glActiveTextureARB(33984);
        GL11.glEnable(3553);
        GL11.glBindTexture(3553, shadowTexture.getID());
        shadowShader.setUniform1i(shadowShader.setUniformLocation("shadowMap"), 0);
        GL11.glTexParameteri(3553, 34892, 34894);
        GL11.glTexParameteri(3553, 34893, 515);
        float[] mBias = new float[]{0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f};
        FloatBuffer fb = BufferUtils.createFloatBuffer(16);
        fb.put(mBias).rewind();
        GL11.glMatrixMode(5890);
        GL11.glLoadMatrix(fb);
        GL11.glMultMatrix(matrixProjection);
        GL11.glMultMatrix(matrixModelView);
        GL11.glMultMatrix(matrixCameraInverse);
        GL11.glMatrixMode(5888);
        shadowtest.RenderWorld();
        GL11.glMatrixMode(5890);
        GL11.glLoadIdentity();
        GL11.glMatrixMode(5888);
        ARBMultitexture.glActiveTextureARB(33984);
        GL11.glDisable(3553);
        shadowShader.unbind();
    }

    static void DrawWalls() {
        float size = 5.0f;
        GL11.glBegin(7);
        GL11.glNormal3f(0.0f, 0.0f, 1.0f);
        GL11.glColor4f(1.0f, 0.0f, 1.0f, 1.0f);
        GL11.glVertex3f(-size, size, 0.0f);
        GL11.glVertex3f(-size, -size, 0.0f);
        GL11.glVertex3f(size, -size, 0.0f);
        GL11.glVertex3f(size, size, 0.0f);
        GL11.glNormal3f(1.0f, 0.0f, 0.0f);
        GL11.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
        GL11.glVertex3f(-size, size, size);
        GL11.glVertex3f(-size, -size, size);
        GL11.glVertex3f(-size, -size, 0.0f);
        GL11.glVertex3f(-size, size, 0.0f);
        GL11.glNormal3f(-1.0f, 0.0f, 0.0f);
        GL11.glColor4f(0.0f, 0.0f, 1.0f, 1.0f);
        GL11.glVertex3f(size, size, 0.0f);
        GL11.glVertex3f(size, -size, 0.0f);
        GL11.glVertex3f(size, -size, size);
        GL11.glVertex3f(size, size, size);
        GL11.glNormal3f(0.0f, 1.0f, 0.0f);
        GL11.glColor4f(0.0f, 1.0f, 0.0f, 1.0f);
        GL11.glVertex3f(size, -size, size);
        GL11.glVertex3f(size, -size, 0.0f);
        GL11.glVertex3f(-size, -size, 0.0f);
        GL11.glVertex3f(-size, -size, size);
        GL11.glEnd();
    }

    static void look() {
        GLU.gluLookAt(camPosx, camPosy, camPosz, camViewx, camViewy, camViewz, camUpx, camUpy, camUpz);
    }

    static {
        lightpos = new float[]{0.0f, 2.0f, 5.0f, 0.0f};
        lightView = new float[]{0.0f, 0.0f, 0.0f};
        g_Direction = -0.04f;
        camPosx = 0.0f;
        camPosy = 9.0f;
        camPosz = 12.0f;
        camViewx = 0.0f;
        camViewy = 2.5f;
        camViewz = -2.0f;
        camUpx = 0.0f;
        camUpy = 1.0f;
        camUpz = 0.0f;
        shadowShader = new ShaderProgram();
        rotY = 0.0f;
        SHADOW_WIDTH = 512;
        SHADOW_HEIGHT = 512;
    }
}

