/*
 * Decompiled with CFR 0.152.
 */
package sumo.v3d.math;

import org.lwjgl.opengl.GL11;

public class Vec3f {
    public float x = 0.0f;
    public float y = 0.0f;
    public float z = 0.0f;

    public Vec3f() {
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3f(float _x, float _y, float _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
    }

    public void set(float[] arr) {
        this.x = arr[0];
        this.y = arr[1];
        this.z = arr[2];
    }

    public void glTranslate() {
        GL11.glTranslatef((float)this.x, (float)this.y, (float)this.z);
    }

    public void glScale() {
        GL11.glScalef((float)this.x, (float)this.y, (float)this.z);
    }

    public void glVertex() {
        GL11.glVertex3f((float)this.x, (float)this.y, (float)this.z);
    }

    public void glColor() {
        GL11.glColor4f((float)this.x, (float)this.y, (float)this.z, (float)1.0f);
    }

    public void normalize() {
        float len = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (len == 0.0f) {
            len = 1.0f;
        }
        this.x /= len;
        this.y /= len;
        this.z /= len;
    }

    public void average(Vec3f norm) {
        this.x = this.x * 0.5f + norm.x * 0.5f;
        this.y = this.y * 0.5f + norm.y * 0.5f;
        this.z = this.z * 0.5f + norm.z * 0.5f;
    }
}

