/*
 * Decompiled with CFR 0.152.
 */
package sumo.resource.types;

import sumo.gui.Icons;
import sumo.logger.Logger;
import sumo.project.Project;
import sumo.resource.resource;
import sumo.resource.resourceIF;
import sumo.util.stopwatch;
import sumo.v3d.Scene;
import sumo.v3d.loader.OBJLoader;
import sumo.v3d.loader.V3dloader;

public class v3d
extends resource
implements resourceIF {
    public static String typedescr = "v3d";
    boolean loaded = false;
    Scene scene = new Scene();

    public String getTypeDescr() {
        return typedescr;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public String getInfo() {
        return this.path + this.filename + "";
    }

    public void reload() {
        Project.getProject().getResourceManager().setAllLoaded(false);
        this.loaded = false;
    }

    public void load() {
        stopwatch stop = new stopwatch("load: " + this.filename + " ");
        Logger.log(this.getClass(), "loading resource v3d...: " + this.path + " -- " + this.filename);
        this.scene = new Scene();
        if (this.filename.toLowerCase().contains(".v3d")) {
            V3dloader l = new V3dloader();
            this.scene = l.load(this.path, this.filename);
        } else if (this.filename.toLowerCase().contains(".obj")) {
            OBJLoader l = new OBJLoader();
            this.scene = l.load(this.path, this.filename);
        }
        this.loaded = true;
        this.invokeResourceReloadedListeners();
        stop.stop();
    }

    public Scene getScene() {
        return this.scene;
    }

    public void renderPreview() {
        if (this.scene != null) {
            this.scene.render(0.0f);
        }
    }

    public int getIcon() {
        return Icons.RESOURCE_V3D;
    }
}

