/*
 * Decompiled with CFR 0.152.
 */
package sumo.resource.types;

import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import sumo.gui.Icons;
import sumo.logger.Logger;
import sumo.project.Project;
import sumo.resource.resource;
import sumo.resource.resourceIF;
import sumo.resource.types.Texture;
import sumo.util.DevilImage;
import sumo.util.stopwatch;

public class textureFile
extends resource
implements resourceIF {
    public int id = -1;
    public static String typedescr = "texture";
    public static final int IMAGE_LIB_JAVA = 0;
    public static final int IMAGE_LIB_DEVIL = 2;
    public static int IMAGE_LIB = 0;
    boolean loaded = false;
    public int width;
    public int height;

    public int getIcon() {
        return Icons.RESOURCE_IMAGE;
    }

    public String getTypeDescr() {
        return typedescr;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public static void enable() {
        GL11.glEnable((int)34037);
    }

    public static void disable() {
        GL11.glBindTexture((int)34037, (int)0);
        GL11.glDisable((int)34037);
    }

    public boolean isValid() {
        return this.id != -1;
    }

    public void bind() {
        if (this.id != -1) {
            GL11.glEnable((int)34037);
            GL11.glBindTexture((int)34037, (int)this.getID());
        }
    }

    public String getInfo() {
        return this.width + "x" + this.height + " glid:" + this.getID();
    }

    public void reload() {
        Project.getProject().getResourceManager().setAllLoaded(false);
        this.loaded = false;
    }

    public void load() {
        stopwatch stop = new stopwatch("loaded texture: " + this.filename + " ");
        Logger.log(this.getClass(), "loading resource texture...: " + this.path + " -- " + this.filename);
        try {
            try {
                if (IMAGE_LIB == 0) {
                    Texture gli = new Texture("", 1, 1, true, false);
                    System.out.println(this.path + this.filename);
                    BufferedImage img = ImageIO.read(new File(this.path + this.filename));
                    gli.loadFromImage(img);
                    this.width = gli.width;
                    this.height = gli.height;
                    this.id = gli.id;
                    gli = null;
                } else if (IMAGE_LIB == 2) {
                    System.out.println("devil image loading deprecated!!");
                    this.id = DevilImage.loadTexture(this.path, this.filename, true);
                    this.width = DevilImage.width;
                    this.height = DevilImage.height;
                }
            }
            catch (Exception e) {
                Logger.log(this.getClass(), "loadtexture ", e);
            }
        }
        catch (Exception e) {
            Logger.log(this.getClass(), e);
        }
        this.loaded = true;
        stop.stop();
    }

    public int getID() {
        return this.id;
    }

    public void renderPreview() {
        float h;
        GL11.glClearColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glClear((int)16640);
        GL11.glLoadIdentity();
        float f1 = this.height;
        float f2 = 0.0f;
        float x = 0.0f;
        float y = 0.0f;
        float w = this.width;
        for (h = (float)this.height; w > 1.0f || h > 1.0f; w *= 0.9f, h *= 0.9f) {
        }
        w = 1.0f;
        h = 1.0f;
        GL11.glLoadIdentity();
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2903);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glClear((int)256);
        GL11.glEnable((int)34037);
        GL13.glActiveTexture((int)33984);
        this.bind();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glBegin((int)7);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTexCoord2f((float)0.0f, (float)f1);
        GL11.glVertex2f((float)(x - w / 2.0f), (float)(-1.0f * y + h / 2.0f));
        GL11.glTexCoord2f((float)0.0f, (float)f2);
        GL11.glVertex2f((float)(x - w / 2.0f), (float)(-1.0f * y - h / 2.0f));
        GL11.glTexCoord2f((float)(1.0f * (float)this.width), (float)f2);
        GL11.glVertex2f((float)(x + w / 2.0f), (float)(-1.0f * y - h / 2.0f));
        GL11.glTexCoord2f((float)(1.0f * (float)this.width), (float)f1);
        GL11.glVertex2f((float)(x + w / 2.0f), (float)(-1.0f * y + h / 2.0f));
        GL11.glEnd();
        GL13.glActiveTexture((int)33984);
        GL11.glDisable((int)34037);
    }

    public void draw(float x, float y) {
        GL11.glDisable((int)2884);
        textureFile.enable();
        this.bind();
        System.out.println("wxh: " + this.width + "x" + this.height);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)(1.0f * (float)this.height));
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)x, (float)(y + (float)this.height));
        GL11.glTexCoord2f((float)(1.0f * (float)this.width), (float)0.0f);
        GL11.glVertex2f((float)(x + (float)this.width), (float)(y + (float)this.height));
        GL11.glTexCoord2f((float)(1.0f * (float)this.width), (float)(1.0f * (float)this.height));
        GL11.glVertex2f((float)(x + (float)this.width), (float)y);
        GL11.glEnd();
    }

    public void drawFlip(float x, float y) {
        GL11.glDisable((int)2884);
        this.bind();
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)(1.0f * (float)this.height));
        GL11.glVertex2f((float)x, (float)(y + (float)this.height));
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)(1.0f * (float)this.width), (float)0.0f);
        GL11.glVertex2f((float)(x + (float)this.width), (float)y);
        GL11.glTexCoord2f((float)(1.0f * (float)this.width), (float)(1.0f * (float)this.height));
        GL11.glVertex2f((float)(x + (float)this.width), (float)(y + (float)this.height));
        GL11.glEnd();
    }
}

