/*
 * Decompiled with CFR 0.152.
 */
package sumo.project;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.jar.JarFile;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumo.app.guitest;
import sumo.app.main;
import sumo.audio.AudioSysFMOD;
import sumo.audio.AudioSystem;
import sumo.effects.EffectManager;
import sumo.gui.ScenePanel;
import sumo.gui.Settings;
import sumo.gui.detail.DetailIF;
import sumo.gui.dialogs.exceptionDialog;
import sumo.input.midi.MidiController;
import sumo.logger.Logger;
import sumo.opengl.AWTGLWindow;
import sumo.opengl.FBO;
import sumo.opengl.GLWindow;
import sumo.opengl.OpenGLSettings;
import sumo.plugin.PluginManager;
import sumo.project.SceneIF;
import sumo.resource.ResourceManager;
import sumo.resource.resourceIF;
import sumo.resource.resourceType;
import sumo.resource.types.v3d;
import sumo.timing.timerGUI;
import sumo.util.Files;
import sumo.v3d.Shader;
import sumoTween.timer.TimerIF;

public class Project {
    private SceneIF[] scenes;
    private SceneIF currentScene;
    private int currentSceneNum = 0;
    private PluginManager pluginManager;
    private ResourceManager resourceManager;
    private EffectManager effectManager;
    private String configFile = "config/resources.xml";
    private OpenGLSettings openGLSsettings;
    private int lengthSeconds = 30;
    private static Project currentProject;
    private String projectName;
    private TimerIF timer;
    public boolean debugGUI = false;
    private boolean loadFromJar = false;
    private JarFile jarFile = null;
    private DetailIF detail = null;
    private DetailIF detailMenu = null;
    public String revision = "";
    public String revisionDate = "";
    public String filename = "";
    public int numResourcesPredicted = 0;
    private boolean mute;
    public static boolean guimode;
    public static AWTGLWindow win;
    public static boolean draw2ndwin;
    private static MidiController midiController;
    public static boolean drawglmain;
    public static boolean headless;
    AudioSystem audioSystem = null;

    public Project() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            new exceptionDialog(e);
        }
        this.audioSystem = new AudioSysFMOD();
        this.setTimer(new timerGUI());
        this.projectName = "new";
        if (guimode) {
            this.scenes = new ScenePanel[50];
        }
        for (int i = 0; i < this.scenes.length; ++i) {
            this.scenes[i] = new ScenePanel();
        }
    }

    public TimerIF getTimer() {
        return this.timer;
    }

    public void setTimer(TimerIF timer) {
        this.timer = timer;
    }

    public float getTime() {
        return this.timer.getTime();
    }

    public void init() {
        this.pluginManager = new PluginManager();
        this.resourceManager = new ResourceManager();
        this.effectManager = new EffectManager();
        this.readResourceConfig();
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public SceneIF getCurrentScene() {
        return this.scenes[this.getCurrentSceneNum()];
    }

    public int getCurrentSceneNum() {
        return this.currentSceneNum;
    }

    public void setCurrentSceneNum(int i) {
        if (i >= 0 && i < this.scenes.length) {
            this.currentScene = this.scenes[i];
            this.currentSceneNum = i;
        }
    }

    public void setCurrentScene(SceneIF currentScene) {
        this.currentScene = currentScene;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    private void readResourceConfig() {
        try {
            Logger.log(this.getClass(), "reading resource config...");
            Document doc = null;
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            if (System.getProperty("sumofromjar") != null && System.getProperty("sumofromjar").equals("true") || System.getProperty("sumo_webstart") != null && System.getProperty("sumo_webstart").equals("true")) {
                this.configFile = "/resources.xml";
                doc = docBuilder.parse(this.getClass().getResource(this.configFile).openStream());
            } else {
                doc = docBuilder.parse(this.configFile);
            }
            doc.getDocumentElement().normalize();
            NodeList xmlResources = doc.getElementsByTagName("resource");
            for (int i = 0; i < xmlResources.getLength(); ++i) {
                Element e = (Element)xmlResources.item(i);
                resourceType rt = new resourceType();
                rt.setName(e.getAttribute("name"));
                rt.setLoaderclass(e.getAttribute("class"));
                ArrayList<String> suffixess = new ArrayList<String>();
                NodeList suffixes = e.getElementsByTagName("fileSuffix");
                for (int j = 0; j < suffixes.getLength(); ++j) {
                    Element se = (Element)suffixes.item(j);
                    suffixess.add(se.getTextContent());
                }
                rt.setFilenameExtensions(suffixess.toArray(new String[]{""}));
                this.getResourceManager().addResourceType(rt);
            }
        }
        catch (Exception e) {
            Logger.log(this.getClass(), e);
        }
    }

    public OpenGLSettings getOpenGLSsettings() {
        return this.openGLSsettings;
    }

    public void setOpenGLSsettings(OpenGLSettings openGLSsettings) {
        this.openGLSsettings = openGLSsettings;
    }

    public int getLength() {
        return this.lengthSeconds;
    }

    public void setLength(int l) {
        this.lengthSeconds = l;
    }

    public static Project getProject() {
        return currentProject;
    }

    public static void setProject(Project project) {
        currentProject = project;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        if (main.gui != null) {
            main.gui.mySetTitle(projectName);
        }
        this.projectName = projectName;
    }

    public int getNumFrameBuffers() {
        return FBO.FBOs.length;
    }

    public InputStream getInputStream(String path, String filename) {
        InputStream fileInputStream = null;
        try {
            if (System.getProperty("sumofromjar") != null && System.getProperty("sumofromjar").equals("true") || System.getProperty("sumo_webstart") != null && System.getProperty("sumo_webstart").equals("true")) {
                fileInputStream = this.getClass().getResource("/" + filename).openStream();
            } else if (this.loadFromJar) {
                fileInputStream = Files.getJarInputStream(this.jarFile, filename);
            } else {
                ClassLoader fileLoader = Shader.class.getClassLoader();
                fileInputStream = fileLoader.getResourceAsStream(path + filename);
            }
        }
        catch (Exception e) {
            Logger.log(this.getClass(), "project getBufferedInputStream", e);
        }
        return fileInputStream;
    }

    public BufferedInputStream getBufferedInputStream(String path, String filename) {
        BufferedInputStream in = null;
        try {
            if (this.loadFromJar) {
                InputStream inw = Files.getJarInputStream(this.jarFile, filename);
                in = new BufferedInputStream(inw);
            } else {
                FileInputStream fstream = null;
                fstream = new FileInputStream(path + filename);
                in = new BufferedInputStream(fstream);
            }
        }
        catch (Exception e) {
            Logger.log(this.getClass(), "project getBufferedInputStream", e);
        }
        return in;
    }

    public String getShaderDir() {
        return "shader/";
    }

    public DetailIF getDetailPanel() {
        return this.detail;
    }

    public void setDetailPanel(DetailIF d) {
        if (this.detail != null) {
            this.detail.dispose();
        }
        this.detail = d;
        if (d == null) {
            guitest.scrolledDetail.setViewportView(null);
        } else {
            guitest.scrolledDetail.setViewportView(this.detail.getJPanel());
        }
        if (this.detail != null) {
            ((JPanel)((Object)this.detail)).revalidate();
        }
    }

    public DetailIF getDetailMenuPanel() {
        return this.detailMenu;
    }

    public void setDetailMenuPanel(DetailIF d) {
        if (this.detailMenu != null) {
            this.detailMenu.dispose();
        }
        this.detailMenu = d;
        if (d == null) {
            guitest.scrolledDetailMenu.setViewportView(null);
        } else {
            guitest.scrolledDetailMenu.setViewportView(this.detailMenu.getJPanel());
        }
        if (this.detailMenu != null) {
            ((JPanel)((Object)this.detailMenu)).revalidate();
        }
    }

    public MidiController getMidiController() {
        return midiController;
    }

    public void setMidiController(MidiController midiController) {
        Project.midiController = midiController;
    }

    public SceneIF getScene(int which) {
        return this.scenes[which];
    }

    public int getNumScenes() {
        return this.scenes.length;
    }

    public static void setStatus(String string) {
        guitest.setStatus(string);
    }

    public void saveScenes(Element root) {
        for (int i = 0; i < this.scenes.length; ++i) {
            if (this.scenes[i].getNumLayers() <= 0) continue;
            Element xmlScene = root.getOwnerDocument().createElement("scene");
            xmlScene.setAttribute("num", String.valueOf(i));
            xmlScene.setAttribute("color", String.valueOf(this.scenes[i].getColor()));
            this.scenes[i].save(xmlScene);
            this.scenes[i].saveTiming(xmlScene);
            root.appendChild(xmlScene);
        }
    }

    public int getFPS() {
        return 30;
    }

    public float getFrameLength() {
        return 1.0f / (float)this.getFPS();
    }

    public void setTime(Float t) {
        if (Settings.snapToFrames) {
            this.setTimeFrames(t.floatValue());
        } else {
            this.getTimer().setTime(t.floatValue());
        }
    }

    public float getFrameSnapedTime(float t) {
        int currentFrame = Math.round(t / this.getFrameLength());
        return (float)currentFrame * this.getFrameLength();
    }

    private int setTimeFrames(float t) {
        int currentFrame = (int)(t / this.getFrameLength());
        float newtime = (float)currentFrame * this.getFrameLength();
        Project.getProject().getTimer().setTime(newtime);
        return currentFrame;
    }

    public boolean getSoundMute() {
        return this.mute;
    }

    public void setSoundMute(boolean b) {
        this.mute = b;
    }

    public void setAudioSystem(AudioSystem audio) {
        this.audioSystem = audio;
    }

    public AudioSystem getAudioSystem() {
        return this.audioSystem;
    }

    public EffectManager getEffectManager() {
        return this.effectManager;
    }

    public void preInitializeAll(GLWindow win) {
        for (int i = 0; i < Project.getProject().getNumScenes(); ++i) {
            GL11.glClear((int)16640);
            win.renderScene(Project.getProject().getScene(i), false);
            GL11.glClear((int)16640);
        }
        ArrayList<resourceIF> rs = Project.getProject().getResourceManager().getResources(v3d.class);
        for (int i = 0; i < rs.size(); ++i) {
            ((v3d)rs.get(i)).getScene().render(0.3f);
        }
    }

    static {
        guimode = true;
        win = null;
        draw2ndwin = false;
        drawglmain = true;
        headless = false;
    }
}

