/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.v3dplayer;

import java.util.ArrayList;
import java.util.List;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumo.gui.AbstractLine;
import sumo.gui.lineTypeElements.guiFloat;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyFramesChangedListener;
import sumo.keyframing.KeyframedBoolean;
import sumo.keyframing.KeyframedResource;
import sumo.plugin.Plugin;
import sumo.plugin.PluginIF;
import sumo.plugins.v3dplayer.SSAO;
import sumo.project.Project;
import sumo.resource.types.sShader;
import sumo.resource.types.v3d;
import sumo.v3d.BSpline;
import sumo.v3d.Light;
import sumo.v3d.NodeIF;
import sumo.v3d.Scene;
import sumo.v3d.material.Material;
import sumo.v3d.math.VEC3Tweened;
import sumo.v3d.math.Vec3f;
import sumo.v3d.math.Vec3fkeyframed;
import sumo.v3d.mesh.MeshObject;
import sumoTween.KeyFloat;
import sumoTween.Tweener;
import sumoTween.easing.Cubic;
import sumoTween.events.TweenEvent;

public class Main
extends Plugin {
    public Tweener animScratch;
    public Tweener camShake;
    public Tweener camFOV;
    public Tweener camRoll;
    public Scene s = null;
    public KeyframedResource scene;
    public Tweener camera;
    public KeyframedBoolean background;
    public KeyframedBoolean cleardepth;
    public KeyframedBoolean animRestart;
    public KeyframedBoolean shadows;
    public KeyframedBoolean ssao;
    private SSAO ssaoRenderer;
    public Tweener shadows_offsetunits;
    public Tweener shadows_offsetfactor;
    public Tweener shadows_opacity;
    public KeyframedBoolean shadows_lightcam;
    public Tweener addposp;
    public Tweener addposy;
    public Tweener addposx;
    public Tweener addposz;
    public Tweener addpostimerange;
    public Tweener timingMode;
    private int oldcam = 0;
    Vec3fkeyframed smoothKeys;
    Vec3fkeyframed smoothKeys2;
    private static final int TIMING_NORMAL = 0;
    private static final int TIMING_SCRATCH = 1;
    private static final int TIMING_FREELOOP = 2;
    final PluginIF me = this;
    ArrayList<String> dynamicMaterialsStrings = new ArrayList();
    ArrayList<String> dynamicShader = new ArrayList();
    ArrayList<Material> dynamicShaderMaterials = new ArrayList();
    ArrayList<sShader> dynamicShaderShaders = new ArrayList();
    private boolean reloadPluginSettings = false;
    float[] biasMatrix = new float[]{0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f};
    boolean addPosInited = false;
    ArrayList<AbstractLine> lines = new ArrayList();
    AbstractLine folderLight0 = null;
    AbstractLine folderMaterial = null;
    public Element XMLSettings;

    public void init() {
        this.smoothKeys = this.getCamShake(50.0f);
        this.smoothKeys2 = this.getCamShake(20.0f);
        this.scene.setResource(new v3d());
        this.scene.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                Main.this.reloadPluginSettings = true;
            }
        });
        this.timingMode.setTitleValues(new String[]{"normal", "scratch", "free loop"});
        this.timingMode.addTweenEventListener(new TweenEvent(){

            public void keysChanged() {
                if (Main.this.timingMode.getIntValue() == 0) {
                    Main.this.animScratch.setEnabled(false);
                    Main.this.animRestart.setEnabled(true);
                } else if (Main.this.timingMode.getIntValue() == 1) {
                    Main.this.animScratch.setEnabled(true);
                    Main.this.animRestart.setEnabled(false);
                } else {
                    Main.this.animScratch.setEnabled(false);
                    Main.this.animRestart.setEnabled(false);
                }
            }

            public void finished() {
            }
        });
        this.shadows.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                if (Main.this.s != null) {
                    Main.this.s.setShadows(Main.this.shadows.getKeyframedValue());
                }
            }
        });
        this.addposp.addTweenEventListener(new TweenEvent(){

            public void keysChanged() {
                Main.this.updateMeshPosAdd();
            }

            public void finished() {
            }
        });
        this.addposy.addTweenEventListener(new TweenEvent(){

            public void keysChanged() {
                Main.this.updateMeshPosAdd();
            }

            public void finished() {
            }
        });
        this.addposx.addTweenEventListener(new TweenEvent(){

            public void keysChanged() {
                Main.this.updateMeshPosAdd();
            }

            public void finished() {
            }
        });
        this.addposz.addTweenEventListener(new TweenEvent(){

            public void keysChanged() {
                Main.this.updateMeshPosAdd();
            }

            public void finished() {
            }
        });
        this.addpostimerange.addTweenEventListener(new TweenEvent(){

            public void keysChanged() {
                Main.this.updateMeshPosAdd();
            }

            public void finished() {
            }
        });
    }

    public void render() {
        if (this.reloadPluginSettings && this.scene.getResource().isLoaded()) {
            this.addCustomLines();
        }
        if (this.camera.getValue() == -1.0f) {
            return;
        }
        GL11.glClearDepth((double)999999.0);
        if (this.cleardepth.getKeyframedValue()) {
            GL11.glClear((int)256);
        }
        if (this.background.getKeyframedValue() && this.s != null) {
            GL11.glClearColor((float)this.s.backgroundcolor.x, (float)this.s.backgroundcolor.y, (float)this.s.backgroundcolor.z, (float)1.0f);
            GL11.glClear((int)16384);
        }
        if (this.s != null) {
            if (this.camera.getValue() != (float)this.oldcam || this.camera.getValue() != (float)this.s.getCamNum()) {
                this.s.setCam(this.camera.getIntValue());
                this.oldcam = this.camera.getIntValue();
            }
            this.setDynamicMaterials();
            if (this.camShake.getValue() != 0.0f) {
                if (this.s.getCam(this.camera.getIntValue()) != null) {
                    this.s.getCam((int)this.camera.getIntValue()).eyeAdd = this.smoothKeys;
                    this.s.getCam((int)this.camera.getIntValue()).targetAdd = this.smoothKeys2;
                    this.s.getCam((int)this.camera.getIntValue()).addMul = this.camShake.getValue() * 2.0f;
                }
            } else if (this.s.getCam(this.camera.getIntValue()) != null) {
                this.s.getCam((int)this.camera.getIntValue()).eyeAdd = null;
                this.s.getCam((int)this.camera.getIntValue()).targetAdd = null;
            }
            if (this.s.getCam(this.camera.getIntValue()) != null) {
                this.s.getCam((int)this.camera.getIntValue()).myfov = this.camFOV.isEnabled() ? 90.0f * this.camFOV.getValue() : -1.0f;
                this.s.getCam((int)this.camera.getIntValue()).roll = this.camRoll.isEnabled() ? 90.0f * this.camRoll.getValue() : 0.0f;
            }
            this.renderScene();
            if (this.s.shadowed() && this.s.shadow != null) {
                this.s.shadow.polyOffsetFactor = this.shadows_offsetfactor.getValue() * 4.0f;
                this.s.shadow.polyOffsetUnits = this.shadows_offsetunits.getValue() * 8.0f;
            }
        }
        GL11.glDisable((int)2896);
    }

    private void setDynamicMaterials() {
        for (int i = 0; i < this.dynamicShaderMaterials.size(); ++i) {
            this.dynamicShaderMaterials.get((int)i).settings.opacity = 0.99f;
            this.dynamicShaderMaterials.get((int)i).sShader = this.dynamicShaderShaders.get(i);
        }
    }

    private void renderScene() {
        if (this.camera.getIntValue() == -1) {
            return;
        }
        if (this.s.shadowed() != this.shadows.getKeyframedValue()) {
            this.s.setShadows(this.shadows.getKeyframedValue());
        }
        if (this.addposp.isEnabled() && !this.addPosInited) {
            this.updateMeshPosAdd();
        }
        if (this.ssao.getValue()) {
            if (this.ssaoRenderer == null) {
                this.ssaoRenderer = new SSAO();
            }
            this.ssaoRenderer.preRender();
        }
        if (this.timingMode.getIntValue() == 1) {
            this.s.render(this.s.animLength * this.animScratch.getValue());
        } else if (this.timingMode.getIntValue() == 2) {
            float f = (float)Sys.getTime() / 1000.0f % this.s.animLength;
            this.s.render(f);
        } else {
            float f = Project.getProject().getTime() - this.animRestart.getKey(Project.getProject().getTime()).getTime();
            this.s.render(f);
        }
        if (this.ssao.getValue()) {
            this.ssaoRenderer.postRender();
            this.ssaoRenderer.render();
        }
    }

    public String getAuthor() {
        return null;
    }

    public float getVersion() {
        return 0.0f;
    }

    public Vec3fkeyframed getCamShake(float max) {
        ArrayList<Vec3f> points = new ArrayList<Vec3f>();
        for (int i = 0; i < 100; ++i) {
            points.add(new Vec3f((float)Math.random() * max * 2.0f - max, (float)Math.random() * max * 2.0f - max, (float)Math.random() * max * 2.0f - max));
        }
        BSpline spline = new BSpline(points);
        spline.setResolution(5);
        spline.calc();
        ArrayList<Vec3f> smoothPoints = spline.getSmoothedPoints();
        Vec3fkeyframed smoothKeys = new Vec3fkeyframed();
        for (int i = 0; i < smoothPoints.size(); ++i) {
            float time = (float)i / 20.0f;
            smoothKeys.x.setValue(time, smoothPoints.get((int)i).x);
            smoothKeys.y.setValue(time, smoothPoints.get((int)i).y);
            smoothKeys.z.setValue(time, smoothPoints.get((int)i).z);
        }
        return smoothKeys;
    }

    private void addMaterialLine(Material m) {
        if (this.folderMaterial == null) {
            this.folderMaterial = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 2, "materials", null);
            this.getAbstractLine().childs.add(this.folderMaterial);
        }
        AbstractLine al = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 2, m.title, null);
        this.lines.add(al);
        this.folderMaterial.childs.add(al);
        AbstractLine al3 = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "emission", new guiFloat(m.settings.emission));
        this.lines.add(al3);
        this.folderMaterial.childs.add(al3);
        AbstractLine al2 = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "shininess", new guiFloat(m.settings.shininess));
        this.lines.add(al2);
        this.folderMaterial.childs.add(al2);
        AbstractLine alColorr = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "diff_r", new guiFloat(m.settings.colorDiffuse.x));
        this.lines.add(alColorr);
        this.folderMaterial.childs.add(alColorr);
        AbstractLine alColorg = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "diff_g", new guiFloat(m.settings.colorDiffuse.y));
        this.lines.add(alColorg);
        this.folderMaterial.childs.add(alColorg);
        AbstractLine alColorb = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "diff_b", new guiFloat(m.settings.colorDiffuse.z));
        this.lines.add(alColorb);
        this.folderMaterial.childs.add(alColorb);
        AbstractLine alColorAmbientr = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "ambi_r", new guiFloat(m.settings.colorAmbient.x));
        this.lines.add(alColorAmbientr);
        this.folderMaterial.childs.add(alColorAmbientr);
        AbstractLine alColorAmbientg = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "ambi_g", new guiFloat(m.settings.colorAmbient.y));
        this.lines.add(alColorAmbientg);
        this.folderMaterial.childs.add(alColorAmbientg);
        AbstractLine alColorAmbientb = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "ambi_b", new guiFloat(m.settings.colorAmbient.z));
        this.lines.add(alColorAmbientb);
        this.folderMaterial.childs.add(alColorAmbientb);
        AbstractLine alColorSpecularr = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "spec_r", new guiFloat(m.settings.colorSpecular.x));
        this.lines.add(alColorSpecularr);
        this.folderMaterial.childs.add(alColorSpecularr);
        AbstractLine alColorSpecularg = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "spec_g", new guiFloat(m.settings.colorSpecular.y));
        this.lines.add(alColorSpecularg);
        this.folderMaterial.childs.add(alColorSpecularg);
        AbstractLine alColorSpecularb = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "spec_b", new guiFloat(m.settings.colorSpecular.z));
        this.lines.add(alColorSpecularb);
        this.folderMaterial.childs.add(alColorSpecularb);
    }

    public void saveXML(Element root) {
        if (this.s == null) {
            return;
        }
        for (Material m : this.s.getMaterials()) {
            m.settings.saveXML(root);
        }
        for (Light l : this.s.getLights()) {
            l.saveXML(root);
        }
    }

    public void loadXML(Element root) {
        if (root == null) {
            return;
        }
        this.XMLSettings = root;
        if (this.scene.getResource().isLoaded()) {
            Element e;
            int i;
            NodeList nl = ((Main)this.me).XMLSettings.getElementsByTagName("materialsettings");
            for (i = 0; i < nl.getLength(); ++i) {
                e = (Element)nl.item(i);
                String matTitle = e.getAttribute("title");
                Material m = this.s.getMaterialByTitle(matTitle);
                if (m == null) continue;
                m.settings.loadXML(e);
            }
            nl = ((Main)this.me).XMLSettings.getElementsByTagName("light");
            for (i = 0; i < nl.getLength(); ++i) {
                e = (Element)nl.item(i);
                String lightTitle = e.getAttribute("title");
                Light l = this.s.getLightByTitle(lightTitle);
                if (l == null) continue;
                l.loadXML(e);
            }
        }
    }

    public String getSubTitle() {
        if (this.scene != null) {
            return this.scene.getResource().getFilename();
        }
        return null;
    }

    private void updateMeshPosAdd() {
        if (this.s == null) {
            return;
        }
        this.addPosInited = true;
        List<NodeIF> i = this.s.getMeshObjectNodes();
        boolean count = false;
        for (NodeIF nodeIF : i) {
            MeshObject o = (MeshObject)nodeIF;
            if (this.addposp.isEnabled()) {
                float t;
                float f;
                int j;
                KeyFloat[] keys;
                o.posAdd = new VEC3Tweened(new Cubic(), Project.getProject().getTimer());
                if (this.addposz.isEnabled()) {
                    keys = this.addposx.getKeys();
                    for (j = 0; j < keys.length; ++j) {
                        f = (float)((double)(o.pos.x * 5.0f) + Math.random() * (double)o.pos.x * 30.0) * keys[j].getValue();
                        t = (float)Math.random();
                        o.posAdd.x.set(keys[j].getTime() + t, f, 2);
                        System.out.println(this.addpostimerange.getValue() + "!!!!!!!!!!" + t);
                    }
                    o.posAdd.x.printKeys();
                }
                if (this.addposy.isEnabled()) {
                    keys = this.addposy.getKeys();
                    for (j = 0; j < keys.length; ++j) {
                        f = (float)((double)(o.pos.y * 5.0f) + Math.random() * (double)o.pos.y * 30.0) * keys[j].getValue();
                        t = (float)Math.random();
                        o.posAdd.y.set(keys[j].getTime() + t, f, 2);
                    }
                }
                if (!this.addposz.isEnabled()) continue;
                keys = this.addposz.getKeys();
                for (j = 0; j < keys.length; ++j) {
                    f = (float)((double)(o.pos.z * 5.0f) + Math.random() * (double)o.pos.z * 30.0) * keys[j].getValue();
                    t = (float)Math.random();
                    o.posAdd.z.set(keys[j].getTime() + t, f, 2);
                }
                continue;
            }
            o.posAdd = null;
        }
    }

    void addCustomLines() {
        this.s = ((v3d)this.scene.getResource()).getScene();
        this.s.setShadows(this.shadows.getKeyframedValue());
        this.camera.setTitleValues(this.s.getCameraTitles());
        for (Material m : this.s.getMaterials()) {
            this.addMaterialLine(m);
        }
        try {
            if (Project.guimode) {
                this.folderLight0 = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this.me, 2, "light 0", null);
                this.getAbstractLine().childs.add(this.folderLight0);
                AbstractLine allc = new AbstractLine(this.folderLight0, this.getAbstractLine().pluginPanel, this.me, 0, "constant att", new guiFloat(this.s.getLight().attenuationConstant));
                AbstractLine allq = new AbstractLine(this.folderLight0, this.getAbstractLine().pluginPanel, this.me, 0, "quadrativ att", new guiFloat(this.s.getLight().attenuationQuadratic));
                AbstractLine alll = new AbstractLine(this.folderLight0, this.getAbstractLine().pluginPanel, this.me, 0, "linear att", new guiFloat(this.s.getLight().attenuationLinear));
                this.lines.add(allc);
                this.folderLight0.childs.add(allc);
                this.lines.add(allq);
                this.folderLight0.childs.add(allq);
                this.lines.add(alll);
                this.folderLight0.childs.add(alll);
                AbstractLine alColorDiffr = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "diff_r", new guiFloat(this.s.getLight().colorDiffuse.x));
                this.lines.add(alColorDiffr);
                this.folderLight0.childs.add(alColorDiffr);
                AbstractLine alColorDiffg = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "diff_g", new guiFloat(this.s.getLight().colorDiffuse.y));
                this.lines.add(alColorDiffg);
                this.folderLight0.childs.add(alColorDiffg);
                AbstractLine alColorDiffb = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "diff_b", new guiFloat(this.s.getLight().colorDiffuse.z));
                this.lines.add(alColorDiffb);
                this.folderLight0.childs.add(alColorDiffb);
                AbstractLine alColorAmbr = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "ambi_r", new guiFloat(this.s.getLight().colorAmbient.x));
                this.lines.add(alColorAmbr);
                this.folderLight0.childs.add(alColorAmbr);
                AbstractLine alColorAmbg = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "ambi_g", new guiFloat(this.s.getLight().colorAmbient.y));
                this.lines.add(alColorAmbg);
                this.folderLight0.childs.add(alColorAmbg);
                AbstractLine alColorAmbb = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "ambi_b", new guiFloat(this.s.getLight().colorAmbient.z));
                this.lines.add(alColorAmbb);
                this.folderLight0.childs.add(alColorAmbb);
                AbstractLine alColorSpecr = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "spec_r", new guiFloat(this.s.getLight().colorSpecular.x));
                this.lines.add(alColorSpecr);
                this.folderLight0.childs.add(alColorSpecr);
                AbstractLine alColorSpecg = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "spec_g", new guiFloat(this.s.getLight().colorSpecular.y));
                this.lines.add(alColorSpecg);
                this.folderLight0.childs.add(alColorSpecg);
                AbstractLine alColorSpecb = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, "spec_b", new guiFloat(this.s.getLight().colorSpecular.z));
                this.lines.add(alColorSpecb);
                this.folderLight0.childs.add(alColorSpecb);
            }
            this.loadXML(this.XMLSettings);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dynamicMaterialsStrings.clear();
        this.dynamicShader.clear();
        this.getAbstractLine().rebuildPluginPanel();
        this.reloadPluginSettings = false;
    }
}

