/*
 * Decompiled with CFR 0.152.
 */
package sumo.plugins.shaderBuilderExample;

import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.w3c.dom.Element;
import sumo.gui.AbstractLine;
import sumo.gui.lineTypeElements.guiFloat;
import sumo.keyframing.KeyFramedIF;
import sumo.keyframing.KeyFramesChangedListener;
import sumo.keyframing.KeyframedBoolean;
import sumo.keyframing.KeyframedResource;
import sumo.opengl.FBOManager;
import sumo.opengl.common;
import sumo.plugin.Plugin;
import sumo.project.Project;
import sumo.resource.types.sShader;
import sumo.resource.types.textureFile;
import sumo.shader.ShaderListener;
import sumo.shader.ShaderPartProgram;
import sumo.shader.ShaderVariable;
import sumo.shader.SumoShader;
import sumo.util.freeTimer;
import sumoTween.Tweener;

public class ShaderBuilderExample
extends Plugin {
    public KeyframedResource rShader;
    public KeyframedResource image1;
    public KeyframedResource image2;
    public KeyframedResource image3;
    public KeyframedResource image4;
    public KeyframedBoolean alpha;
    public Tweener show;
    private textureFile tex1;
    private textureFile tex2;
    private textureFile tex3;
    private textureFile tex4;
    SumoShader shader;
    protected boolean initTexture1 = false;
    protected boolean initTexture2 = false;
    protected boolean initTexture3 = false;
    protected boolean initTexture4 = false;
    freeTimer timer = new freeTimer();
    ArrayList<AbstractLine> lines = new ArrayList();
    ArrayList<ShaderVariable> updateFloats = new ArrayList();
    ArrayList<ShaderVariable> updateInts = new ArrayList();
    private boolean needsLocUpdate = false;

    public void init() {
        this.show.setTitleValues(new String[]{"none", "fullscreen", "free", "cube"});
        this.rShader.setResource(new sShader());
        this.rShader.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                ShaderBuilderExample.this.shader = ((sShader)ShaderBuilderExample.this.rShader.getResource()).getSumoShader();
                if (ShaderBuilderExample.this.shader != null) {
                    ShaderBuilderExample.this.shader.addShaderListener(new ShaderListener(){

                        public void recompiled() {
                            ShaderBuilderExample.this.myUpdate();
                            ShaderBuilderExample.this.initTexture1 = true;
                            ShaderBuilderExample.this.initTexture2 = true;
                        }
                    });
                }
                ShaderBuilderExample.this.initTexture1 = true;
                ShaderBuilderExample.this.initTexture2 = true;
                ShaderBuilderExample.this.myUpdate();
            }
        });
        this.image1.setResource(new textureFile());
        this.image1.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                if (ShaderBuilderExample.this.shader != null) {
                    ShaderBuilderExample.this.initTexture1 = true;
                }
            }
        });
        this.image2.setResource(new textureFile());
        this.image2.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                ShaderBuilderExample.this.initTexture2 = true;
            }
        });
        this.image3.setResource(new textureFile());
        this.image3.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                ShaderBuilderExample.this.initTexture3 = true;
            }
        });
        this.image4.setResource(new textureFile());
        this.image4.addKeysChangedListener(new KeyFramesChangedListener(){

            public void keysChanged(KeyFramedIF keyframed) {
                ShaderBuilderExample.this.initTexture4 = true;
            }
        });
    }

    public void render() {
        int y1;
        if (this.shader == null) {
            this.shader = new SumoShader();
        }
        if (this.needsLocUpdate) {
            for (ShaderPartProgram part : this.shader.getProgramms()) {
                for (ShaderVariable v : part.getUniforms()) {
                    v.updateLoc(this.shader);
                }
            }
            this.needsLocUpdate = false;
        }
        GL11.glClear((int)256);
        if (this.initTexture1 && this.image1.getResource() != null) {
            this.shader.setMultiTexture(0, ((textureFile)this.image1.getResource()).getID(), "_ctex00");
            this.tex1 = (textureFile)this.image1.getResource();
            this.initTexture1 = false;
        }
        if (this.initTexture2 && this.image2.getResource() != null) {
            this.shader.setMultiTexture(1, ((textureFile)this.image2.getResource()).getID(), "_ctex01");
            this.tex2 = (textureFile)this.image2.getResource();
            this.initTexture2 = false;
        }
        if (this.initTexture3 && this.image3.getResource() != null) {
            this.shader.setMultiTexture(2, ((textureFile)this.image3.getResource()).getID(), "_ctex02");
            this.tex3 = (textureFile)this.image3.getResource();
            this.initTexture3 = false;
        }
        if (this.initTexture4 && this.image4.getResource() != null) {
            this.shader.setMultiTexture(3, ((textureFile)this.image4.getResource()).getID(), "_ctex03");
            this.tex4 = (textureFile)this.image4.getResource();
            this.initTexture4 = false;
        }
        this.shader.alpha = this.alpha.getValue();
        this.shader.bind();
        for (ShaderVariable v : this.updateFloats) {
            this.shader.setUniform1f(v.getLoc(this.shader), v.getKeyframed().getValue());
        }
        int y2 = Project.getProject().getOpenGLSsettings().getHeight();
        int ys = y1 = 0;
        int ys2 = y2;
        FBOManager.glViewport();
        if (!FBOManager.isFBOBound()) {
            int height169 = (int)((float)Project.getProject().getOpenGLSsettings().getWidth() * 0.5625f);
            ys = (Project.getProject().getOpenGLSsettings().getHeight() - height169) / 2;
            ys2 = ys + height169;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glClear((int)256);
        if (this.show.getIntValue() == 1) {
            common.switchTo2d();
            GL11.glBegin((int)7);
            if (this.tex1 != null) {
                GL13.glMultiTexCoord2f((int)33984, (float)0.0f, (float)0.0f);
                if (this.tex2 != null) {
                    GL13.glMultiTexCoord2f((int)33985, (float)0.0f, (float)0.0f);
                }
            } else {
                GL13.glMultiTexCoord2f((int)33984, (float)0.0f, (float)y1);
            }
            GL11.glVertex2f((float)0.0f, (float)ys);
            if (this.tex1 != null) {
                GL13.glMultiTexCoord2f((int)33984, (float)0.0f, (float)this.tex1.height);
                if (this.tex2 != null) {
                    GL13.glMultiTexCoord2f((int)33985, (float)0.0f, (float)this.tex2.height);
                }
            } else {
                GL13.glMultiTexCoord2f((int)33984, (float)0.0f, (float)y2);
            }
            GL11.glVertex2f((float)0.0f, (float)ys2);
            if (this.tex1 != null) {
                GL13.glMultiTexCoord2f((int)33984, (float)this.tex1.width, (float)this.tex1.height);
                if (this.tex2 != null) {
                    GL13.glMultiTexCoord2f((int)33985, (float)this.tex2.width, (float)this.tex2.height);
                }
            } else {
                GL13.glMultiTexCoord2f((int)33984, (float)Project.getProject().getOpenGLSsettings().getWidth(), (float)y2);
            }
            GL11.glVertex2f((float)Project.getProject().getOpenGLSsettings().getWidth(), (float)ys2);
            if (this.tex1 != null) {
                GL13.glMultiTexCoord2f((int)33984, (float)this.tex1.width, (float)0.0f);
                if (this.tex2 != null) {
                    GL13.glMultiTexCoord2f((int)33985, (float)this.tex2.width, (float)0.0f);
                }
            } else {
                GL13.glMultiTexCoord2f((int)33984, (float)Project.getProject().getOpenGLSsettings().getWidth(), (float)y1);
            }
            GL11.glVertex2f((float)Project.getProject().getOpenGLSsettings().getWidth(), (float)ys);
            GL11.glEnd();
            common.switchTo3d();
        } else if (this.show.getIntValue() == 2) {
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-6.5f);
            GL11.glRotatef((float)(this.timer.getTime() * 70.0f), (float)0.78f, (float)0.54f, (float)0.9f);
            this.drawCube();
        } else if (this.show.getIntValue() == 3) {
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-6.5f);
            GL11.glRotatef((float)(this.timer.getTime() * 70.0f), (float)0.78f, (float)0.54f, (float)0.9f);
            this.drawCube();
        }
        this.shader.unbind();
        GL11.glClear((int)256);
    }

    public String getAuthor() {
        return "tom";
    }

    public float getVersion() {
        return 0.0f;
    }

    public String getName() {
        return "shaderbuilder";
    }

    private void drawCube() {
        GL11.glBegin((int)7);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)-1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)0.0f, (float)(1.0f * (float)this.tex1.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)-1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.tex1.width), (float)(1.0f * (float)this.tex1.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.tex1.width), (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)0.0f, (float)(1.0f * (float)this.tex1.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.tex1.width), (float)(1.0f * (float)this.tex1.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)-1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.tex1.width), (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)-1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)0.0f, (float)(1.0f * (float)this.tex1.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.tex1.width), (float)(1.0f * (float)this.tex1.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.tex1.width), (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)-1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)0.0f, (float)(1.0f * (float)this.tex1.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)-1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.tex1.width), (float)(1.0f * (float)this.tex1.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)-1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.tex1.width), (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)-1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        }
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)0.0f, (float)(1.0f * (float)this.tex1.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)-1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.tex1.width), (float)(1.0f * (float)this.tex1.height));
        }
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)-1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.tex1.width), (float)0.0f);
        }
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)-1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)0.0f, (float)(1.0f * (float)this.tex1.height));
        }
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.tex1.width), (float)(1.0f * (float)this.tex1.height));
        }
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)1.0f);
        if (this.tex1 != null) {
            GL11.glTexCoord2f((float)(1.0f * (float)this.tex1.width), (float)0.0f);
        }
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glEnd();
    }

    private synchronized void myUpdate() {
        if (this.shader.getNeedsRecompile()) {
            return;
        }
        System.out.println("MYUPDATE!");
        if (this.shader == null) {
            return;
        }
        this.updateFloats = new ArrayList();
        this.updateInts = new ArrayList();
        while (this.lines.size() > 0) {
            for (int i = 0; i < this.lines.size(); ++i) {
                this.getAbstractLine().childs.remove(this.lines.get(i));
                this.lines.remove(i);
            }
        }
        for (ShaderPartProgram part : this.shader.getProgramms()) {
            for (ShaderVariable v : part.getUniforms()) {
                this.needsLocUpdate = true;
                guiFloat f = null;
                f = new guiFloat(v.getKeyframed());
                v.getKeyframed().setName(v.getName());
                AbstractLine al = new AbstractLine(this.getAbstractLine(), this.getAbstractLine().pluginPanel, this, 0, v.getName(), f);
                this.lines.add(al);
                this.getAbstractLine().childs.add(al);
                this.updateFloats.add(v);
            }
        }
        AbstractLine dell = null;
        for (AbstractLine l : this.lines) {
            if (this.getVar(l.getTitle()) != null) continue;
            dell = l;
            System.out.println("delete line!!!" + l.getTitle());
        }
        if (dell != null) {
            this.lines.remove(dell);
            this.getAbstractLine().childs.remove(dell);
        }
        this.getAbstractLine().rebuildPluginPanel();
        System.out.println(this.updateFloats.size() + " updatefloats");
    }

    public ShaderVariable getVar(String s) {
        for (ShaderPartProgram part : this.shader.getProgramms()) {
            for (ShaderVariable v : part.getUniforms()) {
                if (!v.getName().equals(s)) continue;
                return v;
            }
        }
        return null;
    }

    public void saveXML(Element root) {
    }

    public void loadXML(Element root) {
    }

    public String getSubTitle() {
        if (this.rShader != null) {
            return this.rShader.getResource().getFilename();
        }
        return null;
    }
}

