/*
 * Decompiled with CFR 0.152.
 */
package sumo.opengl;

import java.awt.GraphicsEnvironment;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;
import sumo.app.guitest;
import sumo.gui.debug.guiDebugData;
import sumo.gui.detailMenu.RendererDetail;
import sumo.logger.Logger;
import sumo.opengl.FBO;
import sumo.opengl.OpenGLSettings;
import sumo.opengl.common;
import sumo.project.Project;
import sumo.project.SceneIF;
import sumo.resource.resourceIF;
import sumo.util.Files;

public class AWTGLPanel
extends AWTGLCanvas {
    SceneIF activescene = null;
    private OpenGLSettings settings;
    public boolean enabled = true;
    long currenttime = 0L;
    long lastfpstime = 0L;
    int fps = 0;
    int frames = 0;
    String title = "-";
    boolean paused = false;
    public static int mousey = 0;
    public static int mousex = 0;
    public static int mouseDragY = 0;
    public static int mouseDragX = 0;
    public static boolean mouseWasDragged = false;
    public static boolean mouseover = false;
    private boolean renderResourcePreview = false;
    private resourceIF resourcePreview = null;
    public boolean renderingToImages = false;
    public RendererDetail rendererDetail = null;

    public AWTGLPanel(OpenGLSettings settings, boolean sharedContext) throws LWJGLException {
        super(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0], new PixelFormat(settings.getBpp(), settings.getAlpha(), settings.getDepth(), settings.getStencil(), settings.getMultisampling()), settings.sharedContext);
        this.init(settings);
    }

    public AWTGLPanel(OpenGLSettings settings) throws LWJGLException {
        super(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0], new PixelFormat(settings.getBpp(), settings.getAlpha(), settings.getDepth(), settings.getStencil(), settings.getMultisampling()), settings.sharedContext);
        this.init(settings);
    }

    private void init(OpenGLSettings settings) {
        this.setSettings(settings);
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                mouseWasDragged = true;
                mouseDragX = e.getX() - mousex;
                mouseDragY = e.getY() - mousey;
            }

            public void mouseMoved(MouseEvent e) {
                mousex = e.getX();
                mousey = e.getY();
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                mouseWasDragged = false;
            }

            public void mouseExited(MouseEvent e) {
                mouseover = false;
            }

            public void mouseEntered(MouseEvent e) {
                mouseover = true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintGL() {
        if (!this.enabled) {
            return;
        }
        try {
            AWTGLPanel aWTGLPanel = this;
            synchronized (aWTGLPanel) {
                common.glInit(this.getWidth(), this.getHeight());
                GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                GL11.glClear((int)16640);
                GL11.glEnable((int)2929);
                GL11.glDisable((int)3042);
                GL11.glDisable((int)3553);
                GL11.glLoadIdentity();
                FBO.initFrameBufferTextures(this.settings);
                Project.getProject().getResourceManager().loadResources();
                if (Project.getProject().getResourceManager().isAllLoaded()) {
                    FBO.initFrameBuffers();
                }
                if (!this.paused) {
                    if (this.activescene != null) {
                        this.activescene.render();
                    } else {
                        Logger.log(((Object)((Object)this)).getClass(), "activescene IS NULL!!!");
                    }
                    ++this.frames;
                    this.currenttime = System.currentTimeMillis();
                    if (this.currenttime > this.lastfpstime + 1000L) {
                        this.fps = this.frames;
                        this.frames = 0;
                        this.lastfpstime = this.currenttime;
                        if (this.fps > 2) {
                            this.settings.setCurrentFPS(this.fps);
                        }
                        Project.getProject();
                        if (Project.guimode) {
                            guitest.setFPS(this.fps);
                        }
                        guiDebugData.reset();
                    }
                }
            }
            if (this.renderResourcePreview) {
                this.resourcePreview.renderPreview();
            }
            this.swapBuffers();
            if (this.renderingToImages) {
                AWTGLPanel aWTGLPanel2 = this;
                String s = common.screenShot("c:/temp/", aWTGLPanel2.rendererDetail.getFilename(), RendererDetail.format, this.getWidth(), this.getHeight());
                if (this.rendererDetail.upload) {
                    AWTGLPanel aWTGLPanel3 = this;
                    Files.uploadScreenshot("c:/temp/" + aWTGLPanel3.rendererDetail.getFilename() + "." + RendererDetail.format);
                }
                this.rendererDetail.finishScreenshot();
            }
        }
        catch (Exception e) {
            Logger.log(((Object)((Object)this)).getClass(), e);
            System.exit(1);
        }
    }

    public void setPaused(boolean p) {
        this.paused = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScene(SceneIF activeDemo) {
        AWTGLPanel aWTGLPanel = this;
        synchronized (aWTGLPanel) {
            if (activeDemo == null) {
                this.activescene = null;
                return;
            }
            this.activescene = activeDemo;
        }
    }

    public OpenGLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(OpenGLSettings settings) {
        this.settings = settings;
        Project.getProject().setOpenGLSsettings(settings);
    }

    public void stopPreview(resourceIF obj) {
        this.renderResourcePreview = false;
    }

    public void setPreview(resourceIF obj) {
        this.resourcePreview = obj;
        this.renderResourcePreview = obj != null;
    }
}

