/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.timing;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;
import sumo.gui.ScenePanel;
import sumo.gui.Settings;
import sumo.gui.lineTypeElements.ValueChangedListener;
import sumo.gui.lineTypeElements.ValueEvent;
import sumo.gui.lineTypeElements.guiFloat;
import sumo.project.Project;
import sumoTween.Tweener;

public class TimingZoomPanel
extends JPanel {
    public guiFloat zoom;
    private ScenePanel scenePanel;
    int maxPixelPerSecond = 500;

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.zoom.setBounds(0, 0, w, h);
    }

    public TimingZoomPanel(ScenePanel sp) {
        this.scenePanel = sp;
        this.setLayout(null);
        Tweener kff = new Tweener();
        this.zoom = new guiFloat(kff);
        this.zoom.setBounds(3, 3, 100, 15);
        this.zoom.setFgColor(Settings.SUMO2_DARK);
        this.zoom.setBgColor(Settings.SUMO2_BRIGHTER);
        this.zoom.drawBottomBorder = false;
        this.zoom.addValueChangedListener(new ValueChangedListener(){

            public void valueChanged(ValueEvent e) {
                if (TimingZoomPanel.this.zoom.getValue() == 0.0f) {
                    TimingZoomPanel.this.scenePanel.setZoom(10);
                } else {
                    TimingZoomPanel.this.scenePanel.setZoom((int)(TimingZoomPanel.this.zoom.getValue() * (float)TimingZoomPanel.this.maxPixelPerSecond));
                }
            }
        });
        this.add(this.zoom);
    }

    public void paint(Graphics g) {
        g.setColor(Settings.SUMO2_BG);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintComponents(g);
        if (Project.getProject().debugGUI) {
            g.setFont(Settings.smallfont);
            g.setColor(Color.blue);
            g.drawString(this.getClass().getName(), 10, 15);
        }
    }

    public float getMaxPixelPerSecond() {
        return this.maxPixelPerSecond;
    }
}

