/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.sumoComponents.tab;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import sumo.gui.Button;
import sumo.gui.Icons;
import sumo.gui.Settings;
import sumo.gui.sumoComponents.tab.tabClickedListener;

public class SumoTab
extends JComponent {
    String title = "not title";
    ArrayList<tabClickedListener> clickEvents = new ArrayList();
    public JComponent component;
    final SumoTab me;
    private boolean active = false;
    private boolean closeable = false;
    private Button buttonClose;

    public SumoTab(String title) {
        this.title = title;
        this.buttonClose = new Button(Icons.ICON_X, "close");
        this.buttonClose.setBgColor(Settings.SUMO2_BG);
        this.buttonClose.setBgMouseOverColor(Settings.SUMO2_BG);
        this.buttonClose.setBgMousePressedColor(Settings.SUMO2_BG);
        this.me = this;
        if (this.closeable) {
            this.add(this.buttonClose);
        }
        this.addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                for (tabClickedListener cl : SumoTab.this.clickEvents) {
                    cl.clicked(SumoTab.this.me);
                }
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }
        });
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public void paint(Graphics g) {
        g.setColor(Settings.SUMO2_BG);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.active) {
            g.setColor(Settings.SUMO2_DARKER);
            g.drawString(this.title, 10, 18);
        } else {
            g.setColor(Settings.SUMO2_BRIGHT);
            g.drawString(this.title, 10, 15);
        }
        if (!this.active) {
            g.setColor(Settings.SUMO2_DARKER);
            g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        } else {
            g.setColor(Settings.SUMO2_DARKER);
            g.drawLine(0, 7, 0, this.getHeight() - 1);
            g.drawLine(this.getWidth() - 1, 7, this.getWidth() - 1, this.getHeight() - 1);
        }
        if (this.closeable) {
            this.buttonClose.setBounds(this.getWidth() - 18, 5, 13, 13);
        }
        this.paintComponents(g);
    }

    public void addTabClickedListener(tabClickedListener sumoTabClicked) {
        this.clickEvents.add(sumoTabClicked);
    }

    public void setActive(boolean b) {
        this.active = b;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setClosable(boolean closableTabs) {
        this.closeable = closableTabs;
    }
}

