/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.sumoComponents.list;

import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import sumo.gui.Icons;
import sumo.gui.Settings;
import sumo.gui.sumoComponents.list.ListLineSelectListener;
import sumo.gui.sumoComponents.list.SumoList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListLine
extends JComponent
implements DragGestureListener,
DragSourceListener {
    DragSource dragSource;
    public static final int LINE_HEIGHT = 19;
    private ArrayList<ListLine> lines = new ArrayList();
    private ArrayList<ListLineSelectListener> selectedListeners = new ArrayList();
    private String title = "no title";
    private int level = 0;
    private boolean minimized = false;
    protected boolean selected = false;
    private boolean selectable = false;
    private SumoList root;
    private final ListLine me = this;
    private String dndString = "";
    private int icon = -1;

    protected ListLine(SumoList root, String title) {
        this.root = root;
        this.title = title;
        this.addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent arg0) {
            }

            public void mousePressed(MouseEvent arg0) {
                ListLine.this.me.minimized = !ListLine.this.me.minimized;
                if (ListLine.this.me.isSelectable()) {
                    ListLine.this.notifySelectListeners();
                    ListLine.this.me.root.clearSelections();
                    ((ListLine)ListLine.this).me.selected = true;
                }
                ListLine.this.me.root.reOrder();
            }

            public void mouseExited(MouseEvent arg0) {
            }

            public void mouseEntered(MouseEvent arg0) {
            }

            public void mouseClicked(MouseEvent arg0) {
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        if (this.hasChilds()) {
            g.setFont(Settings.fontBold);
        } else {
            g.setFont(Settings.font);
        }
        if (this.hasChilds()) {
            g.setColor(Settings.SUMO2_BRIGHT);
        } else if (this.selected && this.isSelectable()) {
            g.setColor(Settings.SUMO2_BRIGHTER);
        } else {
            g.setColor(Settings.SUMO2_DETAILBG);
        }
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Settings.SUMO2_BG);
        g.drawLine(0, 0, this.getWidth(), 0);
        g.setColor(Settings.SUMO2_TEXT_DARK);
        g.drawString(this.title, 20 + this.level * 10, 13);
        if (this.icon != -1) {
            Icons.drawIcon(g, this.icon, 3, 2);
        }
        if (this.hasChilds()) {
            g.setColor(Settings.SUMO2_DARKER);
            int x = this.level * 10;
            if (this.minimized) {
                Polygon polyClosed = new Polygon();
                polyClosed.addPoint(x + 8, 5);
                polyClosed.addPoint(x + 13, 9);
                polyClosed.addPoint(x + 8, 13);
                g.fillPolygon(polyClosed);
            } else {
                Polygon polyOpened = new Polygon();
                polyOpened.addPoint(x + 6, 9);
                polyOpened.addPoint(x + 14, 9);
                polyOpened.addPoint(x + 10, 13);
                g.fillPolygon(polyOpened);
            }
        }
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public ArrayList<ListLine> getChilds() {
        return this.lines;
    }

    public boolean hasChilds() {
        return this.lines.size() > 0;
    }

    public void addChild(ListLine newLine) {
        this.lines.add(newLine);
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void removeChilds() {
        this.lines.clear();
        this.lines.trimToSize();
    }

    public String getDNDString() {
        return this.dndString;
    }

    public void setDNDString(String dndString) {
        this.dndString = dndString;
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent arg0) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent arg0) {
    }

    @Override
    public void dragExit(DragSourceEvent arg0) {
    }

    @Override
    public void dragOver(DragSourceDragEvent arg0) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent arg0) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent evt) {
        StringSelection t = new StringSelection(this.dndString);
        this.dragSource.startDrag(evt, DragSource.DefaultCopyDrop, t, this);
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void clearSelections() {
        this.selected = false;
        if (this.hasChilds()) {
            for (ListLine line : this.lines) {
                line.clearSelections();
            }
        }
    }

    public void setIcon(int i) {
        this.icon = i;
    }

    private void notifySelectListeners() {
        for (ListLineSelectListener l : this.selectedListeners) {
            l.selected(this);
        }
    }

    public void addSelectListener(ListLineSelectListener listLineSelectListener) {
        this.selectedListeners.add(listLineSelectListener);
    }

    public ListLine getChildByTitle(String s) {
        if (this.title.equals(s)) {
            return this;
        }
        for (ListLine l : this.lines) {
            ListLine ll = l.getChildByTitle(s);
            if (ll == null) continue;
            return ll;
        }
        return null;
    }
}

