/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.sumoComponents;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import sumo.gui.Icons;
import sumo.gui.Settings;
import sumo.gui.sumoComponents.SumoScroll;

public class SumoScrollbar
extends JComponent {
    static final int BUTTONS_HEIGHT = 18;
    private boolean active = true;
    boolean mouseOver = false;
    int mousey = 0;
    int scroll_height = 1000;
    int scroll_pos = 0;
    float scroll_heightPercent = 0.5f;
    SumoScroll scroll = null;

    public void updateResize() {
        this.scroll.setBounds(0, 18, this.getWidth(), this.getHeight() - 36);
    }

    public SumoScrollbar() {
        this.setLayout(null);
        this.scroll = new SumoScroll();
        this.updateResize();
        this.add(this.scroll);
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent e) {
                SumoScrollbar.this.mousey = e.getY();
            }

            public void mouseDragged(MouseEvent e) {
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent arg0) {
            }

            public void mousePressed(MouseEvent arg0) {
            }

            public void mouseClicked(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
                SumoScrollbar.this.mouseOver = false;
                SumoScrollbar.this.repaint();
            }

            public void mouseEntered(MouseEvent arg0) {
                SumoScrollbar.this.mouseOver = true;
                SumoScrollbar.this.repaint();
            }
        });
    }

    void calc() {
        this.scroll_heightPercent = 0.5f;
        this.scroll.setHeight(this.scroll_heightPercent);
    }

    public void paint(Graphics g) {
        this.calc();
        g.setColor(Settings.SUMO2_BRIGHTER);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.active) {
            g.setColor(Settings.SUMO2_BG);
            g.fillRect(0, 0, this.getWidth() - 1, 18);
            g.setColor(Settings.SUMO2_DARKER);
            g.drawRect(0, 0, this.getWidth() - 1, 18);
            g.setColor(Settings.SUMO2_BG);
            g.fillRect(0, this.getHeight() - 18, this.getWidth() - 1, 18);
            g.setColor(Settings.SUMO2_DARKER);
            g.drawRect(0, this.getHeight() - 18 - 1, this.getWidth() - 1, 18);
            Icons.drawIcon(g, Icons.ICON_SCROLL_UP, 1, 1);
            Icons.drawIcon(g, Icons.ICON_SCROLL_DOWN, 1, this.getHeight() - 18);
        }
        this.paintComponents(g);
    }

    public void setActive(boolean b) {
        this.active = b;
        this.repaint();
    }
}

