/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui.detailMenu;

import java.awt.Label;
import sumo.gui.Icons;
import sumo.gui.detail.DetailButtonPressedListener;
import sumo.gui.detail.DetailEmpty;
import sumo.gui.detail.DetailIF;
import sumo.gui.detail.Elements.DetailButton;
import sumo.opengl.AWTGLWindow;
import sumo.project.Project;

public class RendererDetail
extends DetailEmpty
implements DetailIF {
    DetailButton btrenderFORMAT;
    DetailButton btrenderUPLOAD;
    public static String format = "png";
    private int framesToRender = Project.getProject().getLength() * 30;
    public static int renderframe = 0;
    Label l;
    Label linfo;
    boolean stop = false;
    public boolean upload = false;

    public RendererDetail() {
        this.setTitle(this, "renderer to images", true);
        this.setLayout(null);
        DetailButton btrenderALL = new DetailButton(-1, "all frames");
        btrenderALL.setBounds(10, 50, 80, 17);
        this.add(btrenderALL);
        DetailButton btrenderSINGLE = new DetailButton(-1, "single frame");
        btrenderSINGLE.setBounds(100, 50, 80, 17);
        this.add(btrenderSINGLE);
        this.btrenderFORMAT = new DetailButton(-1, format);
        this.btrenderFORMAT.setBounds(190, 50, 80, 17);
        this.add(this.btrenderFORMAT);
        DetailButton btrender = new DetailButton(Icons.ICON_TIME_PLAY, "render!");
        btrender.setBounds(10, 75, 170, 17);
        this.add(btrender);
        this.btrenderUPLOAD = new DetailButton(-1, "upload: " + this.upload);
        this.btrenderUPLOAD.setBounds(190, 75, 80, 17);
        this.add(this.btrenderUPLOAD);
        DetailButton btrenderSTOP = new DetailButton(Icons.ICON_NONE, "stop");
        btrenderSTOP.setBounds(10, 175, 170, 17);
        this.add(btrenderSTOP);
        this.linfo = new Label();
        this.linfo.setText("project length: " + Project.getProject().getLength() * 30 + " frames at 30 fps");
        this.linfo.setBounds(10, 95, 179, 30);
        this.add(this.linfo);
        this.l = new Label();
        this.l.setText("...");
        this.l.setBounds(10, 120, 179, 30);
        this.add(this.l);
        btrenderSTOP.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                RendererDetail.this.stop = true;
                RendererDetail.this.updateLabelText();
            }
        });
        btrenderSINGLE.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                RendererDetail.this.framesToRender = 1;
                RendererDetail.this.updateLabelText();
            }
        });
        btrenderALL.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                RendererDetail.this.upload = false;
                RendererDetail.this.framesToRender = Project.getProject().getLength() * 30;
                RendererDetail.this.updateLabelText();
            }
        });
        this.btrenderUPLOAD.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                RendererDetail.this.upload = !RendererDetail.this.upload;
                RendererDetail.this.updateLabelText();
            }
        });
        this.btrenderFORMAT.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                if ((format = format.equals("png") ? "bmp" : "png").equals("bmp")) {
                    RendererDetail.this.upload = false;
                }
                RendererDetail.this.btrenderFORMAT.setTitle(format);
                RendererDetail.this.updateLabelText();
            }
        });
        btrender.addDetailButtonPressedListener(new DetailButtonPressedListener(){

            public void pressed() {
                renderframe = 0;
                RendererDetail.this.startRender();
            }
        });
    }

    public void dispose() {
    }

    private void updateLabelText() {
        this.btrenderUPLOAD.setTitle("upload: " + this.upload);
        this.linfo.setText("will render " + this.framesToRender + " frames into " + format + " files");
    }

    public void startRender() {
        Project.getProject();
        if (Project.win == null) {
            AWTGLWindow wi = new AWTGLWindow();
            Project.draw2ndwin = true;
            Project.win = wi;
        }
        this.stop = false;
        Project.win.glPanel.setSize(1280, 720);
        Project.win.setSize(1280, 720);
        Project.win.updateResize();
        Project.win.glPanel.renderingToImages = true;
        Project.win.glPanel.rendererDetail = (RendererDetail)Project.getProject().getDetailMenuPanel();
    }

    public static String getFilename() {
        return "screen" + renderframe;
    }

    public void finishScreenshot() {
        this.l.setText("rendered " + ++renderframe + " of " + this.framesToRender);
        if (renderframe == this.framesToRender || this.stop) {
            Project.win.glPanel.renderingToImages = false;
            Project.win.glPanel.rendererDetail = null;
        } else {
            Project.getProject().getTimer().setTime((float)renderframe * 1.0f / 30.0f);
            Project.win.glPanel.rendererDetail = (RendererDetail)Project.getProject().getDetailMenuPanel();
            Project.win.glPanel.renderingToImages = true;
        }
    }
}

