/*
 * Decompiled with CFR 0.152.
 */
package sumo.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.lwjgl.Sys;
import org.w3c.dom.Element;
import sumo.gui.AbstractLine;
import sumo.gui.Button;
import sumo.gui.Icons;
import sumo.gui.PluginPanel;
import sumo.gui.Settings;
import sumo.gui.lines.BasicLine;
import sumo.gui.timing.TimingPanel;
import sumo.gui.timing.TimingScrollPanel;
import sumo.gui.timing.TimingZoomPanel;
import sumo.gui.timing.timeControlPanel;
import sumo.math.vec2f;
import sumo.opengl.AWTGLPanel;
import sumo.plugin.PluginIF;
import sumo.project.Project;
import sumo.project.SceneIF;
import sumoTween.KeyFloat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenePanel
extends JPanel
implements SceneIF {
    private int timingWidth = 0;
    int pixelPerSecond = 100;
    public TimingPanel timingPanel;
    public ArrayList<KeyFloat> markedKeys = new ArrayList();
    private AWTGLPanel glPanel;
    private JScrollPane scrolledPluginPanel;
    private PluginPanel pluginPanel;
    private TimingZoomPanel timingZoomPanel;
    private TimingScrollPanel timingScrollPanel;
    private String title = "";
    public float keyDraggStartTime = -9999.0f;
    public timeControlPanel timeControll;
    private int color = 0;
    private static final float[] zoomSteps = new float[]{0.02f, 0.05f, 0.1f, 0.2f, 0.4f, 0.7f, 1.0f, 1.5f, 2.0f};
    int currentzoom = 0;
    Button zoom1;
    Button zoom2;
    long lastrepaint = 0L;
    long lastrepaintvalues = 0L;
    public static int oldPixelTime = 0;

    public void moveMarkedKeys(float draggTime) {
        if (this.keyDraggStartTime == -9999.0f) {
            this.keyDraggStartTime = draggTime;
        }
        float diff = draggTime - this.keyDraggStartTime;
        for (int i = 0; i < this.markedKeys.size(); ++i) {
            this.markedKeys.get(i).setTime(this.markedKeys.get(i).getTime() + diff);
        }
        this.keyDraggStartTime = draggTime;
        this.repaintTimings();
    }

    public AWTGLPanel getGlPanel() {
        return this.glPanel;
    }

    public void setGlPanel(AWTGLPanel glPanel) {
        this.glPanel = glPanel;
    }

    public ScenePanel() {
        this.setLayout(null);
        this.timingZoomPanel = new TimingZoomPanel(this);
        this.add(this.timingZoomPanel);
        this.timingScrollPanel = new TimingScrollPanel(this);
        this.add(this.timingScrollPanel);
        this.timingPanel = new TimingPanel();
        this.add(this.timingPanel);
        this.timingPanel.setScenePanel(this);
        this.pluginPanel = new PluginPanel(this);
        this.pluginPanel.setPreferredSize(new Dimension(500, 1000));
        this.scrolledPluginPanel = new JScrollPane(this.pluginPanel, 22, 31);
        this.scrolledPluginPanel.getVerticalScrollBar().setUnitIncrement(20);
        this.scrolledPluginPanel.setBounds(0, 40, 580, 300);
        this.scrolledPluginPanel.getHorizontalScrollBar().setEnabled(true);
        this.scrolledPluginPanel.getVerticalScrollBar().setEnabled(true);
        this.add(this.scrolledPluginPanel);
        this.timeControll = new timeControlPanel(this);
        this.add(this.timeControll);
        this.zoom1 = new Button(Icons.ICON_ZOOM_OUT, "change zoom");
        this.zoom2 = new Button(Icons.ICON_ZOOM_IN, "change zoom");
        this.zoom1.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                ScenePanel.this.setZoomStep(ScenePanel.this.currentzoom - 1);
            }
        });
        this.zoom2.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                ScenePanel.this.setZoomStep(ScenePanel.this.currentzoom + 1);
            }
        });
        this.add(this.zoom1);
        this.add(this.zoom2);
    }

    public void setZoomStep(int i) {
        if (i >= zoomSteps.length) {
            i = zoomSteps.length - 1;
        }
        if (i < 0) {
            i = 0;
        }
        this.timingZoomPanel.zoom.setValue(zoomSteps[i]);
        this.currentzoom = i;
        this.repaintTimings(true);
        this.setZoom((int)(this.timingZoomPanel.zoom.getValue() * this.timingZoomPanel.getMaxPixelPerSecond()));
    }

    @Override
    public void paint(Graphics gd) {
        gd.setColor(Settings.SUMO2_BG);
        gd.fillRect(0, 0, this.getWidth(), this.getHeight());
        gd.setFont(Settings.font);
        this.paintComponents(gd);
        if (Project.getProject().debugGUI) {
            gd.setFont(Settings.smallfont);
            gd.setColor(Color.green);
            gd.drawString(this.getClass().getName(), 10, 15);
            gd.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    public void setPos(float p) {
        Project.getProject().getTimer().setTime(p);
        this.myRepaint();
    }

    public void addMarkedKey(KeyFloat k) {
        if (!this.markedKeys.contains(k)) {
            this.markedKeys.add(k);
        }
    }

    public void resetMarkedKeys() {
        this.myRepaint();
        this.markedKeys.clear();
    }

    public void myRepaint() {
        this.timingPanel.repaint();
        this.repaint();
    }

    public void addPlugin(PluginIF plugin) {
        this.pluginPanel.addPlugin(plugin);
    }

    public void myResize(int x, int y, int w, int h) {
        this.setBounds(x, y, w, h);
        this.setLayout(null);
        this.pluginPanel.setBounds(0, 0, w - 5, 16);
        this.pluginPanel.rebuildPluginComponents();
        this.pluginPanel.updateUI();
        this.scrolledPluginPanel.setBorder(null);
        this.scrolledPluginPanel.setBounds(0, 30, w - 0, h - 110);
        this.scrolledPluginPanel.repaint();
        this.scrolledPluginPanel.getViewport().updateUI();
        this.scrolledPluginPanel.setBorder(null);
        this.timingWidth = this.getWidth() - BasicLine.POS_KEYFRAMEPANEL - 15;
        this.timingPanel.setBounds(BasicLine.POS_KEYFRAMEPANEL, 0, this.timingWidth, 30);
        this.zoom1.setBounds(10, this.getHeight() - 53, 16, 15);
        this.zoom2.setBounds(30, this.getHeight() - 53, 16, 15);
        this.timingZoomPanel.setBounds(BasicLine.POS_KEYFRAMEPANEL - 130, this.getHeight() - 53, 120, 18);
        this.timingScrollPanel.setBounds(BasicLine.POS_KEYFRAMEPANEL, this.getHeight() - 53, this.getWidth() - BasicLine.POS_KEYFRAMEPANEL - 20, 17);
        this.myRepaint();
        this.updateUI();
    }

    @Override
    public void addLayerAfter(AbstractLine old, PluginIF newplug) {
        this.pluginPanel.addPluginAfter(old, newplug);
    }

    @Override
    public void addLayer(PluginIF plug) {
        this.pluginPanel.addPlugin(plug);
    }

    @Override
    public void render() {
        this.pluginPanel.renderPluginsGL();
    }

    public int getTimingWidth() {
        return this.timingWidth;
    }

    public PluginPanel getPluginPanel() {
        return this.pluginPanel;
    }

    @Override
    public void removeSelectedLayer() {
    }

    @Override
    public void selectNextLayer() {
    }

    @Override
    public void selectPreviousLayer() {
    }

    public TimingPanel getTimingPanel() {
        return this.timingPanel;
    }

    public void setTimingPanel(TimingPanel timingPanel) {
        this.timingPanel = timingPanel;
    }

    public TimingScrollPanel getTimingScrollPanel() {
        return this.timingScrollPanel;
    }

    public void setTimingScrollPanel(TimingScrollPanel timingScrollPanel) {
        this.timingScrollPanel = timingScrollPanel;
    }

    public void repaintTimings() {
        this.repaintTimings(true);
    }

    public void repaintTimings(boolean ignoreTiming) {
        if (ignoreTiming || Sys.getTime() - this.lastrepaint > 50L) {
            this.timeControll.repaint();
            this.timingPanel.repaint();
            this.pluginPanel.repaintTimings();
            this.lastrepaint = Sys.getTime();
        }
    }

    public void repaintValueControllers() {
        this.pluginPanel.repaintValueControllers();
    }

    public int getZoom() {
        return this.pixelPerSecond;
    }

    public void setZoom(int value) {
        if (value <= 1) {
            ++value;
        }
        System.out.println("zoom:" + value);
        this.pixelPerSecond = value;
        this.timingScrollPanel.centerCursor();
    }

    public int getTimeInPixelsScreen(float time) {
        return this.getTimeInPixel(time) - this.getTimeInPixel(this.timingScrollPanel.scrollOffsetTime);
    }

    public int getTimeInPixel(float time) {
        return (int)((float)this.pixelPerSecond * time);
    }

    public Float getTimeFromPixelScreen(int x) {
        float time = (float)x / (float)this.pixelPerSecond + this.timingScrollPanel.scrollOffsetTime;
        if (Settings.snapToFrames) {
            return Float.valueOf(Project.getProject().getFrameSnapedTime(time));
        }
        return Float.valueOf(time);
    }

    public Float getTimeFromPixel(int x) {
        return Float.valueOf((float)x / (float)this.pixelPerSecond);
    }

    public boolean isTimeVisible(float time) {
        return time >= this.timingScrollPanel.scrollOffsetTime && time <= this.timingScrollPanel.scrollOffsetTime + this.getTimeFromPixel(this.getTimingWidth()).floatValue();
    }

    public boolean isMarked(KeyFloat k) {
        return this.markedKeys.contains(k);
    }

    public void removeMarkedKey(KeyFloat k) {
        this.markedKeys.remove(k);
    }

    public void deleteMarkedKeys() {
        this.pluginPanel.deleteMarkedKeys(this.markedKeys);
    }

    @Override
    public int getNumLayers() {
        return this.pluginPanel.getNumLayers();
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int c) {
        this.color = c;
    }

    @Override
    public void save(Element root) {
        this.pluginPanel.save(root);
    }

    @Override
    public void addTimeArea(vec2f area) {
        this.timingPanel.addTimeArea(area);
    }

    @Override
    public void clearTimeAreas() {
        this.timingPanel.clearTimeAreas();
    }

    @Override
    public void saveTiming(Element root) {
        root.setAttribute("offsetTime", String.valueOf(this.timingScrollPanel.scrollOffsetTime));
        root.setAttribute("pixelPerSecond", String.valueOf(this.pixelPerSecond));
    }

    @Override
    public void loadTiming(Element e) {
        if (!e.getAttribute("offsetTime").equals("")) {
            this.timingScrollPanel.scrollOffsetTime = Float.parseFloat(e.getAttribute("offsetTime"));
        }
        if (!e.getAttribute("pixelPerSecond").equals("")) {
            this.pixelPerSecond = Integer.parseInt(e.getAttribute("pixelPerSecond"));
        }
    }

    public ArrayList<KeyFloat> getAllVisibleKeys(AbstractLine line) {
        ArrayList<KeyFloat> keys = new ArrayList<KeyFloat>();
        KeyFloat[] ckeys = line.drawableLine.getKeyFramePanel().getKeys();
        if (ckeys != null) {
            for (int i = 0; i < ckeys.length; ++i) {
                keys.add(ckeys[i]);
            }
        }
        if (!line.isMinimized) {
            for (AbstractLine al : line.childs) {
                keys.addAll(this.getAllVisibleKeys(al));
            }
        }
        return keys;
    }

    @Override
    public ArrayList<KeyFloat> getAllVisibleKeys() {
        ArrayList<KeyFloat> keys = new ArrayList<KeyFloat>();
        ArrayList<AbstractLine> lines = this.pluginPanel.getAllLines();
        for (AbstractLine line : lines) {
            keys.addAll(this.getAllVisibleKeys(line));
        }
        Collections.sort(keys, new Comparator(){

            public int compare(Object a, Object b) {
                KeyFloat ia = (KeyFloat)a;
                KeyFloat ib = (KeyFloat)b;
                if (ia.getTime() > ib.getTime()) {
                    return 0;
                }
                return 1;
            }
        });
        return keys;
    }

    public void centerCursor() {
        this.timingScrollPanel.centerCursor();
    }

    public void moveCursorFrame(int i) {
        float s = 1.0f / (float)Project.getProject().getFPS();
        int currentFrame = Math.round(Project.getProject().getTime() / s);
        float newtime = (float)(currentFrame + i) * s;
        Project.getProject().getTimer().setTime(newtime);
        this.repaintTimings();
    }

    @Override
    public ArrayList<AbstractLine> getAllLines() {
        return this.pluginPanel.getAllLines();
    }

    @Override
    public void setTitle(String s) {
        this.title = s;
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

