/*
 * Decompiled with CFR 0.152.
 */
package sumo.evoke.plugins.evokebeam;

import java.util.ArrayList;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sumo.evoke.plugins.evokebeam.data.Screen;
import sumo.evoke.plugins.evokebeam.data.Sponsor;
import sumo.evoke.plugins.evokebeam.helper;
import sumo.project.Project;
import sumo.resource.types.textureFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Show {
    private boolean waitForKey;
    ArrayList<Screen> screens = new ArrayList();
    int currentScreen = 0;
    long fadeDuration = 1500L;
    static ArrayList<Sponsor> sponsors = new ArrayList();
    long lastSlideSwitch = 0L;
    boolean isFading = false;
    long currentSlideTime = 0L;
    float allPrios = 0.0f;
    int lastSponsor = -1;

    public void render() {
        if (this.lastSlideSwitch == 0L) {
            this.lastSlideSwitch = Sys.getTime();
        }
        this.currentSlideTime = Sys.getTime() - this.lastSlideSwitch;
        if (this.screens.size() > 0 && this.currentSlideTime > (long)this.screens.get(this.currentScreen).getDuration()) {
            this.lastSlideSwitch = Sys.getTime();
            this.nextSlide();
            this.currentSlideTime = Sys.getTime() - this.lastSlideSwitch;
        }
        GL11.glLoadIdentity();
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glClear((int)256);
        if (this.screens.size() > 0) {
            this.screens.get(this.currentScreen).render(this.currentSlideTime);
            if (this.screens.get((int)this.currentScreen).finished) {
                this.screens.get((int)this.currentScreen).finished = false;
                this.screens.get(this.currentScreen).fadeOut(0.0f);
                this.nextSlide();
            }
        }
    }

    private int getNextScreen() {
        if (this.currentScreen + 1 > this.screens.size() - 1) {
            return 0;
        }
        if (this.screens.get(this.currentScreen + 1).getResults() != null) {
            this.screens.get((int)(this.currentScreen + 1)).getResults().currentStep = 0;
        }
        return this.currentScreen + 1;
    }

    public void previousSlide() {
        --this.currentScreen;
        if (this.currentScreen < 0) {
            this.currentScreen = this.screens.size() - 1;
        }
        this.lastSlideSwitch = Sys.getTime();
        if (this.screens.get(this.currentScreen).getResults() != null) {
            this.screens.get((int)this.currentScreen).getResults().currentStep = 0;
        }
        this.updateTitle();
    }

    public void nextSlideSmooth() {
        if (this.screens.get(this.currentScreen).getResults() != null) {
            this.screens.get(this.currentScreen).getResults().continueResults();
        } else {
            if (this.isFading) {
                return;
            }
            this.lastSlideSwitch = Sys.getTime() - (long)this.screens.get(this.currentScreen).getDuration();
        }
    }

    public void nextSlide() {
        if (this.isFading) {
            System.out.println("still fading");
            return;
        }
        if (this.screens.size() != 2) {
            ++this.currentScreen;
            if (this.currentScreen >= this.screens.size()) {
                this.currentScreen = 0;
                this.randomizeSponsors();
            }
            this.lastSlideSwitch = Sys.getTime();
            this.updateTitle();
        }
    }

    public void updateTitle() {
        Display.setTitle((String)("" + this.currentScreen + "/" + (this.screens.size() - 1)));
    }

    public void addScreen(Screen s) {
        this.screens.add(s);
    }

    public void setWaitForKey(boolean b) {
        this.waitForKey = b;
    }

    public boolean getWaitForKey() {
        return this.waitForKey;
    }

    public void setCurrentScreen(int i) {
        this.currentScreen = 0;
    }

    public void addScreens(ArrayList<Screen> sc) {
        this.screens.addAll(sc);
    }

    public void clear() {
        this.screens.clear();
    }

    public void addSponsorScreens(NodeList sponsorScreens) {
        sponsors.clear();
        float prioEnd = 0.0f;
        for (int i = 0; i < sponsorScreens.getLength(); ++i) {
            Element e = (Element)sponsorScreens.item(i);
            Sponsor spo = new Sponsor();
            float prio = Float.parseFloat(e.getAttribute("prio")) + prioEnd + 1.0f;
            this.allPrios = prioEnd += prio;
            spo.setPrio(prio, prioEnd);
            spo.setDuration(9000);
            String template = e.getAttribute("template");
            String[] sss = helper.downfile(template);
            textureFile tf = (textureFile)Project.getProject().getResourceManager().add(sss[0], sss[1]);
            spo.setBackgroundTexture(tf);
            sponsors.add(spo);
        }
        int si = this.screens.size();
        for (int i = 0; i < si; ++i) {
            Screen s = new Screen();
            s.setType(1);
            this.screens.add(i * 2 + 1, s);
        }
        this.randomizeSponsors();
    }

    public void randomizeSponsors() {
        if (sponsors.size() > 0) {
            for (int i = 0; i < this.screens.size(); ++i) {
                if (this.screens.get(i).getType() != 1) continue;
                int rs = this.getRandomSponsor();
                while (rs == this.lastSponsor) {
                    rs = this.getRandomSponsor();
                }
                this.screens.get(i).setBackgroundTexture(sponsors.get(rs).getBackgroundTexture());
                this.screens.get(i).setDuration(sponsors.get(rs).getDuration());
                this.lastSponsor = rs;
            }
        }
    }

    public int getRandomSponsor() {
        float random = this.allPrios * (float)Math.random();
        int num = (int)((float)sponsors.size() * (float)Math.random());
        for (int i = 0; i < sponsors.size(); ++i) {
            System.out.println("sponsor:" + i + " " + sponsors.get(i).getPrio() + " - " + sponsors.get(i).getPrioEnd());
            if (!(random > sponsors.get(i).getPrio()) || !(random < sponsors.get(i).getPrioEnd())) continue;
            System.out.println("found sponsor");
            num = i;
        }
        return num;
    }

    public ArrayList<Screen> getScreens() {
        return this.screens;
    }

    public Screen getCurrentScreen() {
        return this.screens.get(this.currentScreen);
    }
}

