/*
 * Decompiled with CFR 0.152.
 */
package sumo.audio;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import org.jouvieje.bass.Bass;
import org.jouvieje.bass.Init;
import org.jouvieje.bass.exceptions.InitException;
import org.jouvieje.bass.structures.HSTREAM;
import org.lwjgl.BufferUtils;
import org.lwjgl.Sys;
import sumo.audio.AudioSystem;
import sumo.resource.types.AudioFile;

public class AudioSysBASS
implements AudioSystem {
    boolean inited = false;
    HashMap<Integer, HSTREAM> audioStreams = new HashMap();
    static int idCounter = 0;
    long FFTLastUpdate = 0L;
    ByteBuffer FFTByteBuffer = null;
    FloatBuffer FFTFloatBuffer = null;

    public void init() {
        try {
            Init.loadLibraries((int)1);
        }
        catch (InitException e) {
            System.out.println("NativeBass error! " + e.getMessage());
            return;
        }
        if (!Bass.BASS_Init((int)1, (int)44100, (int)0, null, null)) {
            System.out.println("Can't initialize device");
            return;
        }
        this.inited = true;
    }

    public String getName() {
        return "BASS";
    }

    public int loadAudioFile(String filename) {
        if (!this.inited) {
            this.init();
        }
        HSTREAM stream = null;
        stream = Bass.BASS_StreamCreateFile((boolean)false, (String)filename, (long)0L, (long)0L, (int)0);
        if (stream == null) {
            System.out.println("Can't open stream");
        }
        this.audioStreams.put(++idCounter, stream);
        return idCounter;
    }

    private HSTREAM getStream(AudioFile audioFile) {
        if (audioFile == null) {
            return null;
        }
        return this.audioStreams.get(audioFile.getID());
    }

    public float getTime(AudioFile audio) {
        HSTREAM stream = this.getStream(audio);
        if (stream != null) {
            float f = (float)Bass.BASS_ChannelBytes2Seconds((int)stream.asInt(), (long)Bass.BASS_ChannelGetPosition((int)stream.asInt(), (int)0));
            return f;
        }
        return 0.0f;
    }

    public void play(AudioFile audio) {
        HSTREAM stream = this.getStream(audio);
        if (stream != null) {
            int chan = stream != null ? stream.asInt() : 0;
            Bass.BASS_ChannelPlay((int)chan, (boolean)false);
        }
        audio.isPlaying = true;
    }

    public void setTime(AudioFile audioFile, float f) {
        HSTREAM stream = this.getStream(audioFile);
        if (stream != null) {
            Bass.BASS_ChannelSetPosition((int)stream.asInt(), (long)Bass.BASS_ChannelSeconds2Bytes((int)stream.asInt(), (double)f), (int)0);
        }
    }

    public void stop(AudioFile audioFile) {
        HSTREAM stream = this.getStream(audioFile);
        if (stream != null) {
            Bass.BASS_ChannelStop((int)stream.asInt());
        }
    }

    public void pause(AudioFile audio) {
        HSTREAM stream = this.getStream(audio);
        if (stream != null) {
            Bass.BASS_ChannelStop((int)stream.asInt());
        }
        audio.isPlaying = false;
    }

    public FloatBuffer getFFT(AudioFile audio) {
        if (Sys.getTime() - this.FFTLastUpdate >= 25L) {
            this.updateFFTData(audio);
        }
        return this.FFTFloatBuffer;
    }

    private void updateFFTData(AudioFile audio) {
        this.FFTLastUpdate = Sys.getTime();
        HSTREAM stream = this.getStream(audio);
        if (stream != null) {
            if (this.FFTByteBuffer == null) {
                this.FFTByteBuffer = BufferUtils.createByteBuffer((int)2048);
            }
            Bass.BASS_ChannelGetData((int)stream.asInt(), (ByteBuffer)this.FFTByteBuffer, (int)-2147483645);
            this.FFTFloatBuffer = this.FFTByteBuffer.asFloatBuffer();
        }
    }

    public void playSoundEffect(AudioFile audio, float volume) {
        System.out.println("bass playsoundeffect not implemented yet...");
    }

    public void close(AudioFile mp3) {
        System.out.println("bass close not implemented yet...");
    }

    public float getLengthSeconds(AudioFile mp3) {
        System.out.println("bass getLengthSeconds not implemented yet...");
        return 0.0f;
    }

    public void setFrequency(int i) {
        System.out.println("bass setFrequency not implemented yet...");
    }
}

