/*
 * Decompiled with CFR 0.152.
 */
package sumo.app;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.GLU;
import org.lwjgl.opengl.glu.Sphere;
import sumo.gui.dialogs.exceptionDialog;
import sumo.opengl.GLWindow;
import sumo.opengl.OpenGLSettings;
import sumo.project.Project;
import sumo.resource.types.Texture;
import sumo.util.FPSCounter;
import sumo.v3d.Shader;
import sumo.v3d.ShaderProgram;
import sumoTween.timer.TimerIF;

public class shadowtest {
    public static TimerIF timer;
    static float[] lightpos;
    static float[] lightView;
    static float g_Direction;
    static float camPosx;
    static float camPosy;
    static float camPosz;
    static float camViewx;
    static float camViewy;
    static float camViewz;
    static float camUpx;
    static float camUpy;
    static float camUpz;
    static FloatBuffer matrixModelView;
    static FloatBuffer matrixProjection;
    static FloatBuffer matrixCameraInverse;
    static ShaderProgram shadowShader;
    static Texture shadowTexture;
    static Shader sv;
    static Shader sf;
    static float rotY;
    static int SHADOW_WIDTH;
    static int SHADOW_HEIGHT;

    public static void main(String[] args) {
        Project p = new Project();
        Project.guimode = false;
        p.init();
        Project.setProject(p);
        OpenGLSettings settings = new OpenGLSettings(1280, 720, false);
        settings.setMultisampling(4);
        p.setOpenGLSsettings(settings);
        GLWindow win = new GLWindow(settings.findMode(), settings);
        win.open();
        boolean isPlaying = false;
        FPSCounter fpsCounter = new FPSCounter();
        try {
            shadowtest.initShadow();
            while (!Keyboard.isKeyDown((int)1)) {
                GL11.glClear((int)16640);
                shadowtest.renderScene();
                fpsCounter.nextFrame();
                Display.update();
                Display.setTitle((String)("fps:" + fpsCounter.fps));
                try {
                    Thread.sleep(5L);
                }
                catch (Exception e) {}
            }
            win.close();
        }
        catch (Exception e) {
            new exceptionDialog(e);
        }
        System.exit(0);
    }

    public static void initShadow() {
        sf = new Shader("c:/demogame/", "shadow.fs", 1);
        sv = new Shader("c:/demogame/", "shadow.vs", 2);
        shadowShader.changeShader(sf);
        shadowShader.changeShader(sv);
        shadowTexture = new Texture("", SHADOW_WIDTH, SHADOW_HEIGHT, true, false);
        FloatBuffer fb = BufferUtils.createFloatBuffer((int)4);
        fb.put(lightpos).rewind();
        GL11.glLight((int)16384, (int)4611, (FloatBuffer)fb);
        GL11.glClearColor((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)16384);
        GL11.glEnable((int)2903);
    }

    public static void RenderWorld() {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-15.0f);
        shadowtest.DrawWalls();
        GL11.glPopMatrix();
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.1f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.1f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)2.0f, (float)0.0f, (float)-10.0f);
        Sphere sphere = new Sphere();
        sphere.draw(0.5f, 25, 25);
        GL11.glPopMatrix();
    }

    public static void renderScene() {
        shadowtest.storeLightMatrices();
        GL11.glClear((int)16640);
        GL11.glLoadIdentity();
        GL11.glViewport((int)0, (int)0, (int)SHADOW_WIDTH, (int)SHADOW_HEIGHT);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadMatrix((FloatBuffer)matrixProjection);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadMatrix((FloatBuffer)matrixModelView);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glPolygonOffset((float)8.0f, (float)4.0f);
        GL11.glEnable((int)32823);
        shadowtest.RenderWorld();
        GL11.glBindTexture((int)3553, (int)shadowTexture.getID());
        GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)SHADOW_WIDTH, (int)SHADOW_HEIGHT);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDisable((int)32823);
        GL11.glViewport((int)0, (int)0, (int)1280, (int)720);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glClear((int)16640);
        GL11.glLoadIdentity();
        shadowtest.look();
        shadowtest.getInverseMatrix();
        shadowtest.applyShadowMap();
    }

    private static void getInverseMatrix() {
        FloatBuffer mfb = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)mfb);
        float[] m = new float[16];
        mfb.get(m);
        float[] mCameraInverse = new float[16];
        mCameraInverse[0] = m[0];
        mCameraInverse[1] = m[4];
        mCameraInverse[2] = m[8];
        mCameraInverse[4] = m[1];
        mCameraInverse[5] = m[5];
        mCameraInverse[6] = m[9];
        mCameraInverse[8] = m[2];
        mCameraInverse[9] = m[6];
        mCameraInverse[10] = m[10];
        mCameraInverse[3] = 0.0f;
        mCameraInverse[7] = 0.0f;
        mCameraInverse[11] = 0.0f;
        mCameraInverse[15] = 1.0f;
        mCameraInverse[12] = -(m[12] * m[0]) - m[13] * m[1] - m[14] * m[2];
        mCameraInverse[13] = -(m[12] * m[4]) - m[13] * m[5] - m[14] * m[6];
        mCameraInverse[14] = -(m[12] * m[8]) - m[13] * m[9] - m[14] * m[10];
        FloatBuffer mmm = BufferUtils.createFloatBuffer((int)16);
        mmm.put(mCameraInverse).rewind();
        matrixCameraInverse = mmm;
    }

    public static void storeLightMatrices() {
        if (matrixModelView == null) {
            matrixModelView = BufferUtils.createFloatBuffer((int)16);
            matrixModelView.put(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}).rewind();
            matrixProjection = BufferUtils.createFloatBuffer((int)16);
            matrixProjection.put(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}).rewind();
        }
        GL11.glPushMatrix();
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GLU.gluLookAt((float)lightpos[0], (float)lightpos[1], (float)lightpos[2], (float)lightView[0], (float)lightView[1], (float)lightView[2], (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glGetFloat((int)2982, (FloatBuffer)matrixModelView);
        GL11.glPopMatrix();
        GL11.glLoadIdentity();
        GLU.gluPerspective((float)60.0f, (float)1.0f, (float)0.5f, (float)25.0f);
        GL11.glGetFloat((int)2982, (FloatBuffer)matrixProjection);
        GL11.glPopMatrix();
    }

    static void applyShadowMap() {
        shadowShader.bind();
        ARBMultitexture.glActiveTextureARB((int)33984);
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)shadowTexture.getID());
        shadowShader.setUniform1i(shadowShader.setUniformLocation("shadowMap"), 0);
        GL11.glTexParameteri((int)3553, (int)34892, (int)34894);
        GL11.glTexParameteri((int)3553, (int)34893, (int)515);
        float[] mBias = new float[]{0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f};
        FloatBuffer fb = BufferUtils.createFloatBuffer((int)16);
        fb.put(mBias).rewind();
        GL11.glMatrixMode((int)5890);
        GL11.glLoadMatrix((FloatBuffer)fb);
        GL11.glMultMatrix((FloatBuffer)matrixProjection);
        GL11.glMultMatrix((FloatBuffer)matrixModelView);
        GL11.glMultMatrix((FloatBuffer)matrixCameraInverse);
        GL11.glMatrixMode((int)5888);
        shadowtest.RenderWorld();
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        ARBMultitexture.glActiveTextureARB((int)33984);
        GL11.glDisable((int)3553);
        shadowShader.unbind();
    }

    static void DrawWalls() {
        float size = 5.0f;
        GL11.glBegin((int)7);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)(-size), (float)size, (float)0.0f);
        GL11.glVertex3f((float)(-size), (float)(-size), (float)0.0f);
        GL11.glVertex3f((float)size, (float)(-size), (float)0.0f);
        GL11.glVertex3f((float)size, (float)size, (float)0.0f);
        GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(-size), (float)size, (float)size);
        GL11.glVertex3f((float)(-size), (float)(-size), (float)size);
        GL11.glVertex3f((float)(-size), (float)(-size), (float)0.0f);
        GL11.glVertex3f((float)(-size), (float)size, (float)0.0f);
        GL11.glNormal3f((float)-1.0f, (float)0.0f, (float)0.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)size, (float)size, (float)0.0f);
        GL11.glVertex3f((float)size, (float)(-size), (float)0.0f);
        GL11.glVertex3f((float)size, (float)(-size), (float)size);
        GL11.glVertex3f((float)size, (float)size, (float)size);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)size, (float)(-size), (float)size);
        GL11.glVertex3f((float)size, (float)(-size), (float)0.0f);
        GL11.glVertex3f((float)(-size), (float)(-size), (float)0.0f);
        GL11.glVertex3f((float)(-size), (float)(-size), (float)size);
        GL11.glEnd();
    }

    static void look() {
        GLU.gluLookAt((float)camPosx, (float)camPosy, (float)camPosz, (float)camViewx, (float)camViewy, (float)camViewz, (float)camUpx, (float)camUpy, (float)camUpz);
    }

    static {
        lightpos = new float[]{0.0f, 2.0f, 5.0f, 0.0f};
        lightView = new float[]{0.0f, 0.0f, 0.0f};
        g_Direction = -0.04f;
        camPosx = 0.0f;
        camPosy = 9.0f;
        camPosz = 12.0f;
        camViewx = 0.0f;
        camViewy = 2.5f;
        camViewz = -2.0f;
        camUpx = 0.0f;
        camUpy = 1.0f;
        camUpz = 0.0f;
        shadowShader = new ShaderProgram();
        rotY = 0.0f;
        SHADOW_WIDTH = 512;
        SHADOW_HEIGHT = 512;
    }
}

