
uniform float lightsize;
varying vec3 lightposeye;
uniform float power;
uniform sampler2D texNormal;
uniform sampler2D texPos;
uniform sampler2D texColor;

uniform float xres;
uniform float yres;

void main(void)
{
	vec3 tcolor = texture2D(texColor, gl_FragCoord.xy*vec2(xres, yres)).rgb;
	vec3 tpos = texture2D(texPos, gl_FragCoord.xy*vec2(xres, yres)).rgb;
	vec3 tnormal = texture2D(texNormal, gl_FragCoord.xy*vec2(xres, yres)).rgb;
	float tglow = texture2D(texNormal, gl_FragCoord.xy*vec2(xres, yres)).a;

	vec3 norm = lightposeye.xyz-tpos;
	float diff = ((length(norm))*lightsize);
	float miff = pow(max(1.0-diff*diff,0.0), 1.0/power);
	miff = clamp(miff, 0.0, 1.0);

	float dottie = dot(tnormal, normalize(norm));
	dottie = max(dottie, 0.0);

	vec3 color = gl_Color.xyz;

	gl_FragData[0] = vec4(tcolor*(color*miff*dottie), 1.0);
}
