varying vec3 posVS;
varying vec3 normal;
varying vec3 pos;
varying vec2 uv;

attribute vec3 va_position, va_normal;

uniform mat4 projectmatrix;
uniform mat4 cameramatrix;
uniform mat4 normalmatrix;
uniform float waveTime;

void main(void)
{
	vec4 tposVS    = (cameramatrix * vec4(va_position, 1.0));

	posVS = tposVS.xyz;

	normal = normalize(normalmatrix*vec4(va_normal.xyz,0.0)).xyz;

	pos = pos;
	
	gl_FrontColor = gl_Color;

	gl_Position = projectmatrix*tposVS;
}
